/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.service.a;

import com.timevale.esign.paas.tech.bean.result.AddSealResult;
import com.timevale.esign.paas.tech.client.AbstractServiceClient;
import com.timevale.esign.paas.tech.constant.ErrorException;
import com.timevale.esign.paas.tech.enums.OrganizeTemplateType;
import com.timevale.esign.paas.tech.enums.PersonTemplateType;
import com.timevale.esign.paas.tech.enums.SealColor;
import com.timevale.esign.paas.tech.enums.StampRuleEnum;
import com.timevale.esign.paas.tech.service.TemplateSealService;
import com.timevale.esign.paas.tech.service.a.a;
import com.timevale.esign.paas.tech.util.CollectionUtil;
import com.timevale.seal.sdk.enums.CenterTypeEnum;
import com.timevale.seal.sdk.enums.FontEnum;
import com.timevale.seal.sdk.enums.FontLayoutTypeEnum;
import com.timevale.seal.sdk.enums.FontPullTypeEnum;
import com.timevale.seal.sdk.enums.SealTypeEnum;
import com.timevale.seal.sdk.enums.UnitEnum;
import com.timevale.seal.sdk.request.EllipseSealRequest;
import com.timevale.seal.sdk.request.RectSealRequest;
import com.timevale.seal.sdk.response.SealImageResponse;
import com.timevale.seal.sdk.util.FontUtil;
import com.timevale.seal.sdk.util.SealDrawUtil;
import com.timevale.seal.sdk.util.StringUtils;
import com.timevale.tech.sdk.utils.ImageUtil;
import esign.utils.Base64;
import esign.utils.bean.ResultUtil;
import esign.utils.exception.ErrorsDiscriptor;
import esign.utils.exception.SuperException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class j
extends a
implements TemplateSealService {
    private static final Logger log = LoggerFactory.getLogger(j.class);

    public j() {
    }

    public j(AbstractServiceClient abstractServiceClient) {
        super(abstractServiceClient);
    }

    @Override
    public AddSealResult createPersonalSeal(String name, PersonTemplateType type, SealColor color, StampRuleEnum stampRule) {
        try {
            this.a(name, type);
            name = this.a(name, stampRule);
            if (null == color) {
                color = SealColor.RED;
            }
            RectSealRequest rectSealRequest = new RectSealRequest();
            rectSealRequest.setText(name);
            rectSealRequest.setSealTypeEnum(SealTypeEnum.RECT_SEAL);
            if ("square".equalsIgnoreCase(type.templateType().disc())) {
                rectSealRequest.setWidth(18);
                rectSealRequest.setHeight(18);
            } else {
                rectSealRequest.setWidth(20);
                rectSealRequest.setHeight(10);
            }
            rectSealRequest.setFont(FontUtil.loadFontByRelativePath(FontEnum.F_SONG.getCode(), "font"));
            rectSealRequest.setSealColor(com.timevale.seal.sdk.enums.SealColor.getByCode(color.name()));
            rectSealRequest.setDpi(96);
            if (!"borderless".equalsIgnoreCase(type.templateType().disc())) {
                rectSealRequest.setBorderWidth(Float.valueOf(1.0f));
                rectSealRequest.setFont(FontUtil.loadFontByRelativePath(FontEnum.SONG.getCode(), "font"));
            }
            rectSealRequest.setUnit(UnitEnum.MM);
            rectSealRequest.setFontLayoutType(FontLayoutTypeEnum.LEFT_RIGHT_UP_DOWN);
            rectSealRequest.setFontPullType(FontPullTypeEnum.MOST_LEFT);
            SealImageResponse sealImageResponse = SealDrawUtil.draw(rectSealRequest);
            AddSealResult addSealResult = new AddSealResult();
            addSealResult.setSealData(Base64.encode(sealImageResponse.getBytes(), '\u0000'));
            return addSealResult;
        }
        catch (SuperException superException) {
            return ResultUtil.failed(superException, AddSealResult.class);
        }
        catch (Exception exception) {
            return ResultUtil.failed(ErrorException.CREATE_SEAL_PARAM_ERROR.e(exception.getMessage()), AddSealResult.class);
        }
    }

    @Override
    public AddSealResult createOfficialSeal(OrganizeTemplateType type, String roundText, List<String> hTexts, String qText, SealColor color) {
        try {
            this.a(roundText, hTexts, qText, type);
            if (null == color) {
                color = SealColor.RED;
            }
            EllipseSealRequest ellipseSealRequest = new EllipseSealRequest();
            ellipseSealRequest.setHorizontalTestList(hTexts);
            ellipseSealRequest.setSealColor(com.timevale.seal.sdk.enums.SealColor.getByCode(color.name()));
            ellipseSealRequest.setDpi(96);
            ellipseSealRequest.setSealTypeEnum(SealTypeEnum.ELLIPSE_SEAL);
            ellipseSealRequest.setTopSurroundText(roundText);
            ellipseSealRequest.setTopSurroundTextFont(FontUtil.loadFontByRelativePath(type.getFontName(), "font"));
            ellipseSealRequest.setHorizontalTestList(hTexts);
            ellipseSealRequest.setHorizontalTextFont(FontUtil.loadFontByRelativePath(type.getFontName(), "font"));
            ellipseSealRequest.setBottomSurroundText(qText);
            ellipseSealRequest.setBottomSurroundTextFont(FontUtil.loadFontByRelativePath(type.getFontName(), "font"));
            ellipseSealRequest.setUnit(UnitEnum.MM);
            ellipseSealRequest.setWidth(42);
            ellipseSealRequest.setHeight(42);
            ellipseSealRequest.setBorderWidth(Float.valueOf(1.2f));
            if (OrganizeTemplateType.OVAL.equals(type)) {
                ellipseSealRequest.setWidth(45);
                ellipseSealRequest.setHeight(30);
                ellipseSealRequest.setBorderWidth(Float.valueOf(1.0f));
            }
            if (OrganizeTemplateType.STAR.equals(type)) {
                ellipseSealRequest.setCenterTypeEnum(CenterTypeEnum.STAR);
            }
            SealImageResponse sealImageResponse = SealDrawUtil.draw(ellipseSealRequest);
            AddSealResult addSealResult = new AddSealResult();
            addSealResult.setSealData(Base64.encode(sealImageResponse.getBytes(), '\u0000'));
            return addSealResult;
        }
        catch (SuperException superException) {
            return ResultUtil.failed(superException, AddSealResult.class);
        }
    }

    private String dE(String string) {
        try {
            BufferedImage bufferedImage = ImageUtil.base64ToBufferedImage(string);
            bufferedImage = ImageUtil.hyalinizeImage(bufferedImage, 0.8f);
            return ImageUtil.imageToBase64(bufferedImage, "png");
        }
        catch (IOException iOException) {
            log.error("io exception thrown at method transparentImage", (Throwable)iOException);
            iOException.printStackTrace();
            return null;
        }
    }

    public void a(String string, List<String> list, String string2, OrganizeTemplateType organizeTemplateType) throws SuperException {
        if (string == null || string.length() <= 1) {
            log.error("the organize name is invalid.");
            throw ErrorsDiscriptor.Sdkseal_TextDecriptionLessThanTwoCharac.e();
        }
        if (string.length() > 50) {
            log.error("surroundText out of length:{}", (Object)string.length());
            throw ErrorException.CREATE_SEAL_PARAM_ERROR.e("\u4e0d\u652f\u6301\u4e94\u5341\u5b57\u4ee5\u4e0a\u7684\u4f01\u4e1a\u6a21\u677f\u5370\u7ae0");
        }
        if (CollectionUtil.isNotEmpty(list) && list.size() > 2) {
            throw ErrorException.CREATE_SEAL_PARAM_ERROR.e("\u4f01\u4e1a\u6a21\u677f\u5370\u7ae0\u53ea\u652f\u6301\u4e24\u6392\u6a2a\u5411\u6587");
        }
        if (CollectionUtil.isNotEmpty(list)) {
            for (String string3 : list) {
                if (string3.length() <= 20) continue;
                throw ErrorException.CREATE_SEAL_PARAM_ERROR.e("\u4f01\u4e1a\u6a21\u677f\u5370\u7ae0\u6a2a\u5411\u6587\u5b57\u6570\u4e0d\u80fd\u5927\u4e8e20\u4e2a\u5b57");
            }
        }
        if (!StringUtils.isBlank(string2) && string2.length() > 20) {
            log.error("qtext is out of length. htext:{} ", (Object)string2);
            throw ErrorException.CREATE_SEAL_PARAM_ERROR.e("\u4f01\u4e1a\u6a21\u677f\u5370\u7ae0\u4e0d\u652f\u6301\u4e8c\u5341\u5b57\u4ee5\u4e0a\u7684\u4e0b\u5f26\u6587");
        }
        if (organizeTemplateType == null) {
            throw ErrorException.CREATE_SEAL_PARAM_ERROR.e("type\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void a(String string, PersonTemplateType personTemplateType) throws SuperException {
        if (StringUtils.isBlank(string) || string.length() < 2) {
            throw ErrorsDiscriptor.Sdkseal_TextDecriptionLessThanTwoCharac.e();
        }
        if (string.length() > 18) {
            throw ErrorsDiscriptor.Sdkseal_TextDecriptionOutOfRange.e();
        }
        if (personTemplateType == null) {
            throw ErrorException.CREATE_SEAL_PARAM_ERROR.e("type\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private String a(String string, StampRuleEnum stampRuleEnum) {
        if (stampRuleEnum == null) {
            return string;
        }
        if (StampRuleEnum.SEAL_ONE.equals((Object)stampRuleEnum)) {
            return string + "\u5370";
        }
        if (StampRuleEnum.SEAL_TWO.equals((Object)stampRuleEnum)) {
            return string + "\u4e4b\u5370";
        }
        return string;
    }
}

