/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.primitives;

import com.timevale.guava.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class Primitives {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER_TYPE;
    private static final Map<Class<?>, Class<?>> WRAPPER_TO_PRIMITIVE_TYPE;

    private Primitives() {
    }

    private static void add(Map<Class<?>, Class<?>> forward, Map<Class<?>, Class<?>> backward, Class<?> key, Class<?> value) {
        forward.put(key, value);
        backward.put(value, key);
    }

    public static Set<Class<?>> allPrimitiveTypes() {
        return PRIMITIVE_TO_WRAPPER_TYPE.keySet();
    }

    public static Set<Class<?>> allWrapperTypes() {
        return WRAPPER_TO_PRIMITIVE_TYPE.keySet();
    }

    public static boolean isWrapperType(Class<?> type) {
        return WRAPPER_TO_PRIMITIVE_TYPE.containsKey(Preconditions.checkNotNull(type));
    }

    public static <T> Class<T> wrap(Class<T> type) {
        Preconditions.checkNotNull(type);
        Class<?> clazz = PRIMITIVE_TO_WRAPPER_TYPE.get(type);
        return clazz == null ? type : clazz;
    }

    public static <T> Class<T> unwrap(Class<T> type) {
        Preconditions.checkNotNull(type);
        Class<?> clazz = WRAPPER_TO_PRIMITIVE_TYPE.get(type);
        return clazz == null ? type : clazz;
    }

    static {
        HashMap hashMap = new HashMap(16);
        HashMap hashMap2 = new HashMap(16);
        Primitives.add(hashMap, hashMap2, Boolean.TYPE, Boolean.class);
        Primitives.add(hashMap, hashMap2, Byte.TYPE, Byte.class);
        Primitives.add(hashMap, hashMap2, Character.TYPE, Character.class);
        Primitives.add(hashMap, hashMap2, Double.TYPE, Double.class);
        Primitives.add(hashMap, hashMap2, Float.TYPE, Float.class);
        Primitives.add(hashMap, hashMap2, Integer.TYPE, Integer.class);
        Primitives.add(hashMap, hashMap2, Long.TYPE, Long.class);
        Primitives.add(hashMap, hashMap2, Short.TYPE, Short.class);
        Primitives.add(hashMap, hashMap2, Void.TYPE, Void.class);
        PRIMITIVE_TO_WRAPPER_TYPE = Collections.unmodifiableMap(hashMap);
        WRAPPER_TO_PRIMITIVE_TYPE = Collections.unmodifiableMap(hashMap2);
    }
}

