/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.seal.sdk.drawer.impl;

import com.timevale.seal.sdk.drawer.AbstractImageDrawer;
import com.timevale.seal.sdk.drawer.request.InnerRequest;
import com.timevale.seal.sdk.drawer.request.ellipse.CenterTextInfo;
import com.timevale.seal.sdk.drawer.request.ellipse.EllipseInnerRequest;
import com.timevale.seal.sdk.drawer.request.ellipse.HengTextInfo;
import com.timevale.seal.sdk.drawer.request.ellipse.SerialTextInfo;
import com.timevale.seal.sdk.drawer.request.ellipse.SurroundTextInfo;
import com.timevale.seal.sdk.enums.CenterTypeEnum;
import com.timevale.seal.sdk.exception.SealSdkException;
import com.timevale.seal.sdk.util.StringUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEllipseImageDrawer
extends AbstractImageDrawer {
    private static final Logger log = LoggerFactory.getLogger(DefaultEllipseImageDrawer.class);

    @Override
    protected void customDrawBoundary(int boundaryStartPointX, int boundaryStartPointY, int boundaryWidth, int boundaryHeight, Graphics2D g2d) {
        Ellipse2D.Float float_ = new Ellipse2D.Float(boundaryStartPointX, boundaryStartPointY, boundaryWidth, boundaryHeight);
        g2d.draw(float_);
    }

    @Override
    public <T extends InnerRequest> void customDraw(T obj, Graphics2D g2d) {
        EllipseInnerRequest ellipseInnerRequest = (EllipseInnerRequest)obj;
        Point point = this.getCenterPoint(ellipseInnerRequest);
        this.drawSurroundText(g2d, ellipseInnerRequest.getTopSurroundTextInfo(), point, true);
        this.drawCenterTextInfo(ellipseInnerRequest, g2d);
        this.drawHengText(ellipseInnerRequest, g2d);
        this.drawSerial(ellipseInnerRequest, g2d);
        this.drawSurroundText(g2d, ellipseInnerRequest.getBottomSurroundTextInfo(), point, false);
    }

    private void drawSerial(EllipseInnerRequest request, Graphics2D g2d) {
        SerialTextInfo serialTextInfo = request.getSerialTextInfo();
        if (serialTextInfo == null || StringUtils.isBlank(serialTextInfo.getText())) {
            return;
        }
        String string = serialTextInfo.getText();
        char[] cArray = string.toCharArray();
        FontMetrics fontMetrics = g2d.getFontMetrics(serialTextInfo.getFont());
        int n2 = this.getMaxWordWidth(cArray, fontMetrics);
        double d2 = (double)serialTextInfo.getWidth() / (double)n2;
        double d3 = (double)serialTextInfo.getHeight() / (double)fontMetrics.getHeight();
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d2, d3);
        Font font = serialTextInfo.getFont().deriveFont(affineTransform);
        g2d.setFont(font);
        fontMetrics = g2d.getFontMetrics();
        int n3 = this.getTotalWordWidth(cArray, fontMetrics);
        int n4 = (request.getWidth() >>> 1) - (n3 >>> 1);
        int n5 = (request.getHeight() >>> 1) + serialTextInfo.getWordTopFromMid() + serialTextInfo.getHeight() - fontMetrics.getDescent();
        log.debug("\u5e8f\u5217\u53f7\u5750\u6807 x = {}, y = {}", (Object)n4, (Object)n5);
        g2d.drawString(string, n4, n5);
    }

    protected Point getCenterPoint(InnerRequest request) {
        return new Point(request.getWidth() >>> 1, request.getHeight() >>> 1);
    }

    @Override
    protected <T extends InnerRequest> void validateRequest(T obj) {
        EllipseInnerRequest ellipseInnerRequest = (EllipseInnerRequest)obj;
        this.validateTopSurroundTextInfo(ellipseInnerRequest.getTopSurroundTextInfo());
        this.validateHengTextInfo(ellipseInnerRequest.getHengTextInfo(), ellipseInnerRequest);
        this.validateCenterTextInfo(ellipseInnerRequest.getCenterTextInfo());
        this.validateSerialTextInfo(ellipseInnerRequest.getSerialTextInfo(), ellipseInnerRequest);
        this.validateBottomSurroundTextInfo(ellipseInnerRequest.getBottomSurroundTextInfo());
    }

    protected void validateSerialTextInfo(SerialTextInfo serialTextInfo, EllipseInnerRequest request) {
        if (serialTextInfo == null || StringUtils.isBlank(serialTextInfo.getText())) {
            return;
        }
        Font font = serialTextInfo.getFont();
        if (font == null) {
            throw new SealSdkException("\u5e8f\u5217\u53f7\u5b57\u4f53\u6ca1\u6709\u6307\u5b9a");
        }
    }

    private void validateCenterTextInfo(CenterTextInfo centerTextInfo) {
        if (null == centerTextInfo) {
            return;
        }
        String string = centerTextInfo.getText();
        if (StringUtils.isBlank(string)) {
            return;
        }
        Font font = centerTextInfo.getFont();
        if (font == null) {
            throw new SealSdkException("\u4e2d\u6587\u6587\u5b57\u5b57\u4f53\u4e3a\u7a7a");
        }
        if (null == centerTextInfo.getCenterTypeEnum()) {
            throw new SealSdkException("\u4e2d\u5fc3\u5185\u5bb9 centerTypeEnum\u4e3a\u7a7a");
        }
        if (CenterTypeEnum.STAR.equals((Object)centerTextInfo.getCenterTypeEnum()) || CenterTypeEnum.NUMBER.equals((Object)centerTextInfo.getCenterTypeEnum())) {
            if (centerTextInfo.getWidth() <= 0) {
                throw new SealSdkException("\u4e2d\u5fc3\u5185\u5bb9 width <= 0");
            }
            if (centerTextInfo.getHeight() <= 0) {
                throw new SealSdkException("\u4e2d\u5fc3\u5185\u5bb9 height <= 0");
            }
        }
    }

    private void validateBottomSurroundTextInfo(SurroundTextInfo bottomSurroundTextInfo) {
        if (bottomSurroundTextInfo == null) {
            return;
        }
        String string = bottomSurroundTextInfo.getText();
        if (StringUtils.isBlank(string)) {
            return;
        }
        Font font = bottomSurroundTextInfo.getFont();
        if (null == font) {
            throw new SealSdkException("\u4e0b\u5f26\u6587\u5b57\u4f53\u4e3a\u7a7a");
        }
        int n2 = bottomSurroundTextInfo.getArcAng();
        if (n2 <= 0) {
            throw new SealSdkException("\u4e0b\u5f26\u6587\u5b57\u7b26\u4e32\u6240\u5360\u6247\u533a\u89d2\u5ea6\u5e94\u8be5\u5927\u4e8e0");
        }
        float f2 = bottomSurroundTextInfo.getMinRat();
        if (f2 == 0.0f) {
            throw new SealSdkException("\u4e0b\u5f26\u6587\u4ece\u8fb9\u7ebf\u5411\u4e2d\u5fc3\u7684\u79fb\u52a8\u56e0\u5b50\u7b49\u4e8e0");
        }
        int n3 = bottomSurroundTextInfo.getWidth();
        if (n3 <= 0) {
            throw new SealSdkException("\u4e0b\u5f26\u6587\u7684\u5bbd\u5ea6\u5e94\u8be5\u5927\u4e8e0");
        }
        int n4 = bottomSurroundTextInfo.getHeight();
        if (n4 <= 0) {
            throw new SealSdkException("\u4e0b\u5f26\u6587\u7684\u9ad8\u5ea6\u5e94\u8be5\u5927\u4e8e0");
        }
    }

    protected void validateHengTextInfo(HengTextInfo hengTextInfo, EllipseInnerRequest request) {
        if (hengTextInfo == null) {
            return;
        }
        String string = hengTextInfo.getText();
        if (StringUtils.isBlank(string)) {
            return;
        }
        Font font = hengTextInfo.getFont();
        if (null == font) {
            throw new SealSdkException("\u6a2a\u5411\u6587\u5b57\u4f53\u4e3a\u7a7a");
        }
    }

    private void validateTopSurroundTextInfo(SurroundTextInfo surroundTextInfo) {
        if (surroundTextInfo == null || StringUtils.isBlank(surroundTextInfo.getText())) {
            return;
        }
        String string = surroundTextInfo.getText();
        if (StringUtils.isBlank(string)) {
            throw new SealSdkException("\u73af\u7ed5\u6587\u6587\u5b57\u4e3a\u7a7a");
        }
        Font font = surroundTextInfo.getFont();
        if (font == null) {
            throw new SealSdkException("\u73af\u7ed5\u6587\u6587\u5b57\u5b57\u4f53\u4e3a\u7a7a");
        }
        if (surroundTextInfo.getScaleX() <= 0.0) {
            throw new SealSdkException("\u73af\u7ed5\u6587\u6587\u5b57\u5728X\u8f74\u65b9\u5411\u4e0a\u4f38\u7f29\u6bd4\u4f8b\u5e94\u8be5\u5927\u4e8e0");
        }
        if (surroundTextInfo.getArcAng() <= 0) {
            throw new SealSdkException("\u73af\u7ed5\u6587\u6587\u5b57\u6240\u5360\u6247\u533a\u7684\u89d2\u5ea6\u5927\u5c0f\u5e94\u8be5\u5927\u4e8e0");
        }
        if (surroundTextInfo.getMinRat() <= 0.0f) {
            throw new SealSdkException("\u73af\u7ed5\u6587\u6587\u5b57\u4ece\u8fb9\u7ebf\u5411\u4e2d\u5fc3\u7684\u79fb\u52a8\u56e0\u5b50\u5e94\u8be5\u5927\u4e8e0");
        }
    }

    private void drawSurroundText(Graphics2D g2, SurroundTextInfo surroundTextInfo, Point center, boolean top) {
        if (surroundTextInfo == null || StringUtils.isBlank(surroundTextInfo.getText())) {
            return;
        }
        Font font = surroundTextInfo.getFont();
        FontMetrics fontMetrics = g2.getFontMetrics(font);
        int n2 = fontMetrics.getAscent();
        int n3 = center.x - n2;
        int n4 = center.y - n2;
        this.doDrawSurroundText(g2, surroundTextInfo, center, n3, n4, top);
    }

    protected void doDrawSurroundText(Graphics2D g2, SurroundTextInfo surroundTextInfo, Point center, int radioX, int radioY, boolean top) {
        int n2 = surroundTextInfo.getArcAng();
        String string = surroundTextInfo.getText();
        double d2 = surroundTextInfo.getScaleX();
        double d3 = 1.0;
        if (d2 == 0.0) {
            FontMetrics fontMetrics = g2.getFontMetrics(surroundTextInfo.getFont());
            int n3 = this.getMaxWordWidth(string.toCharArray(), fontMetrics);
            d2 = (double)surroundTextInfo.getWidth() / (double)n3;
            d3 = (double)surroundTextInfo.getHeight() / (double)fontMetrics.getHeight();
        }
        float f2 = surroundTextInfo.getMinRat();
        double d4 = top ? (double)(-90.0f - (float)n2 / 2.0f) : (double)(90.0f - (float)n2 / 2.0f);
        int n4 = string.length();
        double d5 = 0.5;
        int n5 = (int)Math.ceil((double)n2 / d5) + 1;
        double[] dArray = new double[n5];
        double[] dArray2 = new double[n5];
        int n6 = 0;
        double d6 = 0.0;
        dArray[n6] = d4;
        dArray2[n6] = d6;
        ++n6;
        double d7 = d4 * Math.PI / 180.0;
        double d8 = (double)radioX * Math.cos(d7) + center.getX();
        double d9 = (double)radioY * Math.sin(d7) + center.getY();
        double d10 = d4 + d5;
        while (n6 < n5) {
            d7 = d10 * Math.PI / 180.0;
            double d11 = (double)radioX * Math.cos(d7) + center.getX();
            double d12 = (double)radioY * Math.sin(d7) + center.getY();
            dArray[n6] = d10;
            dArray2[n6] = d6 += Math.sqrt((d8 - d11) * (d8 - d11) + (d9 - d12) * (d9 - d12));
            d8 = d11;
            d9 = d12;
            ++n6;
            d10 += d5;
        }
        Font font = surroundTextInfo.getFont();
        g2.setFont(font);
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d2, d3);
        Font font2 = font.deriveFont(affineTransform);
        double d13 = d6 / (double)n4;
        for (int i2 = 0; i2 < n4; ++i2) {
            double d14 = (double)i2 * d13 + d13 / 2.0;
            double d15 = 0.0;
            for (int i3 = 0; i3 < dArray2.length - 1; ++i3) {
                if (!(dArray2[i3] <= d14) || !(d14 <= dArray2[i3 + 1])) continue;
                d15 = d14 >= (dArray2[i3] + dArray2[i3 + 1]) / 2.0 ? dArray[i3 + 1] : dArray[i3];
                break;
            }
            d7 = d15 * Math.PI / 180.0;
            double d16 = (double)((float)radioX * (float)Math.cos(d7)) + center.getX();
            double d17 = (double)((float)radioY * (float)Math.sin(d7)) + center.getY();
            double d18 = Math.atan2((double)radioY * Math.cos(d7), (double)(-radioX) * Math.sin(d7));
            double d19 = d18 + 1.5707963267948966;
            int n7 = top ? i2 : string.length() - 1 - i2;
            String string2 = string.substring(n7, n7 + 1);
            g2.setFont(font2);
            FontMetrics fontMetrics = g2.getFontMetrics();
            int n8 = fontMetrics.getAscent();
            int n9 = fontMetrics.getLeading();
            int n10 = fontMetrics.stringWidth(string2);
            int n11 = n8 - n9;
            if (top) {
                d16 += (double)((float)n11 * f2) * Math.cos(d19);
                d17 += (double)((float)n11 * f2) * Math.sin(d19);
                d16 += (double)((float)(-n10) / 2.0f) * Math.cos(d18);
                d17 += (double)((float)(-n10) / 2.0f) * Math.sin(d18);
                d19 -= 1.5707963267948966;
            } else {
                d16 += (double)((float)n11 * f2) * Math.cos(d19);
                d17 += (double)((float)n11 * f2) * Math.sin(d19);
                d16 += (double)((float)n10 / 2.0f) * Math.cos(d18);
                d17 += (double)((float)n10 / 2.0f) * Math.sin(d18);
                d19 += 1.5707963267948966;
            }
            AffineTransform affineTransform2 = AffineTransform.getRotateInstance(d19);
            affineTransform2.scale(d2, 1.0);
            Font font3 = font.deriveFont(affineTransform2);
            g2.setFont(font3);
            g2.drawString(string2, (float)d16, (float)d17);
        }
    }

    private void drawCenterTextInfo(EllipseInnerRequest ellipseImageInnerRequest, Graphics2D g2) {
        CenterTextInfo centerTextInfo = ellipseImageInnerRequest.getCenterTextInfo();
        if (centerTextInfo == null || StringUtils.isBlank(centerTextInfo.getText())) {
            return;
        }
        String string = centerTextInfo.getText();
        FontMetrics fontMetrics = g2.getFontMetrics(centerTextInfo.getFont());
        double d2 = (double)centerTextInfo.getHeight() / (double)fontMetrics.getAscent();
        if (CenterTypeEnum.STAR.equals((Object)centerTextInfo.getCenterTypeEnum())) {
            log.debug("centerText scaleX = {}, scaleY = {}", (Object)d2, (Object)d2);
            AffineTransform affineTransform = AffineTransform.getScaleInstance(d2, d2);
            Font font = centerTextInfo.getFont().deriveFont(affineTransform);
            g2.setFont(font);
            fontMetrics = g2.getFontMetrics();
            int n2 = this.getTotalWordWidth(string.toCharArray(), fontMetrics);
            int n3 = (ellipseImageInnerRequest.getWidth() >>> 1) - (n2 >>> 1);
            int n4 = ellipseImageInnerRequest.getHeight() - (ellipseImageInnerRequest.getHeight() * 3 >> 3);
            g2.drawString(string, n3, n4);
        } else if (CenterTypeEnum.NUMBER.equals((Object)centerTextInfo.getCenterTypeEnum())) {
            char[] cArray = string.toCharArray();
            int n5 = this.getMaxWordWidth(cArray, fontMetrics);
            double d3 = (double)centerTextInfo.getWidth() / (double)n5;
            log.debug("centerText scaleX = {}, scaleY = {}", (Object)d3, (Object)d2);
            AffineTransform affineTransform = AffineTransform.getScaleInstance(d3, d2);
            Font font = centerTextInfo.getFont().deriveFont(affineTransform);
            g2.setFont(font);
            fontMetrics = g2.getFontMetrics();
            n5 = this.getTotalWordWidth(cArray, fontMetrics);
            int n6 = (ellipseImageInnerRequest.getWidth() >>> 1) - (n5 >>> 1);
            int n7 = ellipseImageInnerRequest.getHeight() - (ellipseImageInnerRequest.getHeight() * 7 >> 4);
            g2.drawString(string, n6, n7 -= fontMetrics.getDescent() >> 1);
        }
    }

    private void drawHengText(EllipseInnerRequest request, Graphics2D g2) {
        int n2;
        int n3;
        HengTextInfo hengTextInfo = request.getHengTextInfo();
        if (hengTextInfo == null) {
            return;
        }
        List<String> list = hengTextInfo.getTextList();
        if (StringUtils.isBlank(hengTextInfo.getText()) && (list == null || list.isEmpty())) {
            return;
        }
        if (list != null && !list.isEmpty()) {
            this.drawHengTextLines(request, hengTextInfo, g2);
            return;
        }
        FontMetrics fontMetrics = g2.getFontMetrics(hengTextInfo.getFont());
        String string = hengTextInfo.getText();
        char[] cArray = string.toCharArray();
        int n4 = this.getMaxWordWidth(cArray, fontMetrics);
        if (0 == hengTextInfo.getWidth() || 0 == hengTextInfo.getHeight() || 0 == hengTextInfo.getWordTopFromMid()) {
            int n5 = this.getTotalWordWidth(cArray, fontMetrics);
            double d2 = (double)(request.getWidth() >> 1) / (double)n5;
            double d3 = (double)(request.getHeight() >> 3) / (double)fontMetrics.getHeight();
            AffineTransform affineTransform = AffineTransform.getScaleInstance(d2, d3);
            Font font = hengTextInfo.getFont().deriveFont(affineTransform);
            g2.setFont(font);
            fontMetrics = g2.getFontMetrics();
            n5 = this.getTotalWordWidth(cArray, fontMetrics);
            n3 = (request.getWidth() >> 1) - (n5 >> 1);
            n2 = (request.getHeight() * 3 >> 2) + fontMetrics.getDescent();
        } else {
            double d4 = (double)hengTextInfo.getWidth() / (double)n4;
            double d5 = (double)hengTextInfo.getHeight() / (double)fontMetrics.getHeight();
            AffineTransform affineTransform = AffineTransform.getScaleInstance(d4, d5);
            Font font = hengTextInfo.getFont().deriveFont(affineTransform);
            g2.setFont(font);
            fontMetrics = g2.getFontMetrics();
            int n6 = this.getTotalWordWidth(cArray, fontMetrics);
            n3 = (request.getWidth() >> 1) - (n6 >> 1);
            n2 = (request.getHeight() >>> 1) + hengTextInfo.getWordTopFromMid() + hengTextInfo.getHeight() - fontMetrics.getDescent();
        }
        log.debug("\u6a2a\u5411\u6587\u5750\u6807 x = {}, y = {}", (Object)n3, (Object)n2);
        g2.drawString(string, n3, n2);
    }

    private void drawHengTextLines(EllipseInnerRequest request, HengTextInfo hengTextInfo, Graphics2D g2) {
        List<String> list = hengTextInfo.getTextList();
        FontMetrics fontMetrics = g2.getFontMetrics(hengTextInfo.getFont());
        int n2 = request.getHeight() >>> 3;
        int n3 = ((n2 >>> 1) + n2 * 3 / 4) / list.size();
        double d2 = (double)n3 / (double)fontMetrics.getHeight();
        int n4 = (request.getHeight() >> 1) + n2 + (n2 >> 2);
        int n5 = -1;
        int n6 = 0;
        for (String string : list) {
            if (string.length() < n6) continue;
            ++n5;
            n6 = string.length();
        }
        String string = list.get(n5);
        int n7 = this.getTotalWordWidth(string.toCharArray(), fontMetrics);
        double d3 = (double)(request.getWidth() >> 1) / (double)n7;
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d3, d2);
        Font font = hengTextInfo.getFont().deriveFont(affineTransform);
        g2.setFont(font);
        for (String string2 : list) {
            char[] cArray = string2.toCharArray();
            fontMetrics = g2.getFontMetrics();
            n7 = this.getTotalWordWidth(cArray, fontMetrics);
            int n8 = (request.getWidth() >> 1) - (n7 >> 1);
            g2.drawString(string2, n8, n4 += fontMetrics.getHeight());
        }
    }

    protected void helpLine(InnerRequest request, Graphics2D g2) {
        Color color = g2.getColor();
        g2.setColor(Color.black);
        int n2 = request.getWidth();
        int n3 = request.getHeight();
        g2.drawLine(0, 0, n2, 0);
        g2.drawLine(0, n3 >>>= 1, n2, n3);
        g2.drawLine(0, n3 + n3 / 2, n2, n3 + n3 / 2);
        g2.drawLine(0, n3 + n3 / 4, n2, n3 + n3 / 4);
        g2.drawLine(0, request.getHeight() - (n3 >>>= 1) / 2, n2, request.getHeight() - n3 / 2);
        g2.setColor(Color.black);
        n3 = request.getHeight();
        g2.drawLine(0, 0, 0, n3);
        g2.drawLine(request.getWidth(), 0, request.getWidth(), n3);
        g2.drawLine(n2 / 2, 0, n2 / 2, n3);
        g2.drawLine(n2 / 4, 0, n2 / 4, n3);
        g2.drawLine(n2 / 2 + n2 / 4, 0, n2 / 2 + n2 / 4, n3);
        g2.setColor(color);
    }
}

