/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.text.pdf.f;

import com.timevale.tgtext.text.pdf.f.l;

final class m {
    private final l bur;
    private final int[] coefficients;

    m(l l2, int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException();
        }
        this.bur = l2;
        int n2 = nArray.length;
        if (n2 > 1 && nArray[0] == 0) {
            int n3;
            for (n3 = 1; n3 < n2 && nArray[n3] == 0; ++n3) {
            }
            if (n3 == n2) {
                this.coefficients = l2.Xf().coefficients;
            } else {
                this.coefficients = new int[n2 - n3];
                System.arraycopy(nArray, n3, this.coefficients, 0, this.coefficients.length);
            }
        } else {
            this.coefficients = nArray;
        }
    }

    int[] getCoefficients() {
        return this.coefficients;
    }

    int getDegree() {
        return this.coefficients.length - 1;
    }

    boolean isZero() {
        return this.coefficients[0] == 0;
    }

    int getCoefficient(int degree) {
        return this.coefficients[this.coefficients.length - 1 - degree];
    }

    int evaluateAt(int a2) {
        if (a2 == 0) {
            return this.getCoefficient(0);
        }
        int n2 = this.coefficients.length;
        if (a2 == 1) {
            int n3 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                n3 = l.addOrSubtract(n3, this.coefficients[i2]);
            }
            return n3;
        }
        int n4 = this.coefficients[0];
        for (int i3 = 1; i3 < n2; ++i3) {
            n4 = l.addOrSubtract(this.bur.multiply(a2, n4), this.coefficients[i3]);
        }
        return n4;
    }

    m a(m m2) {
        int[] nArray;
        if (!this.bur.equals(m2.bur)) {
            throw new IllegalArgumentException("GF256Polys do not have same GF256 field");
        }
        if (this.isZero()) {
            return m2;
        }
        if (m2.isZero()) {
            return this;
        }
        int[] nArray2 = this.coefficients;
        int[] nArray3 = m2.coefficients;
        if (nArray2.length > nArray3.length) {
            nArray = nArray2;
            nArray2 = nArray3;
            nArray3 = nArray;
        }
        nArray = new int[nArray3.length];
        int n2 = nArray3.length - nArray2.length;
        System.arraycopy(nArray3, 0, nArray, 0, n2);
        for (int i2 = n2; i2 < nArray3.length; ++i2) {
            nArray[i2] = l.addOrSubtract(nArray2[i2 - n2], nArray3[i2]);
        }
        return new m(this.bur, nArray);
    }

    m b(m m2) {
        if (!this.bur.equals(m2.bur)) {
            throw new IllegalArgumentException("GF256Polys do not have same GF256 field");
        }
        if (this.isZero() || m2.isZero()) {
            return this.bur.Xf();
        }
        int[] nArray = this.coefficients;
        int n2 = nArray.length;
        int[] nArray2 = m2.coefficients;
        int n3 = nArray2.length;
        int[] nArray3 = new int[n2 + n3 - 1];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = nArray[i2];
            for (int i3 = 0; i3 < n3; ++i3) {
                nArray3[i2 + i3] = l.addOrSubtract(nArray3[i2 + i3], this.bur.multiply(n4, nArray2[i3]));
            }
        }
        return new m(this.bur, nArray3);
    }

    m ji(int n2) {
        if (n2 == 0) {
            return this.bur.Xf();
        }
        if (n2 == 1) {
            return this;
        }
        int n3 = this.coefficients.length;
        int[] nArray = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            nArray[i2] = this.bur.multiply(this.coefficients[i2], n2);
        }
        return new m(this.bur, nArray);
    }

    m bb(int n2, int n3) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        if (n3 == 0) {
            return this.bur.Xf();
        }
        int n4 = this.coefficients.length;
        int[] nArray = new int[n4 + n2];
        for (int i2 = 0; i2 < n4; ++i2) {
            nArray[i2] = this.bur.multiply(this.coefficients[i2], n3);
        }
        return new m(this.bur, nArray);
    }

    m[] c(m m2) {
        if (!this.bur.equals(m2.bur)) {
            throw new IllegalArgumentException("GF256Polys do not have same GF256 field");
        }
        if (m2.isZero()) {
            throw new IllegalArgumentException("Divide by 0");
        }
        m m3 = this.bur.Xf();
        m m4 = this;
        int n2 = m2.getCoefficient(m2.getDegree());
        int n3 = this.bur.inverse(n2);
        while (m4.getDegree() >= m2.getDegree() && !m4.isZero()) {
            int n4 = m4.getDegree() - m2.getDegree();
            int n5 = this.bur.multiply(m4.getCoefficient(m4.getDegree()), n3);
            m m5 = m2.bb(n4, n5);
            m m6 = this.bur.ba(n4, n5);
            m3 = m3.a(m6);
            m4 = m4.a(m5);
        }
        return new m[]{m3, m4};
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(8 * this.getDegree());
        for (int i2 = this.getDegree(); i2 >= 0; --i2) {
            int n2 = this.getCoefficient(i2);
            if (n2 == 0) continue;
            if (n2 < 0) {
                stringBuffer.append(" - ");
                n2 = -n2;
            } else if (stringBuffer.length() > 0) {
                stringBuffer.append(" + ");
            }
            if (i2 == 0 || n2 != 1) {
                int n3 = this.bur.log(n2);
                if (n3 == 0) {
                    stringBuffer.append('1');
                } else if (n3 == 1) {
                    stringBuffer.append('a');
                } else {
                    stringBuffer.append("a^");
                    stringBuffer.append(n3);
                }
            }
            if (i2 == 0) continue;
            if (i2 == 1) {
                stringBuffer.append('x');
                continue;
            }
            stringBuffer.append("x^");
            stringBuffer.append(i2);
        }
        return stringBuffer.toString();
    }
}

