/*
 * Decompiled with CFR 0.152.
 */
package esign.utils.network;

import esign.utils.asserts.AssertSupport;
import esign.utils.exception.ErrorsDiscriptor;
import esign.utils.exception.SuperException;

public abstract class NtmIPUtil {
    private static final String IP_ALL = "0.0.0.0";

    public static byte[] ip2bytes(String ip) throws SuperException {
        AssertSupport.assertNotnull(ip, ErrorsDiscriptor.MissingArgumentsSpec.e("ip"));
        ip = NtmIPUtil.defaultIp(ip);
        String[] stringArray = ip.split("\\.");
        AssertSupport.assertTrue(null != stringArray && 4 == stringArray.length, ErrorsDiscriptor.InvalidIPv4Taken.e(ip));
        byte[] byArray = new byte[4];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            int n2;
            try {
                n2 = Integer.parseInt(stringArray[i2]);
            }
            catch (Exception exception) {
                throw ErrorsDiscriptor.InvalidIPv4Taken.e(ip);
            }
            AssertSupport.assertTrue(n2 >= 0 && n2 <= 255, ErrorsDiscriptor.InvalidIPv4Taken.e(ip));
            byArray[i2] = (byte)(n2 & 0xFF);
        }
        return byArray;
    }

    public static long ip2long(byte[] bytes) throws SuperException {
        AssertSupport.assertNotnull(bytes, ErrorsDiscriptor.MissingArgumentsSpec.e("ip"));
        AssertSupport.assertTrue(4 == bytes.length, ErrorsDiscriptor.InvalidIPv4.e());
        long l2 = bytes[3] & 0xFF;
        l2 |= (long)(bytes[2] << 8 & 0xFF00);
        l2 |= (long)(bytes[1] << 16 & 0xFF0000);
        return l2 |= (long)(bytes[0] << 24 & 0xFF000000);
    }

    public static long ip2long(String ip) throws SuperException {
        byte[] byArray = NtmIPUtil.ip2bytes(ip);
        return NtmIPUtil.ip2long(byArray);
    }

    public static byte[] ip2bytes(long ip) {
        byte[] byArray = new byte[]{(byte)(ip >>> 24 & 0xFFL), (byte)(ip >>> 16 & 0xFFL), (byte)(ip >>> 8 & 0xFFL), (byte)(ip & 0xFFL)};
        return byArray;
    }

    public static String ip2sring(long ip) {
        byte[] byArray = NtmIPUtil.ip2bytes(ip);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(byArray[0]).append('.');
        stringBuilder.append(byArray[1]).append('.');
        stringBuilder.append(byArray[2]).append('.');
        stringBuilder.append(byArray[3]);
        return stringBuilder.toString();
    }

    private static String defaultIp(String ip) {
        return ip.equalsIgnoreCase("*") ? IP_ALL : ip;
    }
}

