/*
 * Decompiled with CFR 0.152.
 */
package esign.utils.security;

import com.timevale.tgtext.bouncycastle.cert.X509CertificateHolder;
import esign.utils.security.provider.SecurityProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Date;

public class CertInfo {
    private String serialNumber;
    private String version;
    private Date startTime;
    private Date endTime;
    private CertDistinguished issuer;
    private CertDistinguished subject;

    public CertInfo(X509Certificate cert) {
        this.init(cert);
    }

    public CertInfo(X509CertificateHolder cert, SecurityProvider provider) {
        this.init(cert, provider);
    }

    public CertInfo(byte[] cert, SecurityProvider provider) {
        this.init(cert, provider);
    }

    private void init(X509Certificate cert) {
        this.serialNumber = cert.getSerialNumber().toString(16);
        this.version = String.valueOf(cert.getVersion());
        this.startTime = cert.getNotBefore();
        this.endTime = cert.getNotAfter();
        this.issuer = new CertDistinguished(cert.getIssuerDN());
        this.subject = new CertDistinguished(cert.getSubjectDN());
    }

    private void init(X509CertificateHolder certHolder, SecurityProvider provider) {
        try {
            this.init(certHolder.getEncoded(), provider);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void init(byte[] certBytes, SecurityProvider provider) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(certBytes);
        X509Certificate x509Certificate = null;
        try {
            while (((InputStream)byteArrayInputStream).available() > 0) {
                x509Certificate = (X509Certificate)provider.factory().generateCertificate(byteArrayInputStream);
            }
            this.init(x509Certificate);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getVersion() {
        return this.version;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public CertDistinguished getIssuer() {
        return this.issuer;
    }

    public CertDistinguished getSubject() {
        return this.subject;
    }

    private String getInfoFromDn(String dn2, String key) {
        String[] stringArray = dn2.split(",");
        if (0 == stringArray.length) {
            return "";
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = stringArray[i2].trim();
            if (!stringArray[i2].toUpperCase().contains(key.toUpperCase())) continue;
            return stringArray[i2].substring(stringArray[i2].indexOf(key.toUpperCase()) + key.length(), stringArray[i2].length());
        }
        return "";
    }

    public class CertDistinguished {
        private String cn;
        private String email;
        private String givenName;
        private String ou;
        private String c;
        private String l;
        private String st;
        private String phone;

        public CertDistinguished(Principal prin) {
            String string = prin.toString();
            this.cn = CertInfo.this.getInfoFromDn(string, "CN=");
            this.ou = CertInfo.this.getInfoFromDn(string, "OU=");
            this.c = CertInfo.this.getInfoFromDn(string, "C=");
            this.l = CertInfo.this.getInfoFromDn(string, "L=");
            this.st = CertInfo.this.getInfoFromDn(string, "ST=");
            this.phone = CertInfo.this.getInfoFromDn(string, "TelephoneNumber=");
            this.email = CertInfo.this.getInfoFromDn(string, "EMAIL=");
            this.givenName = CertInfo.this.getInfoFromDn(string, "GIVENNAME=");
        }

        public String getCn() {
            return this.cn;
        }

        public String getEmail() {
            return this.email;
        }

        public String getGivenName() {
            return this.givenName;
        }

        public String getOu() {
            return this.ou;
        }

        public String getC() {
            return this.c;
        }

        public String getL() {
            return this.l;
        }

        public String getSt() {
            return this.st;
        }

        public String getPhone() {
            return this.phone;
        }
    }
}

