package cn.tsign.hz.run;

import cn.tsign.hz.constant.ConfigConstant;
import cn.tsign.hz.core.AuthHelper;
import cn.tsign.hz.core.ClientHelper;
import cn.tsign.hz.exception.DefineException;
import com.timevale.esign.paas.tech.bean.request.OnlineCreateAuthParam;
import com.timevale.esign.paas.tech.client.ServiceClient;
import com.timevale.esign.paas.tech.bean.request.AuthFlowSignUrlParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/***
 * description: 企业签署授权服务
 */


public class TestAuth {

    private static final Logger LOGGER = LoggerFactory.getLogger(TestAuth.class);
    private static AuthHelper authHelper;

    static {
        try {
            if (true) {
                //1、注册客户端，全局使用，只需注册一次
                ClientHelper.registClient();
            }

            //2、获取已初始化的客户端，以便后续正常调用SDK提供的各种服务，全局使用，只需获取一次
            ServiceClient serviceClient = ClientHelper.getServiceClient(ConfigConstant.PROJECT_ID);

            //3、实例化辅助类
            authHelper = new AuthHelper(serviceClient);
        } catch (DefineException e) {
            e.getE().printStackTrace();
        }
    }

    public static void main(String[] args) throws DefineException {


        switch (0) {
            case 0:
                LOGGER.info("====>场景演示：发起企业授权书签署任务<=====");
                createAuth();
                break;
            case 1:
                LOGGER.info("====>场景演示：获取授权签署任务链接<=====");
                getAuthFlowUrl();
                break;
            case 2:
                LOGGER.info("====>场景演示：查询授权结果<=====");
                queryAuth();
                break;
            case 3:
                LOGGER.info("====>场景演示：取消授权<=====");
                cancelAuth();
                break;
            default:
                LOGGER.info("====>请选择应用场景<=====");
                break;

        }
    }

    /**
     * 发起企业授权书签署任务
     */
    private static String createAuth() throws DefineException {
        OnlineCreateAuthParam onlineCreateAuthParam = new OnlineCreateAuthParam();//创建授权参数
        onlineCreateAuthParam.setOrganizeId("1EEFF9E1*******AFC0D45D1F");//授权方企业账号ID
        onlineCreateAuthParam.setPersonId("11DAE******F7069B");//授权方经办人个人账号ID
        onlineCreateAuthParam.setAuthType(1);//授权模式，默认为 1（授权至平台）：1 - 授权至平台，personId无需传递；2 - 授权至经办人，personId必传
        onlineCreateAuthParam.setContact("153*****50");//手机号或者邮箱
        onlineCreateAuthParam.setSendNotice(true);//是否发送通知
        onlineCreateAuthParam.setSealScope("合同专用章");//自定义授权印章范围
        onlineCreateAuthParam.setFileType("物流条款");//自定义签署文件类型
        onlineCreateAuthParam.setNotifyUrl("http://XXXX/asyn/notify");//回调通知地址
        onlineCreateAuthParam.setRedirectUrl("https://open.esign.cn");//重定向跳转地址
        onlineCreateAuthParam.setValidDate(17085374740000L);//授权有效期截止时间（截止到当日0点）
        return authHelper.createAuth(onlineCreateAuthParam);

    }

    /**
     * 获取授权签署任务链接
     */
    private static String getAuthFlowUrl() throws DefineException {
        AuthFlowSignUrlParam authFlowSignUrlParam = new AuthFlowSignUrlParam();
        authFlowSignUrlParam.setAuthId("175*******3383");//授权流程ID
        authFlowSignUrlParam.setNeedLogin(false);//是否需要登录打开链接:true - 需登录打开链接，false - 免登录
        authFlowSignUrlParam.setRedirectUrl("https://open.esign.cn");//重定向跳转地址
        authFlowSignUrlParam.setClientType("ALL");//指定客户端类型，默认值 ：ALL ; H5 - 移动端适配 , PC - PC端适配 , ALL - 自动适配移动端或PC端
        return authHelper.getAuthFlowUrl(authFlowSignUrlParam);
    }


    /**
     * 查询授权结果
     */
    private static int queryAuth() throws DefineException {
        String authId = "175*******9875";
        return authHelper.queryAuth(authId);//授权状态，1-进行中 2-授权成功 3-授权失败 4-取消授权
    }

    /**
     * 取消授权
     */
    private static void cancelAuth() throws DefineException {
        String authId = "17********050";
        authHelper.cancelAuth(authId);
    }
}

