/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.enums;

import com.timevale.guava.common.collect.Maps;
import java.util.Map;

public enum LegalAreaEnum {
    MAINLAND(0),
    HONGKONG(1),
    MACAO(2),
    TAIWAN(3),
    PASSPORT(4),
    OTHER(5);

    private Integer area;
    static Map<Integer, LegalAreaEnum> items;

    private LegalAreaEnum(Integer area) {
        this.area = area;
    }

    public Integer type() {
        return this.area;
    }

    public static LegalAreaEnum of(Integer type) {
        for (LegalAreaEnum legalAreaEnum : LegalAreaEnum.values()) {
            if (!legalAreaEnum.area.equals(type)) continue;
            return legalAreaEnum;
        }
        return null;
    }

    public static boolean valid(Integer type) {
        if (type == null) {
            return true;
        }
        return items.containsKey(type);
    }

    public static LegalAreaEnum getByName(Integer type) {
        return items.get(type);
    }

    static {
        items = Maps.newHashMap();
        for (LegalAreaEnum legalAreaEnum : LegalAreaEnum.values()) {
            items.put(legalAreaEnum.type(), legalAreaEnum);
        }
    }
}

