/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.collect;

import com.timevale.guava.common.annotations.GwtCompatible;
import com.timevale.guava.common.base.Preconditions;
import com.timevale.guava.common.collect.ImmutableSet;
import com.timevale.guava.common.collect.Iterators;
import com.timevale.guava.common.collect.ObjectArrays;
import com.timevale.guava.common.collect.UnmodifiableIterator;
import java.util.Set;
import javax.annotation.Nullable;

@GwtCompatible(serializable=true, emulated=true)
final class SingletonImmutableSet<E>
extends ImmutableSet<E> {
    final transient E element;
    private transient Integer cachedHashCode;

    SingletonImmutableSet(E element) {
        this.element = Preconditions.checkNotNull(element);
    }

    SingletonImmutableSet(E element, int hashCode) {
        this.element = element;
        this.cachedHashCode = hashCode;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(Object target) {
        return this.element.equals(target);
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return Iterators.singletonIterator(this.element);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.element};
    }

    @Override
    public <T> T[] toArray(T[] array) {
        if (array.length == 0) {
            array = ObjectArrays.newArray(array, 1);
        } else if (array.length > 1) {
            array[1] = null;
        }
        T[] TArray = array;
        TArray[0] = this.element;
        return array;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Set) {
            Set set = (Set)object;
            return set.size() == 1 && this.element.equals(set.iterator().next());
        }
        return false;
    }

    @Override
    public final int hashCode() {
        Integer n2 = this.cachedHashCode;
        if (n2 == null) {
            this.cachedHashCode = this.element.hashCode();
            return this.cachedHashCode;
        }
        return n2;
    }

    @Override
    boolean isHashCodeFast() {
        return false;
    }

    @Override
    public String toString() {
        String string = this.element.toString();
        return new StringBuilder(string.length() + 2).append('[').append(string).append(']').toString();
    }
}

