/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.seal.sdk.util;

import com.timevale.seal.sdk.enums.DrawRuleTypeEnum;
import com.timevale.seal.sdk.factory.DrawerFactory;
import com.timevale.seal.sdk.request.DoubleEllipseSealRequest;
import com.timevale.seal.sdk.request.EllipseSealRequest;
import com.timevale.seal.sdk.request.HkSealRequest;
import com.timevale.seal.sdk.request.RectSealRequest;
import com.timevale.seal.sdk.request.SealBaseRequest;
import com.timevale.seal.sdk.request.generator.RequestGenerator;
import com.timevale.seal.sdk.response.SealImageResponse;

public class SealDrawUtil {
    private SealDrawUtil() {
    }

    public static SealImageResponse draw(EllipseSealRequest request) {
        return SealDrawUtil.doDraw(request, request.getDrawRuleTypeEnum());
    }

    public static SealImageResponse draw(DoubleEllipseSealRequest request) {
        return SealDrawUtil.doDraw(request, request.getDrawRuleTypeEnum());
    }

    public static SealImageResponse draw(RectSealRequest request) {
        return SealDrawUtil.doDraw(request, null);
    }

    public static SealImageResponse draw(HkSealRequest request) {
        return SealDrawUtil.doDraw(request, DrawRuleTypeEnum.HONG_KONG);
    }

    private static <T extends SealBaseRequest> SealImageResponse doDraw(T t2, DrawRuleTypeEnum drawRuleTypeEnum) {
        RequestGenerator requestGenerator = DrawerFactory.getGenerator(t2.getSealTypeEnum(), drawRuleTypeEnum);
        return requestGenerator.generate(t2, drawRuleTypeEnum);
    }
}

