/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.text;

import com.timevale.tgtext.text.pdf.draw.DrawInterface;

public class TabStop {
    protected float abt;
    protected Alignment abu = Alignment.LEFT;
    protected DrawInterface abv;
    protected char abw = (char)46;

    public static TabStop l(float f2, float f3) {
        f2 = (float)Math.round(f2 * 1000.0f) / 1000.0f;
        f3 = (float)Math.round(f3 * 1000.0f) / 1000.0f;
        TabStop tabStop = new TabStop(f2 + f3 - f2 % f3);
        return tabStop;
    }

    public TabStop(float position) {
        this(position, Alignment.LEFT);
    }

    public TabStop(float position, DrawInterface leader) {
        this(position, leader, Alignment.LEFT);
    }

    public TabStop(float position, Alignment alignment) {
        this(position, null, alignment);
    }

    public TabStop(float position, Alignment alignment, char anchorChar) {
        this(position, null, alignment, anchorChar);
    }

    public TabStop(float position, DrawInterface leader, Alignment alignment) {
        this(position, leader, alignment, '.');
    }

    public TabStop(float position, DrawInterface leader, Alignment alignment, char anchorChar) {
        this.abt = position;
        this.abv = leader;
        this.abu = alignment;
        this.abw = anchorChar;
    }

    public TabStop(TabStop tabStop) {
        this(tabStop.DT(), tabStop.DV(), tabStop.DU(), tabStop.DW());
    }

    public float DT() {
        return this.abt;
    }

    public void an(float f2) {
        this.abt = f2;
    }

    public Alignment DU() {
        return this.abu;
    }

    public void a(Alignment alignment) {
        this.abu = alignment;
    }

    public DrawInterface DV() {
        return this.abv;
    }

    public void a(DrawInterface drawInterface) {
        this.abv = drawInterface;
    }

    public char DW() {
        return this.abw;
    }

    public void k(char c2) {
        this.abw = c2;
    }

    public float a(float f2, float f3, float f4) {
        float f5 = this.abt;
        float f6 = f3 - f2;
        switch (this.abu) {
            case RIGHT: {
                if (f2 + f6 < this.abt) {
                    f5 = this.abt - f6;
                    break;
                }
                f5 = f2;
                break;
            }
            case CENTER: {
                if (f2 + f6 / 2.0f < this.abt) {
                    f5 = this.abt - f6 / 2.0f;
                    break;
                }
                f5 = f2;
                break;
            }
            case ANCHOR: {
                if (!Float.isNaN(f4)) {
                    if (f4 < this.abt) {
                        f5 = this.abt - (f4 - f2);
                        break;
                    }
                    f5 = f2;
                    break;
                }
                f5 = f2 + f6 < this.abt ? this.abt - f6 : f2;
            }
        }
        return f5;
    }

    public static enum Alignment {
        LEFT,
        RIGHT,
        CENTER,
        ANCHOR;

    }
}

