/*
 * Decompiled with CFR 0.152.
 */
package esign.utils.httpclient;

import esign.utils.StringUtil;
import esign.utils.httpclient.HttpDeleteBody;
import esign.utils.httpclient.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpMessage;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHeaderMgmt {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpHeaderMgmt.class);
    private Map<String, String> headers = new HashMap<String, String>();

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public HttpMessage installHeaders(HttpMessage method) {
        for (String string : this.headers.keySet()) {
            if (StringUtil.isNull(string) || StringUtil.isNull(this.headers.get(string))) continue;
            method.addHeader(string, this.headers.get(string));
        }
        return method;
    }

    public HttpMessage getMethod(Method method, String url) {
        switch (method) {
            case Get: {
                return this.installHeaders((HttpMessage)new HttpGet(url));
            }
            case Post: {
                return this.installHeaders((HttpMessage)new HttpPost(url));
            }
            case Put: {
                return this.installHeaders((HttpMessage)new HttpPut(url));
            }
            case Delete: {
                return this.installHeaders((HttpMessage)new HttpDeleteBody(url));
            }
        }
        LOGGER.warn("invalid method. type:{}", (Object)method);
        return this.installHeaders((HttpMessage)new HttpPost());
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }
}

