/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.common;

import com.google.gson.JsonObject;
import com.timevale.esign.paas.tech.bean.httpvo.FileUploadUrlResult;
import com.timevale.esign.paas.tech.bean.model.GetFileSystemUrlModel;
import com.timevale.esign.paas.tech.client.AbstractServiceClient;
import com.timevale.esign.paas.tech.client.HiddenOperationDelegator;
import com.timevale.esign.paas.tech.client.context.InterfaceKey;
import com.timevale.esign.paas.tech.constant.ErrorException;
import esign.utils.JsonHelper;
import esign.utils.asserts.AssertSupport;
import esign.utils.exception.ErrorsDiscriptor;
import esign.utils.exception.SuperException;
import esign.utils.httpclient.HttpConfigT;
import esign.utils.httpclient.HttpHeaderMgmt;
import esign.utils.httpclient.HttpUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemHelper {
    private static final Logger logger = LoggerFactory.getLogger(FileSystemHelper.class);

    public static FileUploadUrlResult getUploadUrl(AbstractServiceClient client, String md5, String fileName) throws SuperException {
        GetFileSystemUrlModel getFileSystemUrlModel = (GetFileSystemUrlModel)client.getContext().a(InterfaceKey.GET_FILE_SYSTEM_URL);
        AssertSupport.assertNotnull(md5, ErrorsDiscriptor.FileMD5DigestFailed.e());
        getFileSystemUrlModel.setMd5(md5);
        getFileSystemUrlModel.setFileName(fileName);
        JsonObject jsonObject = HiddenOperationDelegator.request(client, getFileSystemUrlModel);
        FileUploadUrlResult fileUploadUrlResult = JsonHelper.fromJson(jsonObject, FileUploadUrlResult.class);
        if (0 != fileUploadUrlResult.getErrCode()) {
            logger.error("get upload url failed message: {}", (Object)fileUploadUrlResult.getMsg());
            throw ErrorsDiscriptor.direct(fileUploadUrlResult.getErrCode(), fileUploadUrlResult.getMsg());
        }
        return fileUploadUrlResult;
    }

    public static void upload(String url, byte[] file, Map<String, String> headers) throws SuperException {
        try {
            HttpHeaderMgmt httpHeaderMgmt = new HttpHeaderMgmt();
            httpHeaderMgmt.setHeaders(headers);
            HttpConfigT<String> httpConfigT = new HttpConfigT<String>(String.class);
            httpConfigT.setHeaderMgmt(httpHeaderMgmt);
            HttpUtil.upload(url, file, httpConfigT);
        }
        catch (SuperException superException) {
            logger.info("upload fail {}", (Object)superException.getMessage());
            throw ErrorException.FILE_UPLOAD_ERROR.e();
        }
    }
}

