/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.service.a;

import com.google.gson.JsonObject;
import com.timevale.esign.paas.tech.bean.bean.AccountInfoBean;
import com.timevale.esign.paas.tech.bean.bean.CertInfo;
import com.timevale.esign.paas.tech.bean.httpvo.GetAccountInfoResult;
import com.timevale.esign.paas.tech.bean.model.AccountQueryModel;
import com.timevale.esign.paas.tech.bean.model.CreateOfficialSealMode;
import com.timevale.esign.paas.tech.bean.model.CreatePersonSealModel;
import com.timevale.esign.paas.tech.bean.model.EsignPlatformGBHashSignModel;
import com.timevale.esign.paas.tech.bean.model.GetGBConfigInfoModel;
import com.timevale.esign.paas.tech.bean.request.GbOfficialSealParam;
import com.timevale.esign.paas.tech.bean.request.GbPersonalSealParam;
import com.timevale.esign.paas.tech.bean.result.AccountInfoAndCertResult;
import com.timevale.esign.paas.tech.bean.result.AccountInfoResult;
import com.timevale.esign.paas.tech.bean.result.AddGbSealResult;
import com.timevale.esign.paas.tech.bean.result.AddSealResult;
import com.timevale.esign.paas.tech.bean.result.EsignPlatformGBHashSignResult;
import com.timevale.esign.paas.tech.bean.result.GetGbConfigInfoResult;
import com.timevale.esign.paas.tech.bean.result.ParseSealResult;
import com.timevale.esign.paas.tech.bean.result.Result;
import com.timevale.esign.paas.tech.client.AbstractServiceClient;
import com.timevale.esign.paas.tech.client.HiddenOperationDelegator;
import com.timevale.esign.paas.tech.client.context.InterfaceKey;
import com.timevale.esign.paas.tech.constant.ErrorException;
import com.timevale.esign.paas.tech.enums.AccountTypeEnum;
import com.timevale.esign.paas.tech.enums.AllIdNoTypeEnum;
import com.timevale.esign.paas.tech.enums.OrganizeTemplateType;
import com.timevale.esign.paas.tech.enums.PersonTemplateType;
import com.timevale.esign.paas.tech.enums.SealColor;
import com.timevale.esign.paas.tech.enums.StampRuleEnum;
import com.timevale.esign.paas.tech.service.AccountService;
import com.timevale.esign.paas.tech.service.TemplateSealService;
import com.timevale.esign.paas.tech.service.a.a;
import com.timevale.esign.paas.tech.util.CollectionUtil;
import com.timevale.esign.paas.tech.util.CommonCertUtil;
import com.timevale.esign.paas.tech.util.ValidationUtil;
import com.timevale.gm.a.c;
import com.timevale.gm.d.b;
import com.timevale.gm.d.d;
import com.timevale.gm.d.e;
import com.timevale.gm.d.f;
import com.timevale.i;
import com.timevale.seal.sdk.enums.CenterTypeEnum;
import com.timevale.seal.sdk.enums.FontEnum;
import com.timevale.seal.sdk.enums.FontLayoutTypeEnum;
import com.timevale.seal.sdk.enums.FontPullTypeEnum;
import com.timevale.seal.sdk.enums.SealTypeEnum;
import com.timevale.seal.sdk.enums.UnitEnum;
import com.timevale.seal.sdk.request.EllipseSealRequest;
import com.timevale.seal.sdk.request.LineWrapSealRequest;
import com.timevale.seal.sdk.request.RectSealRequest;
import com.timevale.seal.sdk.response.SealImageResponse;
import com.timevale.seal.sdk.util.FontUtil;
import com.timevale.seal.sdk.util.LineWrapSealUtil;
import com.timevale.seal.sdk.util.PixelUtil;
import com.timevale.seal.sdk.util.SealDrawUtil;
import com.timevale.seal.sdk.util.StringUtils;
import com.timevale.tech.sdk.utils.ImageUtil;
import com.timevale.tgtext.bouncycastle.asn1.DEROctetString;
import esign.utils.Base64;
import esign.utils.JsonHelper;
import esign.utils.StringUtil;
import esign.utils.bean.IResult;
import esign.utils.bean.ResultUtil;
import esign.utils.exception.ErrorsDiscriptor;
import esign.utils.exception.SuperException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class k
extends a
implements TemplateSealService {
    private static final Logger log = LoggerFactory.getLogger(k.class);

    public k() {
    }

    public k(AbstractServiceClient abstractServiceClient) {
        super(abstractServiceClient);
    }

    @Override
    public AddSealResult createPersonalSeal(String name, PersonTemplateType type, SealColor color, StampRuleEnum stampRule) {
        try {
            this.cR(name);
        }
        catch (SuperException superException) {
            return ResultUtil.failed(superException, AddSealResult.class);
        }
        return this.createPsnSeal(null, name, type, color, stampRule);
    }

    @Override
    public AddSealResult createPsnSeal(String accountId, String name, PersonTemplateType type, SealColor color, StampRuleEnum stampRule) {
        try {
            this.a(accountId, name, type);
            name = this.a(accountId, name, stampRule);
            if (null == color) {
                color = SealColor.RED;
            }
            RectSealRequest rectSealRequest = new RectSealRequest();
            rectSealRequest.setText(name);
            rectSealRequest.setSealTypeEnum(SealTypeEnum.RECT_SEAL);
            if ("square".equalsIgnoreCase(type.templateType().disc())) {
                rectSealRequest.setWidth(18);
                rectSealRequest.setHeight(18);
            } else {
                rectSealRequest.setWidth(20);
                rectSealRequest.setHeight(10);
            }
            rectSealRequest.setFont(FontUtil.loadFontByRelativePath(FontEnum.F_SONG.getCode(), "fonts"));
            rectSealRequest.setSealColor(com.timevale.seal.sdk.enums.SealColor.getByCode(color.name()));
            rectSealRequest.setDpi(96);
            if (!"borderless".equalsIgnoreCase(type.templateType().disc())) {
                rectSealRequest.setBorderWidth(Float.valueOf(1.0f));
                rectSealRequest.setFont(FontUtil.loadFontByRelativePath(FontEnum.SONG.getCode(), "fonts"));
            }
            rectSealRequest.setUnit(UnitEnum.MM);
            rectSealRequest.setFontLayoutType(FontLayoutTypeEnum.LEFT_RIGHT_UP_DOWN);
            rectSealRequest.setFontPullType(FontPullTypeEnum.MOST_LEFT);
            SealImageResponse sealImageResponse = SealDrawUtil.draw(rectSealRequest);
            AddSealResult addSealResult = new AddSealResult();
            addSealResult.setSealData(Base64.encode(sealImageResponse.getBytes(), '\u0000'));
            return addSealResult;
        }
        catch (SuperException superException) {
            return ResultUtil.failed(superException, AddSealResult.class);
        }
        catch (Exception exception) {
            return ResultUtil.failed(ErrorException.CREATE_SEAL_PARAM_ERROR.e(exception.getMessage()), AddSealResult.class);
        }
    }

    @Override
    public AddSealResult createOfficialSeal(OrganizeTemplateType type, String roundText, List<String> hTexts, String qText, SealColor color) {
        try {
            this.cQ(roundText);
        }
        catch (SuperException superException) {
            return ResultUtil.failed(superException, AddSealResult.class);
        }
        return this.createOrgSeal(null, type, roundText, hTexts, qText, color);
    }

    @Override
    public AddSealResult createOrgSeal(String accountId, OrganizeTemplateType type, String roundText, List<String> hTexts, String qText, SealColor color) {
        try {
            this.a(accountId, roundText, hTexts, qText, type);
            roundText = this.i(accountId, roundText);
            if (null == color) {
                color = SealColor.RED;
            }
            EllipseSealRequest ellipseSealRequest = new EllipseSealRequest();
            ellipseSealRequest.setHorizontalTestList(hTexts);
            ellipseSealRequest.setSealColor(com.timevale.seal.sdk.enums.SealColor.getByCode(color.name()));
            ellipseSealRequest.setDpi(96);
            ellipseSealRequest.setSealTypeEnum(SealTypeEnum.ELLIPSE_SEAL);
            ellipseSealRequest.setTopSurroundText(roundText);
            ellipseSealRequest.setTopSurroundTextFont(FontUtil.loadFontByRelativePath(type.getFontName(), "fonts"));
            ellipseSealRequest.setHorizontalTestList(hTexts);
            ellipseSealRequest.setHorizontalTextFont(FontUtil.loadFontByRelativePath(type.getFontName(), "fonts"));
            ellipseSealRequest.setBottomSurroundText(qText);
            ellipseSealRequest.setBottomSurroundTextFont(FontUtil.loadFontByRelativePath(type.getFontName(), "fonts"));
            ellipseSealRequest.setUnit(UnitEnum.MM);
            ellipseSealRequest.setWidth(42);
            ellipseSealRequest.setHeight(42);
            ellipseSealRequest.setBorderWidth(Float.valueOf(1.2f));
            if (OrganizeTemplateType.OVAL.equals(type)) {
                ellipseSealRequest.setWidth(45);
                ellipseSealRequest.setHeight(30);
                ellipseSealRequest.setBorderWidth(Float.valueOf(1.0f));
            }
            if (OrganizeTemplateType.STAR.equals(type)) {
                ellipseSealRequest.setCenterTypeEnum(CenterTypeEnum.STAR);
            }
            SealImageResponse sealImageResponse = SealDrawUtil.draw(ellipseSealRequest);
            AddSealResult addSealResult = new AddSealResult();
            addSealResult.setSealData(Base64.encode(sealImageResponse.getBytes(), '\u0000'));
            return addSealResult;
        }
        catch (SuperException superException) {
            return ResultUtil.failed(superException, AddSealResult.class);
        }
    }

    @Override
    public AddSealResult createLongBreakPersonalSeal(String name, int fontSize, SealColor color) {
        String string = name.trim();
        if (StringUtil.isNull(string) || string.length() > 40) {
            log.warn("Person description text length is illegal. name:{} ", (Object)name);
            return ResultUtil.failed(ErrorsDiscriptor.NOT_SUPPORTED_TEXT_LENGTH, AddSealResult.class);
        }
        if (fontSize <= 10) {
            return ResultUtil.failed(ErrorsDiscriptor.NOT_SUPPORTED_FONT_SIZE, AddSealResult.class);
        }
        LineWrapSealRequest lineWrapSealRequest = new LineWrapSealRequest();
        lineWrapSealRequest.setText(name);
        lineWrapSealRequest.setFontSize(fontSize);
        lineWrapSealRequest.setSealColor(null == color ? com.timevale.seal.sdk.enums.SealColor.RED : com.timevale.seal.sdk.enums.SealColor.getByCode(color.name()));
        try {
            SealImageResponse sealImageResponse = LineWrapSealUtil.createLineWrapSeal(lineWrapSealRequest);
            AddSealResult addSealResult = new AddSealResult();
            addSealResult.setSealData(Base64.encode(sealImageResponse.getBytes(), '\u0000'));
            return addSealResult;
        }
        catch (Exception exception) {
            log.warn("createLongBreakPersonalSeal fail ", (Throwable)exception);
            return ResultUtil.failed(ErrorException.CREATE_SEAL_PARAM_ERROR.e(exception.getMessage()), AddSealResult.class);
        }
    }

    @Override
    public AddGbSealResult createGbPersonalSeal(GbPersonalSealParam param) {
        try {
            Object object;
            AccountInfoAndCertResult accountInfoAndCertResult = this.cM(param.getAccountId());
            if (!accountInfoAndCertResult.success()) {
                return ResultUtil.failed(ErrorException.CREATE_SEAL_PARAM_ERROR.e(accountInfoAndCertResult.getMsg()), AddGbSealResult.class);
            }
            if (AccountTypeEnum.PERSON != accountInfoAndCertResult.getAccountType()) {
                return ResultUtil.failed(ErrorException.PARAM_ERROR.e("\u672a\u4f20\u5165accountId\u6216\u672a\u627e\u5230accountId\u5bf9\u5e94\u7528\u6237\uff0c\u65e0\u6cd5\u521b\u5efa\u5370\u7ae0"), AddGbSealResult.class);
            }
            if (StringUtils.isBlank(param.getSealImage())) {
                object = this.createPersonalSeal(accountInfoAndCertResult.getName(), param.getType(), param.getColor(), param.getStampRule());
                if (((Result)object).getErrCode() != 0) {
                    log.warn("createGbPersonalSealImage fail");
                    return ResultUtil.failed((IResult)object, AddGbSealResult.class);
                }
                param.setSealImage(((AddSealResult)object).getSealData());
            }
            if (StringUtils.isBlank(accountInfoAndCertResult.getCert())) {
                return ResultUtil.failed(ErrorException.PARSE_EVI_ERROR.e("\u8be5\u4e2a\u4eba\u8d26\u53f7\u6682\u65e0\u8bc1\u4e66\uff0c\u65e0\u6cd5\u521b\u5efa\u56fd\u6807\u5370\u7ae0\uff0c\u8bf7\u5148\u5b8c\u6210\u6838\u8eab\u8ba4\u8bc1"), AddGbSealResult.class);
            }
            object = CommonCertUtil.getCertInfo(Base64.decode(accountInfoAndCertResult.getCert()));
            if (object == null) {
                log.warn("\u89e3\u6790\u7b7e\u7ae0\u8005\u8bc1\u4e66\u4fe1\u606f\u5931\u8d25");
                return ResultUtil.failed(ErrorException.PARSE_EVI_ERROR.e("\u89e3\u6790\u7b7e\u7ae0\u8005\u8bc1\u4e66\u4fe1\u606f\u5931\u8d25"), AddGbSealResult.class);
            }
            GetGbConfigInfoResult getGbConfigInfoResult = this.uB();
            if (getGbConfigInfoResult.getErrCode() != 0) {
                return ResultUtil.failed(getGbConfigInfoResult, AddGbSealResult.class);
            }
            e e2 = this.a(getGbConfigInfoResult, param.getSealImage(), accountInfoAndCertResult, (CertInfo)object, 1, 95);
            String string = i.d(e2.toASN1Primitive().getEncoded(), Base64.decode(getGbConfigInfoResult.getCert()));
            EsignPlatformGBHashSignResult esignPlatformGBHashSignResult = this.cN(string);
            if (esignPlatformGBHashSignResult.getErrCode() != 0) {
                return ResultUtil.failed(esignPlatformGBHashSignResult, AddGbSealResult.class);
            }
            byte[] byArray = Base64.decode(getGbConfigInfoResult.getCert());
            f f2 = new f(e2, byArray, esignPlatformGBHashSignResult.getSignResult());
            return new AddGbSealResult(Base64.encode(f2.toASN1Primitive().getEncoded()).replaceAll("[\r\t\n]", ""), param.getSealImage(), getGbConfigInfoResult.getNowTime(), ((CertInfo)object).getEndTime().getTime());
        }
        catch (Throwable throwable) {
            log.warn("createGbPersonalSeal fail ", throwable);
            return ResultUtil.failed(ErrorException.CREATE_SEAL_PARAM_ERROR.e(throwable.getMessage()), AddGbSealResult.class);
        }
    }

    private AccountInfoAndCertResult cM(String string) {
        try {
            AccountQueryModel accountQueryModel = (AccountQueryModel)this.uy().getContext().a(InterfaceKey.QUERY_ACCOUNT);
            accountQueryModel.setAccountUid(string);
            accountQueryModel.setWithCert(true);
            accountQueryModel.setAlgorithm("SM2");
            JsonObject jsonObject = HiddenOperationDelegator.request(this.uy(), accountQueryModel);
            GetAccountInfoResult getAccountInfoResult = JsonHelper.fromJson(jsonObject, GetAccountInfoResult.class);
            if (0 != getAccountInfoResult.getErrCode()) {
                log.error("getAccountInfoAndCert failed.errCode:{},errMsg:{}", (Object)getAccountInfoResult.getErrCode(), (Object)getAccountInfoResult.getMsg());
                return ResultUtil.failed(getAccountInfoResult, AccountInfoAndCertResult.class);
            }
            return this.a(getAccountInfoResult);
        }
        catch (Exception exception) {
            log.error("getAccountInfoAndCert failed.", (Throwable)exception);
            return ResultUtil.failed(exception, AccountInfoAndCertResult.class);
        }
    }

    private AccountInfoAndCertResult a(GetAccountInfoResult getAccountInfoResult) {
        AccountInfoAndCertResult accountInfoAndCertResult = new AccountInfoAndCertResult();
        AccountInfoBean accountInfoBean = getAccountInfoResult.getAccountInfo();
        accountInfoAndCertResult.setAccountId(accountInfoBean.getAccountUid());
        accountInfoAndCertResult.setName(accountInfoBean.getName());
        accountInfoAndCertResult.setIdNo(accountInfoBean.getIdNo());
        accountInfoAndCertResult.setIdNoType(AllIdNoTypeEnum.getByVal(accountInfoBean.getIdNoType()));
        accountInfoAndCertResult.setAccountType(AccountTypeEnum.getByType(accountInfoBean.getAccountType()));
        accountInfoAndCertResult.setCert(accountInfoBean.getCert());
        return accountInfoAndCertResult;
    }

    private EsignPlatformGBHashSignResult cN(String string) {
        try {
            EsignPlatformGBHashSignModel esignPlatformGBHashSignModel = (EsignPlatformGBHashSignModel)this.uy().getContext().a(InterfaceKey.ESIGN_PLATFORM_GB_HASH_SIGN);
            esignPlatformGBHashSignModel.setHash(string);
            JsonObject jsonObject = HiddenOperationDelegator.request(this.uy(), esignPlatformGBHashSignModel);
            return JsonHelper.fromJson(jsonObject, EsignPlatformGBHashSignResult.class);
        }
        catch (SuperException superException) {
            log.warn("getPlatformGBHashSignResult fail msg: {}", (Object)superException.getMessage());
            return ResultUtil.failed(superException, EsignPlatformGBHashSignResult.class);
        }
    }

    private GetGbConfigInfoResult uB() {
        try {
            GetGBConfigInfoModel getGBConfigInfoModel = (GetGBConfigInfoModel)this.uy().getContext().a(InterfaceKey.GET_GB_CONFIG_INFO);
            JsonObject jsonObject = HiddenOperationDelegator.request(this.uy(), getGBConfigInfoModel);
            return JsonHelper.fromJson(jsonObject, GetGbConfigInfoResult.class);
        }
        catch (SuperException superException) {
            log.warn("getGbConfigInfoResult fail msg: {}", (Object)superException.getMessage());
            return ResultUtil.failed(superException, GetGbConfigInfoResult.class);
        }
    }

    private e a(GetGbConfigInfoResult getGbConfigInfoResult, String string, AccountInfoAndCertResult accountInfoAndCertResult, CertInfo certInfo, int n2, Integer n3) {
        b b2 = new b(getGbConfigInfoResult.getSealHeaderId(), Integer.parseInt(getGbConfigInfoResult.getSealHeaderVersion()), getGbConfigInfoResult.getSealHeaderVid());
        d d2 = new d(n2, accountInfoAndCertResult.getName(), getGbConfigInfoResult.getPropertyCertListType(), this.cP(accountInfoAndCertResult.getCert()), new Date(getGbConfigInfoResult.getNowTime()), new Date(getGbConfigInfoResult.getNowTime()), certInfo.getEndTime());
        com.timevale.gm.d.c c2 = new com.timevale.gm.d.c(getGbConfigInfoResult.getPictureType(), Base64.decode(string), PixelUtil.transferPixelToMm(n3, 96), PixelUtil.transferPixelToMm(n3, 96));
        return new e(b2, this.cO(accountInfoAndCertResult.getAccountId()), d2, c2, null);
    }

    private String cO(String string) {
        return "es_" + string;
    }

    private c cP(String string) {
        byte[] byArray = Base64.decode(string);
        byte[][] byArrayArray = new byte[][]{byArray};
        return new c(byArrayArray, null, 1);
    }

    @Override
    public AddGbSealResult createGbOfficialSeal(GbOfficialSealParam param) {
        try {
            Object object;
            AccountInfoAndCertResult accountInfoAndCertResult = this.cM(param.getAccountId());
            if (!accountInfoAndCertResult.success()) {
                return ResultUtil.failed(ErrorException.CREATE_SEAL_PARAM_ERROR.e(accountInfoAndCertResult.getMsg()), AddGbSealResult.class);
            }
            if (AccountTypeEnum.ORGAN != accountInfoAndCertResult.getAccountType()) {
                return ResultUtil.failed(ErrorException.PARAM_ERROR.e("\u672a\u4f20\u5165accountId\u6216\u672a\u627e\u5230accountId\u5bf9\u5e94\u7528\u6237\uff0c\u65e0\u6cd5\u521b\u5efa\u5370\u7ae0"), AddGbSealResult.class);
            }
            if (StringUtils.isBlank(param.getSealImage())) {
                object = this.createOfficialSeal(param.getType(), accountInfoAndCertResult.getName(), param.gethTexts(), param.getqText(), param.getColor());
                if (((Result)object).getErrCode() != 0) {
                    log.warn("createGbOfficialSealImage fail");
                    return ResultUtil.failed((IResult)object, AddGbSealResult.class);
                }
                param.setSealImage(((AddSealResult)object).getSealData());
            }
            if (StringUtils.isBlank(accountInfoAndCertResult.getCert())) {
                return ResultUtil.failed(ErrorException.PARSE_EVI_ERROR.e("\u8be5\u4f01\u4e1a\u6682\u65e0\u8bc1\u4e66\uff0c\u65e0\u6cd5\u521b\u5efa\u56fd\u6807\u5370\u7ae0\uff0c\u8bf7\u5148\u5b8c\u6210\u4f01\u4e1a\u6388\u6743\u4e66\u7b7e\u7f72"), AddGbSealResult.class);
            }
            object = CommonCertUtil.getCertInfo(Base64.decode(accountInfoAndCertResult.getCert()));
            if (object == null) {
                log.warn("\u89e3\u6790\u7b7e\u7ae0\u8005\u8bc1\u4e66\u4fe1\u606f\u5931\u8d25");
                return ResultUtil.failed(ErrorException.PARSE_EVI_ERROR.e("\u89e3\u6790\u7b7e\u7ae0\u8005\u8bc1\u4e66\u4fe1\u606f\u5931\u8d25"), AddGbSealResult.class);
            }
            GetGbConfigInfoResult getGbConfigInfoResult = this.uB();
            if (getGbConfigInfoResult.getErrCode() != 0) {
                return ResultUtil.failed(getGbConfigInfoResult, AddGbSealResult.class);
            }
            e e2 = this.a(getGbConfigInfoResult, param.getSealImage(), accountInfoAndCertResult, (CertInfo)object, 5, 159);
            String string = i.d(e2.toASN1Primitive().getEncoded(), Base64.decode(getGbConfigInfoResult.getCert()));
            EsignPlatformGBHashSignResult esignPlatformGBHashSignResult = this.cN(string);
            if (esignPlatformGBHashSignResult.getErrCode() != 0) {
                return ResultUtil.failed(esignPlatformGBHashSignResult, AddGbSealResult.class);
            }
            byte[] byArray = Base64.decode(getGbConfigInfoResult.getCert());
            f f2 = new f(e2, byArray, esignPlatformGBHashSignResult.getSignResult());
            return new AddGbSealResult(Base64.encode(f2.toASN1Primitive().getEncoded()).replaceAll("[\r\t\n]", ""), param.getSealImage(), getGbConfigInfoResult.getNowTime(), ((CertInfo)object).getEndTime().getTime());
        }
        catch (Throwable throwable) {
            log.warn("createGbOfficialSeal fail ", throwable);
            return ResultUtil.failed(ErrorException.CREATE_SEAL_PARAM_ERROR.e(throwable.getMessage()), AddGbSealResult.class);
        }
    }

    @Override
    public ParseSealResult sealInfoParse(String sealData) {
        try {
            ValidationUtil.check(StringUtils.isBlank(sealData), ErrorException.PARAM_ERROR.e("\u5370\u7ae0\u7ed3\u6784\u4f53\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
            f f2 = f.bt(Base64.decode(sealData));
            ParseSealResult parseSealResult = new ParseSealResult();
            e e2 = f2.vv();
            parseSealResult.setSealName(e2.vs().vk().toString());
            parseSealResult.setSealImage(Base64.encode(e2.vt().vg().getOctets()));
            parseSealResult.setEffectiveTime(e2.vs().vo().getDate().getTime());
            parseSealResult.setExpireTime(e2.vs().vp().getDate().getTime());
            DEROctetString dEROctetString = e2.vs().vm().uS()[0];
            ParseSealResult.CertInfo certInfo = this.N(dEROctetString.getOctets());
            ParseSealResult.CertInfo certInfo2 = this.N(f2.vw().getOctets());
            parseSealResult.setSignerCert(certInfo);
            parseSealResult.setPlatformCert(certInfo2);
            return parseSealResult;
        }
        catch (Exception exception) {
            log.warn("sealInfoParse fail ", (Throwable)exception);
            return ResultUtil.failed(ErrorException.SEAL_INFO_PARSE_ERROR.e(exception.getMessage()), ParseSealResult.class);
        }
    }

    private ParseSealResult.CertInfo N(byte[] byArray) {
        CertInfo certInfo = CommonCertUtil.getCertInfo(byArray);
        if (certInfo == null) {
            log.warn("\u89e3\u6790\u5370\u7ae0\u5931\u8d25");
            return null;
        }
        ParseSealResult.CertInfo certInfo2 = new ParseSealResult.CertInfo();
        String string = certInfo.getSubject_cn();
        if (StringUtils.isNotBlank(string)) {
            String[] stringArray = string.split("@");
            if (stringArray.length == 1 || stringArray.length == 2) {
                string = stringArray[0];
            } else if (stringArray.length == 4) {
                string = stringArray[1];
            } else {
                log.warn("certName resolve error {}", (Object)string);
            }
        }
        certInfo2.setCn(string);
        certInfo2.setSn(certInfo.getSerialNumber());
        certInfo2.setStartDate(certInfo.getStartTime().getTime());
        certInfo2.setEndDate(certInfo.getEndTime().getTime());
        certInfo2.setIssuerCN(certInfo.getIssue_cn());
        return certInfo2;
    }

    private String transparentImage(String imageBase64) {
        try {
            BufferedImage bufferedImage = ImageUtil.base64ToBufferedImage(imageBase64);
            bufferedImage = ImageUtil.hyalinizeImage(bufferedImage, 0.8f);
            return ImageUtil.imageToBase64(bufferedImage, "png");
        }
        catch (IOException iOException) {
            log.error("io exception thrown at method transparentImage", (Throwable)iOException);
            iOException.printStackTrace();
            return null;
        }
    }

    public void a(String string, String string2, List<String> list, String string3, OrganizeTemplateType organizeTemplateType) throws SuperException {
        if (StringUtils.isBlank(string) && StringUtils.isBlank(string2)) {
            throw ErrorException.CREATE_SEAL_PARAM_ERROR.e("\u672a\u6307\u5b9a\u7528\u6237\u8d26\u53f7\u6216\u4f20\u5165\u5370\u7ae0\u4e0a\u5f26\u6587");
        }
        if (StringUtils.isNotBlank(string) && StringUtils.isNotBlank(string2)) {
            throw ErrorException.CREATE_SEAL_PARAM_ERROR.e("roundText\u548caccountId\u65e0\u6cd5\u540c\u65f6\u4f20\u5165");
        }
        if (StringUtils.isBlank(string)) {
            this.cQ(string2);
        }
        this.a(list, string3);
        if (organizeTemplateType == null) {
            throw ErrorException.CREATE_SEAL_PARAM_ERROR.e("type\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void a(List<String> list, String string) throws SuperException {
        if (CollectionUtil.isNotEmpty(list) && list.size() > 2) {
            throw ErrorException.CREATE_SEAL_PARAM_ERROR.e("\u4f01\u4e1a\u6a21\u677f\u5370\u7ae0\u53ea\u652f\u6301\u4e24\u6392\u6a2a\u5411\u6587");
        }
        if (CollectionUtil.isNotEmpty(list)) {
            for (String string2 : list) {
                if (string2.length() <= 20) continue;
                throw ErrorException.CREATE_SEAL_PARAM_ERROR.e("\u4f01\u4e1a\u6a21\u677f\u5370\u7ae0\u6a2a\u5411\u6587\u5b57\u6570\u4e0d\u80fd\u5927\u4e8e20\u4e2a\u5b57");
            }
        }
        if (!StringUtils.isBlank(string) && string.length() > 20) {
            log.error("qtext is out of length. qText:{} ", (Object)string);
            throw ErrorException.CREATE_SEAL_PARAM_ERROR.e("\u4f01\u4e1a\u6a21\u677f\u5370\u7ae0\u4e0d\u652f\u6301\u4e8c\u5341\u5b57\u4ee5\u4e0a\u7684\u4e0b\u5f26\u6587");
        }
    }

    public void cQ(String string) throws SuperException {
        if (StringUtils.isBlank(string) || string.length() <= 1) {
            log.error("the organize name is invalid.");
            throw ErrorsDiscriptor.Sdkseal_TextDecriptionLessThanTwoCharac.e();
        }
        if (string.length() > 50) {
            log.error("surroundText out of length:{}", (Object)string.length());
            throw ErrorException.CREATE_SEAL_PARAM_ERROR.e("\u4e0d\u652f\u6301\u4e94\u5341\u5b57\u4ee5\u4e0a\u7684\u4f01\u4e1a\u6a21\u677f\u5370\u7ae0");
        }
    }

    private void cR(String string) throws SuperException {
        if (StringUtils.isBlank(string) || string.length() < 1) {
            throw ErrorException.CREATE_SEAL_PARAM_ERROR.e("\u4e0d\u652f\u63011\u4e2a\u5b57\u7b26\u4ee5\u4e0b\u7684\u6a21\u677f\u5370\u7ae0");
        }
        if (string.length() > 18) {
            throw ErrorsDiscriptor.Sdkseal_TextDecriptionOutOfRange.e();
        }
    }

    private void a(String string, String string2, PersonTemplateType personTemplateType) throws SuperException {
        if (StringUtils.isBlank(string) && StringUtils.isBlank(string2)) {
            throw ErrorException.CREATE_SEAL_PARAM_ERROR.e("\u672a\u6307\u5b9a\u7528\u6237\u8d26\u53f7\u6216\u4f20\u5165\u7528\u6237\u59d3\u540d");
        }
        if (StringUtils.isNotBlank(string) && StringUtils.isNotBlank(string2)) {
            throw ErrorException.CREATE_SEAL_PARAM_ERROR.e("name\u548caccountId\u65e0\u6cd5\u540c\u65f6\u4f20\u5165");
        }
        if (StringUtils.isBlank(string)) {
            this.cR(string2);
        }
        if (personTemplateType == null) {
            throw ErrorException.CREATE_SEAL_PARAM_ERROR.e("type\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private String a(String string, String string2, StampRuleEnum stampRuleEnum) throws SuperException {
        if (StringUtils.isNotBlank(string2)) {
            return this.a(string2, stampRuleEnum);
        }
        AccountInfoResult accountInfoResult = this.cS(string);
        if (!AccountTypeEnum.PERSON.equals((Object)accountInfoResult.getAccountType())) {
            throw ErrorException.CREATE_SEAL_PARAM_ERROR.e("accountId\u975e\u4e2a\u4eba\u5e10\u53f7");
        }
        return this.a(accountInfoResult.getName(), stampRuleEnum);
    }

    private AccountInfoResult cS(String string) throws SuperException {
        AccountService accountService = this.uy().accountService();
        return accountService.getAccountInfoSuccessful(string, false);
    }

    private String a(String string, StampRuleEnum stampRuleEnum) {
        if (stampRuleEnum == null) {
            return string;
        }
        if (StampRuleEnum.SEAL_ONE.equals((Object)stampRuleEnum)) {
            return string + "\u5370";
        }
        if (StampRuleEnum.SEAL_TWO.equals((Object)stampRuleEnum)) {
            return string + "\u4e4b\u5370";
        }
        return string;
    }

    private String i(String string, String string2) throws SuperException {
        if (StringUtils.isNotBlank(string2)) {
            return string2;
        }
        AccountInfoResult accountInfoResult = this.cS(string);
        if (!AccountTypeEnum.ORGAN.equals((Object)accountInfoResult.getAccountType())) {
            throw ErrorException.CREATE_SEAL_PARAM_ERROR.e("accountId\u975e\u4f01\u4e1a\u5e10\u53f7");
        }
        return accountInfoResult.getName();
    }

    @Override
    public AddSealResult createPersonCloudSeal(String accountId, PersonTemplateType type, SealColor color, StampRuleEnum stampRuleEnum) {
        try {
            this.a(accountId, type);
            if (color == null) {
                color = SealColor.RED;
            }
            if (stampRuleEnum == null) {
                stampRuleEnum = StampRuleEnum.SEAL_NONE;
            }
            CreatePersonSealModel createPersonSealModel = (CreatePersonSealModel)this.uy().getContext().a(InterfaceKey.CREATE_PERSON_SEAL);
            createPersonSealModel.setAccountId(accountId);
            createPersonSealModel.setTemplateType(type.name());
            createPersonSealModel.setColor(color.name());
            createPersonSealModel.setStampRule(stampRuleEnum.name());
            JsonObject jsonObject = HiddenOperationDelegator.request(this.uy(), createPersonSealModel);
            AddSealResult addSealResult = JsonHelper.fromJson(jsonObject, AddSealResult.class);
            if (0 != addSealResult.getErrCode()) {
                log.info("create createPersonCloudSeal failed message : {}", (Object)addSealResult.getMsg());
                return ResultUtil.failed(addSealResult, AddSealResult.class);
            }
            return addSealResult;
        }
        catch (SuperException superException) {
            log.error("create createPersonCloudSeal error message : {}", (Object)superException.getMessage());
            return ResultUtil.failed(superException, AddSealResult.class);
        }
        catch (Exception exception) {
            log.error("create createPersonCloudSeal error message : {}", (Object)exception.getMessage());
            return ResultUtil.failed(exception, AddSealResult.class);
        }
    }

    @Override
    public AddSealResult createOfficialCloudSeal(String accountId, OrganizeTemplateType templateType, SealColor color, List<String> hTexts, String qText) {
        try {
            JsonObject jsonObject;
            AddSealResult addSealResult;
            this.a(accountId, templateType, hTexts, qText);
            if (null == color) {
                color = SealColor.RED;
            }
            CreateOfficialSealMode createOfficialSealMode = (CreateOfficialSealMode)this.uy().getContext().a(InterfaceKey.CREATE_OFFICIAL_SEAL);
            createOfficialSealMode.setAccountId(accountId);
            createOfficialSealMode.setColor(color.name());
            createOfficialSealMode.setTemplateType(templateType.name());
            createOfficialSealMode.setQText(qText);
            if (hTexts != null) {
                createOfficialSealMode.setHTexts(hTexts);
            }
            if (0 != (addSealResult = JsonHelper.fromJson(jsonObject = HiddenOperationDelegator.request(this.uy(), createOfficialSealMode), AddSealResult.class)).getErrCode()) {
                log.error("create seal failed message : {}", (Object)addSealResult.getMsg());
                return ResultUtil.failed(addSealResult, AddSealResult.class);
            }
            return addSealResult;
        }
        catch (SuperException superException) {
            log.error("create createOfficialCloudSeal error message : {}", (Object)superException.getMessage());
            return ResultUtil.failed(superException, AddSealResult.class);
        }
        catch (Exception exception) {
            log.error("create createOfficialCloudSeal error message : {}", (Object)exception.getMessage());
            return ResultUtil.failed(exception, AddSealResult.class);
        }
    }

    private void a(String string, OrganizeTemplateType organizeTemplateType, List<String> list, String string2) throws SuperException {
        if (StringUtils.isBlank(string)) {
            throw ErrorException.CREATE_SEAL_PARAM_ERROR.e("accountId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (organizeTemplateType == null) {
            throw ErrorException.CREATE_SEAL_PARAM_ERROR.e("templateType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.a(list, string2);
    }

    private void a(String string, PersonTemplateType personTemplateType) throws SuperException {
        if (StringUtils.isBlank(string)) {
            throw ErrorException.CREATE_SEAL_PARAM_ERROR.e("accountId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (personTemplateType == null) {
            throw ErrorException.CREATE_SEAL_PARAM_ERROR.e("type\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

