/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.util;

import com.timevale.tech.sdk.utils.Base64Util;
import com.timevale.tgtext.bouncycastle.jce.provider.BouncyCastleProvider;
import esign.utils.exception.ErrorsDiscriptor;
import esign.utils.exception.SuperException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigestUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DigestUtil.class);
    public static final String SHA_256 = "sha-256";
    public static final String SM3 = "SM3";

    public static String sha256Digest(byte[] bytes) throws SuperException {
        byte[] byArray = DigestUtil.digest(bytes, DigestUtil.getMessageDigest(SHA_256));
        return Base64Util.encode(byArray);
    }

    public static String sm3Digest(byte[] bytes) throws SuperException {
        byte[] byArray = DigestUtil.digest(bytes, DigestUtil.getMessageDigest(SM3));
        return Base64Util.encode(byArray);
    }

    public static MessageDigest getMessageDigest(String algorithm) throws SuperException {
        try {
            return MessageDigest.getInstance(algorithm, "BC");
        }
        catch (Exception exception) {
            LOGGER.error("get message digest failed.", (Throwable)exception);
            throw ErrorsDiscriptor.InternalService.e(exception);
        }
    }

    public static byte[] digest(byte[] bytes, MessageDigest md) {
        md.update(bytes);
        return md.digest();
    }

    public static byte[] digest(byte[] bytes, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
        messageDigest.update(bytes);
        return messageDigest.digest();
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }
}

