/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.bean.request;

import com.timevale.esign.paas.tech.bean.bean.PosBean;
import com.timevale.esign.paas.tech.bean.request.SignFilePdfParam;
import com.timevale.esign.paas.tech.constant.ErrorException;
import com.timevale.esign.paas.tech.enums.SealSpecEnum;
import com.timevale.esign.paas.tech.enums.SignType;
import com.timevale.esign.paas.tech.util.CollectionUtil;
import com.timevale.esign.paas.tech.util.ValidationUtil;
import com.timevale.seal.sdk.util.StringUtils;
import esign.utils.exception.SuperException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class BaseSignParam {
    private String accountId;
    private String willingnessId;
    private SignFilePdfParam fileBean;
    private String sealData;
    private SignType signType;
    private List<PosBean> posBeans;
    private SealSpecEnum sealSpec;

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getWillingnessId() {
        return this.willingnessId;
    }

    public void setWillingnessId(String willingnessId) {
        this.willingnessId = willingnessId;
    }

    public SignFilePdfParam getFileBean() {
        return this.fileBean;
    }

    public void setFileBean(SignFilePdfParam fileBean) {
        this.fileBean = fileBean;
    }

    public String getSealData() {
        return this.sealData;
    }

    public void setSealData(String sealData) {
        this.sealData = sealData;
    }

    public SignType getSignType() {
        return this.signType;
    }

    public void setSignType(SignType signType) {
        this.signType = signType;
    }

    public List<PosBean> getPosBeans() {
        return this.posBeans;
    }

    public void setPosBeans(List<PosBean> posBeans) {
        this.posBeans = posBeans;
    }

    public SealSpecEnum getSealSpec() {
        return this.sealSpec;
    }

    public void setSealSpec(SealSpecEnum sealSpec) {
        this.sealSpec = sealSpec;
    }

    public void check() throws SuperException {
        if (StringUtils.isBlank(this.accountId)) {
            throw ErrorException.ACCOUNT_ID_NULL_ERROR.e();
        }
        if (this.fileBean == null) {
            throw ErrorException.FILE_STREAM_ERROR.e();
        }
        this.fileBean.check();
        if (CollectionUtil.isEmpty(this.posBeans)) {
            throw ErrorException.POSBEANS_NULL_ERROR.e();
        }
        if (this.signType == null) {
            throw ErrorException.SIGN_TYPE_NULL_ERROR.e();
        }
        if (StringUtils.isBlank(this.sealData)) {
            throw ErrorException.SIGN_SEAL_NULL_ERROR.e();
        }
        Set set = this.posBeans.stream().map(PosBean::keywordSignTypeValidate).collect(Collectors.toSet());
        ValidationUtil.check(set.contains(Boolean.FALSE), ErrorException.KEYWORD_SIGN_TYPE_ERROR.e());
    }
}

