/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.base;

import com.timevale.guava.common.annotations.GwtCompatible;
import com.timevale.guava.common.base.Ascii;
import com.timevale.guava.common.base.CharMatcher;

@GwtCompatible
public enum CaseFormat {
    LOWER_HYPHEN(CharMatcher.is('-'), "-"),
    LOWER_UNDERSCORE(CharMatcher.is('_'), "_"),
    LOWER_CAMEL(CharMatcher.inRange('A', 'Z'), ""),
    UPPER_CAMEL(CharMatcher.inRange('A', 'Z'), ""),
    UPPER_UNDERSCORE(CharMatcher.is('_'), "_");

    private final CharMatcher wordBoundary;
    private final String wordSeparator;

    private CaseFormat(CharMatcher wordBoundary, String wordSeparator) {
        this.wordBoundary = wordBoundary;
        this.wordSeparator = wordSeparator;
    }

    public String to(CaseFormat format, String s2) {
        if (format == null) {
            throw new NullPointerException();
        }
        if (s2 == null) {
            throw new NullPointerException();
        }
        if (format == this) {
            return s2;
        }
        switch (this) {
            case LOWER_HYPHEN: {
                switch (format) {
                    case LOWER_UNDERSCORE: {
                        return s2.replace('-', '_');
                    }
                    case UPPER_UNDERSCORE: {
                        return Ascii.toUpperCase(s2.replace('-', '_'));
                    }
                }
                break;
            }
            case LOWER_UNDERSCORE: {
                switch (format) {
                    case LOWER_HYPHEN: {
                        return s2.replace('_', '-');
                    }
                    case UPPER_UNDERSCORE: {
                        return Ascii.toUpperCase(s2);
                    }
                }
                break;
            }
            case UPPER_UNDERSCORE: {
                switch (format) {
                    case LOWER_HYPHEN: {
                        return Ascii.toLowerCase(s2.replace('_', '-'));
                    }
                    case LOWER_UNDERSCORE: {
                        return Ascii.toLowerCase(s2);
                    }
                }
            }
        }
        StringBuilder stringBuilder = null;
        int n2 = 0;
        int n3 = -1;
        while (true) {
            ++n3;
            if ((n3 = this.wordBoundary.indexIn(s2, n3)) == -1) break;
            if (n2 == 0) {
                stringBuilder = new StringBuilder(s2.length() + 4 * this.wordSeparator.length());
                stringBuilder.append(format.normalizeFirstWord(s2.substring(n2, n3)));
            } else {
                stringBuilder.append(format.normalizeWord(s2.substring(n2, n3)));
            }
            stringBuilder.append(format.wordSeparator);
            n2 = n3 + this.wordSeparator.length();
        }
        if (n2 == 0) {
            return format.normalizeFirstWord(s2);
        }
        stringBuilder.append(format.normalizeWord(s2.substring(n2)));
        return stringBuilder.toString();
    }

    private String normalizeFirstWord(String word) {
        switch (this) {
            case LOWER_CAMEL: {
                return Ascii.toLowerCase(word);
            }
        }
        return this.normalizeWord(word);
    }

    private String normalizeWord(String word) {
        switch (this) {
            case LOWER_HYPHEN: {
                return Ascii.toLowerCase(word);
            }
            case LOWER_UNDERSCORE: {
                return Ascii.toLowerCase(word);
            }
            case LOWER_CAMEL: {
                return CaseFormat.firstCharOnlyToUpper(word);
            }
            case UPPER_CAMEL: {
                return CaseFormat.firstCharOnlyToUpper(word);
            }
            case UPPER_UNDERSCORE: {
                return Ascii.toUpperCase(word);
            }
        }
        throw new RuntimeException("unknown case: " + (Object)((Object)this));
    }

    private static String firstCharOnlyToUpper(String word) {
        int n2 = word.length();
        if (n2 == 0) {
            return word;
        }
        return new StringBuilder(n2).append(Ascii.toUpperCase(word.charAt(0))).append(Ascii.toLowerCase(word.substring(1))).toString();
    }
}

