/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.collect;

import com.timevale.guava.common.annotations.GwtCompatible;
import com.timevale.guava.common.annotations.GwtIncompatible;
import com.timevale.guava.common.collect.Platform;
import java.util.Collection;
import javax.annotation.Nullable;

@GwtCompatible(emulated=true)
public final class ObjectArrays {
    private ObjectArrays() {
    }

    @GwtIncompatible(value="Array.newInstance(Class, int)")
    public static <T> T[] newArray(Class<T> type, int length) {
        return Platform.newArray(type, length);
    }

    public static <T> T[] newArray(T[] reference, int length) {
        return Platform.newArray(reference, length);
    }

    @GwtIncompatible(value="Array.newInstance(Class, int)")
    public static <T> T[] concat(T[] first, T[] second, Class<T> type) {
        Object[] objectArray = ObjectArrays.newArray(type, first.length + second.length);
        Platform.unsafeArrayCopy(first, 0, objectArray, 0, first.length);
        Platform.unsafeArrayCopy(second, 0, objectArray, first.length, second.length);
        return objectArray;
    }

    public static <T> T[] concat(@Nullable T element, T[] array) {
        Object[] objectArray = ObjectArrays.newArray(array, array.length + 1);
        objectArray[0] = element;
        Platform.unsafeArrayCopy(array, 0, objectArray, 1, array.length);
        return objectArray;
    }

    public static <T> T[] concat(T[] array, @Nullable T element) {
        T[] TArray = ObjectArrays.arraysCopyOf(array, array.length + 1);
        TArray[array.length] = element;
        return TArray;
    }

    static <T> T[] arraysCopyOf(T[] original, int newLength) {
        Object[] objectArray = ObjectArrays.newArray(original, newLength);
        Platform.unsafeArrayCopy(original, 0, objectArray, 0, Math.min(original.length, newLength));
        return objectArray;
    }

    static <T> T[] toArrayImpl(Collection<?> c2, T[] array) {
        int n2 = c2.size();
        if (array.length < n2) {
            array = ObjectArrays.newArray(array, n2);
        }
        ObjectArrays.fillArray(c2, array);
        if (array.length > n2) {
            array[n2] = null;
        }
        return array;
    }

    static Object[] toArrayImpl(Collection<?> c2) {
        return ObjectArrays.fillArray(c2, new Object[c2.size()]);
    }

    private static Object[] fillArray(Iterable<?> elements, Object[] array) {
        int n2 = 0;
        for (Object obj : elements) {
            array[n2++] = obj;
        }
        return array;
    }

    static void swap(Object[] array, int i2, int j2) {
        Object object = array[i2];
        array[i2] = array[j2];
        array[j2] = object;
    }
}

