/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.collect;

import com.timevale.guava.common.annotations.GwtCompatible;
import com.timevale.guava.common.base.Preconditions;
import com.timevale.guava.common.collect.AbstractIndexedListIterator;
import com.timevale.guava.common.collect.Collections2;
import com.timevale.guava.common.collect.ImmutableList;
import com.timevale.guava.common.collect.Iterators;
import com.timevale.guava.common.collect.ObjectArrays;
import com.timevale.guava.common.collect.UnmodifiableIterator;
import com.timevale.guava.common.collect.UnmodifiableListIterator;
import java.util.List;
import javax.annotation.Nullable;

@GwtCompatible(serializable=true, emulated=true)
class RegularImmutableList<E>
extends ImmutableList<E> {
    private final transient int offset;
    private final transient int size;
    private final transient Object[] array;

    RegularImmutableList(Object[] array, int offset, int size) {
        this.offset = offset;
        this.size = size;
        this.array = array;
    }

    RegularImmutableList(Object[] array) {
        this(array, 0, array.length);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    boolean isPartialView() {
        return this.offset != 0 || this.size != this.array.length;
    }

    @Override
    public boolean contains(@Nullable Object target) {
        return this.indexOf(target) != -1;
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return Iterators.forArray(this.array, this.offset, this.size);
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        System.arraycopy(this.array, this.offset, objectArray, 0, this.size);
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] other) {
        if (other.length < this.size) {
            other = ObjectArrays.newArray(other, this.size);
        } else if (other.length > this.size) {
            other[this.size] = null;
        }
        System.arraycopy(this.array, this.offset, other, 0, this.size);
        return other;
    }

    @Override
    public E get(int index) {
        Preconditions.checkElementIndex(index, this.size);
        return (E)this.array[index + this.offset];
    }

    @Override
    public int indexOf(@Nullable Object target) {
        if (target != null) {
            for (int i2 = this.offset; i2 < this.offset + this.size; ++i2) {
                if (!this.array[i2].equals(target)) continue;
                return i2 - this.offset;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(@Nullable Object target) {
        if (target != null) {
            for (int i2 = this.offset + this.size - 1; i2 >= this.offset; --i2) {
                if (!this.array[i2].equals(target)) continue;
                return i2 - this.offset;
            }
        }
        return -1;
    }

    @Override
    public ImmutableList<E> subList(int fromIndex, int toIndex) {
        Preconditions.checkPositionIndexes(fromIndex, toIndex, this.size);
        return fromIndex == toIndex ? ImmutableList.of() : new RegularImmutableList<E>(this.array, this.offset + fromIndex, toIndex - fromIndex);
    }

    @Override
    public UnmodifiableListIterator<E> listIterator(int start) {
        return new AbstractIndexedListIterator<E>(this.size, start){

            @Override
            protected E get(int index) {
                return RegularImmutableList.this.array[index + RegularImmutableList.this.offset];
            }
        };
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (this.size() != list.size()) {
            return false;
        }
        int n2 = this.offset;
        if (object instanceof RegularImmutableList) {
            RegularImmutableList regularImmutableList = (RegularImmutableList)object;
            for (int i2 = regularImmutableList.offset; i2 < regularImmutableList.offset + regularImmutableList.size; ++i2) {
                if (this.array[n2++].equals(regularImmutableList.array[i2])) continue;
                return false;
            }
        } else {
            for (Object e2 : list) {
                if (this.array[n2++].equals(e2)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n2 = 1;
        for (int i2 = this.offset; i2 < this.offset + this.size; ++i2) {
            n2 = 31 * n2 + this.array[i2].hashCode();
        }
        return n2;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = Collections2.newStringBuilderForCollection(this.size()).append('[').append(this.array[this.offset]);
        for (int i2 = this.offset + 1; i2 < this.offset + this.size; ++i2) {
            stringBuilder.append(", ").append(this.array[i2]);
        }
        return stringBuilder.append(']').toString();
    }
}

