/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.jcajce.provider.mceliece;

import com.timevale.tgtext.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.timevale.tgtext.bouncycastle.pqc.asn1.McElieceCCA2PrivateKey;
import com.timevale.tgtext.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.jcajce.provider.mceliece.Utils;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;
import java.io.IOException;
import java.security.PrivateKey;

public class BCMcElieceCCA2PrivateKey
implements PrivateKey {
    private static final long serialVersionUID = 1L;
    private McElieceCCA2PrivateKeyParameters params;

    public BCMcElieceCCA2PrivateKey(McElieceCCA2PrivateKeyParameters mcElieceCCA2PrivateKeyParameters) {
        this.params = mcElieceCCA2PrivateKeyParameters;
    }

    @Override
    public String getAlgorithm() {
        return "McEliece-CCA2";
    }

    public int getN() {
        return this.params.getN();
    }

    public int getK() {
        return this.params.getK();
    }

    public int getT() {
        return this.params.getGoppaPoly().getDegree();
    }

    public GF2mField getField() {
        return this.params.getField();
    }

    public PolynomialGF2mSmallM getGoppaPoly() {
        return this.params.getGoppaPoly();
    }

    public Permutation getP() {
        return this.params.getP();
    }

    public GF2Matrix getH() {
        return this.params.getH();
    }

    public PolynomialGF2mSmallM[] getQInv() {
        return this.params.getQInv();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof BCMcElieceCCA2PrivateKey)) {
            return false;
        }
        BCMcElieceCCA2PrivateKey bCMcElieceCCA2PrivateKey = (BCMcElieceCCA2PrivateKey)object;
        return this.getN() == bCMcElieceCCA2PrivateKey.getN() && this.getK() == bCMcElieceCCA2PrivateKey.getK() && this.getField().equals(bCMcElieceCCA2PrivateKey.getField()) && this.getGoppaPoly().equals(bCMcElieceCCA2PrivateKey.getGoppaPoly()) && this.getP().equals(bCMcElieceCCA2PrivateKey.getP()) && this.getH().equals(bCMcElieceCCA2PrivateKey.getH());
    }

    public int hashCode() {
        int n2 = this.params.getK();
        n2 = n2 * 37 + this.params.getN();
        n2 = n2 * 37 + this.params.getField().hashCode();
        n2 = n2 * 37 + this.params.getGoppaPoly().hashCode();
        n2 = n2 * 37 + this.params.getP().hashCode();
        return n2 * 37 + this.params.getH().hashCode();
    }

    @Override
    public byte[] getEncoded() {
        try {
            McElieceCCA2PrivateKey mcElieceCCA2PrivateKey = new McElieceCCA2PrivateKey(this.getN(), this.getK(), this.getField(), this.getGoppaPoly(), this.getP(), Utils.getDigAlgId(this.params.getDigest()));
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.mcElieceCca2);
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(algorithmIdentifier, mcElieceCCA2PrivateKey);
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    AsymmetricKeyParameter getKeyParams() {
        return this.params;
    }
}

