/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.text.pdf.security;

import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.DEROctetString;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.x509.Extension;
import com.timevale.tgtext.bouncycastle.asn1.x509.Extensions;
import com.timevale.tgtext.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import com.timevale.tgtext.bouncycastle.cert.ocsp.BasicOCSPResp;
import com.timevale.tgtext.bouncycastle.cert.ocsp.CertificateID;
import com.timevale.tgtext.bouncycastle.cert.ocsp.CertificateStatus;
import com.timevale.tgtext.bouncycastle.cert.ocsp.OCSPException;
import com.timevale.tgtext.bouncycastle.cert.ocsp.OCSPReq;
import com.timevale.tgtext.bouncycastle.cert.ocsp.OCSPReqBuilder;
import com.timevale.tgtext.bouncycastle.cert.ocsp.OCSPResp;
import com.timevale.tgtext.bouncycastle.cert.ocsp.SingleResp;
import com.timevale.tgtext.bouncycastle.jce.provider.BouncyCastleProvider;
import com.timevale.tgtext.bouncycastle.operator.OperatorException;
import com.timevale.tgtext.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import com.timevale.tgtext.text.a.a;
import com.timevale.tgtext.text.io.m;
import com.timevale.tgtext.text.log.Level;
import com.timevale.tgtext.text.log.Logger;
import com.timevale.tgtext.text.log.b;
import com.timevale.tgtext.text.pdf.ce;
import com.timevale.tgtext.text.pdf.security.OcspClient;
import com.timevale.tgtext.text.pdf.security.d;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class q
implements OcspClient {
    private static final Logger Pn = b.getLogger(q.class);

    private static OCSPReq a(X509Certificate x509Certificate, BigInteger bigInteger) throws OCSPException, IOException, OperatorException, CertificateEncodingException {
        if (null != Security.getProvider("BC")) {
            Security.addProvider(new BouncyCastleProvider());
        }
        CertificateID certificateID = new CertificateID(new JcaDigestCalculatorProviderBuilder().build().get(CertificateID.HASH_SHA1), new JcaX509CertificateHolder(x509Certificate), bigInteger);
        OCSPReqBuilder oCSPReqBuilder = new OCSPReqBuilder();
        oCSPReqBuilder.addRequest(certificateID);
        Extension extension = new Extension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, false, (ASN1OctetString)new DEROctetString(new DEROctetString(ce.LG()).getEncoded()));
        oCSPReqBuilder.setRequestExtensions(new Extensions(new Extension[]{extension}));
        return oCSPReqBuilder.build();
    }

    private OCSPResp a(X509Certificate x509Certificate, X509Certificate x509Certificate2, String string) throws GeneralSecurityException, OCSPException, IOException, OperatorException {
        if (x509Certificate == null || x509Certificate2 == null) {
            return null;
        }
        if (string == null) {
            string = d.i(x509Certificate);
        }
        if (string == null) {
            return null;
        }
        Pn.info("Getting OCSP from " + string);
        OCSPReq oCSPReq = q.a(x509Certificate2, x509Certificate.getSerialNumber());
        byte[] byArray = oCSPReq.getEncoded();
        URL uRL = new URL(string);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestProperty("Content-Type", "application/ocsp-request");
        httpURLConnection.setRequestProperty("Accept", "application/ocsp-response");
        httpURLConnection.setDoOutput(true);
        OutputStream outputStream = httpURLConnection.getOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(outputStream));
        dataOutputStream.write(byArray);
        dataOutputStream.flush();
        dataOutputStream.close();
        if (httpURLConnection.getResponseCode() / 100 != 2) {
            throw new IOException(a.y("invalid.http.response.1", httpURLConnection.getResponseCode()));
        }
        InputStream inputStream = (InputStream)httpURLConnection.getContent();
        return new OCSPResp(m.m(inputStream));
    }

    public BasicOCSPResp b(X509Certificate x509Certificate, X509Certificate x509Certificate2, String string) {
        try {
            OCSPResp oCSPResp = this.a(x509Certificate, x509Certificate2, string);
            if (oCSPResp == null) {
                return null;
            }
            if (oCSPResp.getStatus() != 0) {
                return null;
            }
            return (BasicOCSPResp)oCSPResp.getResponseObject();
        }
        catch (Exception exception) {
            if (Pn.isLogging(Level.ERROR)) {
                Pn.error(exception.getMessage());
            }
            return null;
        }
    }

    @Override
    public byte[] getEncoded(X509Certificate checkCert, X509Certificate rootCert, String url) {
        block4: {
            try {
                SingleResp[] singleRespArray;
                BasicOCSPResp basicOCSPResp = this.b(checkCert, rootCert, url);
                if (basicOCSPResp != null && (singleRespArray = basicOCSPResp.getResponses()).length == 1) {
                    SingleResp singleResp = singleRespArray[0];
                    CertificateStatus certificateStatus = singleResp.getCertStatus();
                    if (certificateStatus == CertificateStatus.GOOD) {
                        return basicOCSPResp.getEncoded();
                    }
                    throw new IOException(a.h("ocsp.status.is.unknown", new Object[0]));
                }
            }
            catch (Exception exception) {
                if (!Pn.isLogging(Level.ERROR)) break block4;
                Pn.error(exception.getMessage());
            }
        }
        return null;
    }
}

