/*
 * Decompiled with CFR 0.152.
 */
package esign.utils.modeladapter.impl;

import com.google.gson.JsonElement;
import esign.utils.http.HttpExtend;
import esign.utils.httpclient.Method;
import esign.utils.modeladapter.model.SuperModel;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UrlBuilder {
    private String path;
    private SuperModel model;

    public UrlBuilder(String path, SuperModel model) {
        this.path = path;
        this.model = model;
    }

    public String build() {
        StringBuilder stringBuilder = new StringBuilder();
        this.buildPath(stringBuilder);
        boolean bl2 = this.addParamJoiner();
        if (bl2) {
            stringBuilder.append('?');
        }
        this.buildParam(stringBuilder);
        this.buildService(stringBuilder);
        if (bl2) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    private boolean addParamJoiner() {
        if (null == this.model) {
            return false;
        }
        if (null != this.model.getParams() && !this.model.getParams().isEmpty()) {
            return true;
        }
        return this.model.getMethod().equals((Object)Method.Get) && !this.model.getJson().entrySet().isEmpty();
    }

    private void buildPath(StringBuilder url) {
        if (null == this.model.getPaths() || this.model.getPaths().isEmpty()) {
            url.append(this.path);
            return;
        }
        String string = this.path;
        List<HttpExtend> list = this.model.getPaths();
        for (HttpExtend httpExtend : list) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{").append(httpExtend.getName()).append("}");
            string = string.replace(stringBuilder, (String)httpExtend.getValue());
        }
        url.append(string);
    }

    private void buildParam(StringBuilder url) {
        if (null == this.model.getParams() || this.model.getParams().isEmpty()) {
            return;
        }
        for (HttpExtend httpExtend : this.model.getParams()) {
            url.append(httpExtend.getName()).append('=').append(httpExtend.getValue()).append('&');
        }
    }

    private void buildService(StringBuilder url) {
        if (!this.model.getMethod().equals((Object)Method.Get)) {
            return;
        }
        Set set = this.model.getJson().entrySet();
        if (set.isEmpty()) {
            return;
        }
        for (Map.Entry entry : set) {
            if (null == entry.getValue() || ((JsonElement)entry.getValue()).isJsonNull()) continue;
            url.append((String)entry.getKey()).append('=').append(((JsonElement)entry.getValue()).getAsString()).append('&');
        }
    }
}

