/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.collect;

import com.timevale.guava.common.annotations.GwtCompatible;
import com.timevale.guava.common.base.Preconditions;
import com.timevale.guava.common.base.Supplier;
import com.timevale.guava.common.collect.RowSortedTable;
import com.timevale.guava.common.collect.StandardTable;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;

@GwtCompatible
class StandardRowSortedTable<R, C, V>
extends StandardTable<R, C, V>
implements RowSortedTable<R, C, V> {
    private transient SortedSet<R> rowKeySet;
    private transient RowSortedMap rowMap;
    private static final long serialVersionUID = 0L;

    StandardRowSortedTable(SortedMap<R, Map<C, V>> backingMap, Supplier<? extends Map<C, V>> factory) {
        super(backingMap, factory);
    }

    private SortedMap<R, Map<C, V>> sortedBackingMap() {
        return (SortedMap)this.backingMap;
    }

    @Override
    public SortedSet<R> rowKeySet() {
        RowKeySortedSet rowKeySortedSet = this.rowKeySet;
        return rowKeySortedSet == null ? (this.rowKeySet = new RowKeySortedSet()) : rowKeySortedSet;
    }

    @Override
    public SortedMap<R, Map<C, V>> rowMap() {
        RowSortedMap rowSortedMap = this.rowMap;
        return rowSortedMap == null ? (this.rowMap = new RowSortedMap()) : rowSortedMap;
    }

    private class RowSortedMap
    extends StandardTable.RowMap
    implements SortedMap {
        private RowSortedMap() {
        }

        public Comparator<? super R> comparator() {
            return StandardRowSortedTable.this.sortedBackingMap().comparator();
        }

        public R firstKey() {
            return StandardRowSortedTable.this.sortedBackingMap().firstKey();
        }

        public R lastKey() {
            return StandardRowSortedTable.this.sortedBackingMap().lastKey();
        }

        public SortedMap<R, Map<C, V>> headMap(R toKey) {
            Preconditions.checkNotNull(toKey);
            return new StandardRowSortedTable(StandardRowSortedTable.this.sortedBackingMap().headMap(toKey), StandardRowSortedTable.this.factory).rowMap();
        }

        public SortedMap<R, Map<C, V>> subMap(R fromKey, R toKey) {
            Preconditions.checkNotNull(fromKey);
            Preconditions.checkNotNull(toKey);
            return new StandardRowSortedTable(StandardRowSortedTable.this.sortedBackingMap().subMap(fromKey, toKey), StandardRowSortedTable.this.factory).rowMap();
        }

        public SortedMap<R, Map<C, V>> tailMap(R fromKey) {
            Preconditions.checkNotNull(fromKey);
            return new StandardRowSortedTable(StandardRowSortedTable.this.sortedBackingMap().tailMap(fromKey), StandardRowSortedTable.this.factory).rowMap();
        }
    }

    private class RowKeySortedSet
    extends StandardTable.RowKeySet
    implements SortedSet {
        private RowKeySortedSet() {
        }

        public Comparator<? super R> comparator() {
            return StandardRowSortedTable.this.sortedBackingMap().comparator();
        }

        public R first() {
            return StandardRowSortedTable.this.sortedBackingMap().firstKey();
        }

        public R last() {
            return StandardRowSortedTable.this.sortedBackingMap().lastKey();
        }

        public SortedSet<R> headSet(R toElement) {
            Preconditions.checkNotNull(toElement);
            return new StandardRowSortedTable(StandardRowSortedTable.this.sortedBackingMap().headMap(toElement), StandardRowSortedTable.this.factory).rowKeySet();
        }

        public SortedSet<R> subSet(R fromElement, R toElement) {
            Preconditions.checkNotNull(fromElement);
            Preconditions.checkNotNull(toElement);
            return new StandardRowSortedTable(StandardRowSortedTable.this.sortedBackingMap().subMap(fromElement, toElement), StandardRowSortedTable.this.factory).rowKeySet();
        }

        public SortedSet<R> tailSet(R fromElement) {
            Preconditions.checkNotNull(fromElement);
            return new StandardRowSortedTable(StandardRowSortedTable.this.sortedBackingMap().tailMap(fromElement), StandardRowSortedTable.this.factory).rowKeySet();
        }
    }
}

