/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cert.ocsp;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.ResponseData;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.SingleResponse;
import com.timevale.tgtext.bouncycastle.asn1.x509.Extensions;
import com.timevale.tgtext.bouncycastle.cert.ocsp.OCSPUtils;
import com.timevale.tgtext.bouncycastle.cert.ocsp.RespID;
import com.timevale.tgtext.bouncycastle.cert.ocsp.SingleResp;
import java.util.Date;

public class RespData {
    private ResponseData data;

    public RespData(ResponseData responseData) {
        this.data = responseData;
    }

    public int getVersion() {
        return this.data.getVersion().getValue().intValue() + 1;
    }

    public RespID getResponderId() {
        return new RespID(this.data.getResponderID());
    }

    public Date getProducedAt() {
        return OCSPUtils.extractDate(this.data.getProducedAt());
    }

    public SingleResp[] getResponses() {
        ASN1Sequence aSN1Sequence = this.data.getResponses();
        SingleResp[] singleRespArray = new SingleResp[aSN1Sequence.size()];
        for (int i2 = 0; i2 != singleRespArray.length; ++i2) {
            singleRespArray[i2] = new SingleResp(SingleResponse.getInstance(aSN1Sequence.getObjectAt(i2)));
        }
        return singleRespArray;
    }

    public Extensions getResponseExtensions() {
        return this.data.getResponseExtensions();
    }
}

