/*
 * Decompiled with CFR 0.152.
 */
package esign.utils.modeladapter.impl.rpc;

import com.google.gson.JsonObject;
import esign.utils.JsonHelper;
import esign.utils.exception.ErrorsDiscriptor;
import esign.utils.exception.SuperException;
import esign.utils.httpclient.HttpConfig;
import esign.utils.httpclient.HttpUtil;
import esign.utils.httpclient.Method;
import esign.utils.httpclient.ProjectAccesser;
import esign.utils.modeladapter.impl.rpc.bean.InterfaceUrlsInput;
import esign.utils.modeladapter.impl.rpc.bean.InterfaceUrlsOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProjectUrlsRpc {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectUrlsRpc.class);

    public static InterfaceUrlsOutput refresh(String url, HttpConfig httpConfig, ProjectAccesser accesser, String securityType) throws SuperException {
        InterfaceUrlsInput interfaceUrlsInput = new InterfaceUrlsInput();
        interfaceUrlsInput.setProjectId(accesser.getProjectId());
        interfaceUrlsInput.setProjectSecret(accesser.getUserSecret());
        interfaceUrlsInput.setHttpType(securityType);
        JsonObject jsonObject = HttpUtil.postSubmit(Method.Post, url, (JsonObject)JsonHelper.toGsonElement(interfaceUrlsInput), httpConfig);
        InterfaceUrlsOutput interfaceUrlsOutput = JsonHelper.fromJson(jsonObject, InterfaceUrlsOutput.class);
        if (0 != interfaceUrlsOutput.getErrCode()) {
            LOGGER.error("get url info from open api failed. code:{}, msg:{}", (Object)interfaceUrlsOutput.getErrCode(), (Object)interfaceUrlsOutput.getMsg());
            throw ErrorsDiscriptor.ExternalServiceTaken.e(interfaceUrlsOutput.getErrCode(), interfaceUrlsOutput.getMsg());
        }
        return interfaceUrlsOutput;
    }

    private ProjectUrlsRpc() {
    }
}

