/*
 * Decompiled with CFR 0.152.
 */
package esign.utils.security.cipher.impl.adapter;

import esign.utils.enumadp.EnumAdapter;
import esign.utils.enumadp.IEnumAdapter;
import esign.utils.security.model.DigestAlgorithmModel;

public enum DigestModelAdapter implements IEnumAdapter<DigestAlgorithmModel, DigestModelAdapter>
{
    MD5(DigestAlgorithmModel.MD5, "MD5"),
    SHA1(DigestAlgorithmModel.SHA1, "SHA1"),
    SHA256(DigestAlgorithmModel.SHA256, "SHA256");

    private String disc;
    private DigestAlgorithmModel digestType;
    private static final EnumAdapter<DigestModelAdapter, DigestAlgorithmModel, DigestModelAdapter> adapter;

    private DigestModelAdapter(DigestAlgorithmModel digestType, String disc) {
        this.disc = disc;
        this.digestType = digestType;
    }

    public static DigestModelAdapter from(DigestAlgorithmModel type) {
        return adapter.get(type);
    }

    public String algorithm() {
        return this.disc;
    }

    @Override
    public DigestAlgorithmModel getFrom() {
        return this.digestType;
    }

    @Override
    public DigestModelAdapter getTo() {
        return this;
    }

    static {
        adapter = new EnumAdapter(DigestModelAdapter.class);
    }
}

