/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.sign.a;

import com.timevale.esign.paas.tech.bean.bean.MultiSignatureInfo;
import com.timevale.esign.paas.tech.bean.bean.PosBean;
import com.timevale.esign.paas.tech.bean.bean.SignPDFDocBean;
import com.timevale.esign.paas.tech.bean.result.AccountInfoResult;
import com.timevale.esign.paas.tech.bean.result.CreateSignDetailResult;
import com.timevale.esign.paas.tech.bean.result.FileDigestSignResult;
import com.timevale.esign.paas.tech.client.AbstractServiceClient;
import com.timevale.esign.paas.tech.client.HiddenOperationDelegator;
import com.timevale.esign.paas.tech.common.Precondition;
import com.timevale.esign.paas.tech.constant.ErrorException;
import com.timevale.esign.paas.tech.constant.GbConstant;
import com.timevale.esign.paas.tech.enums.KeywordSignTypeEnum;
import com.timevale.esign.paas.tech.enums.SignType;
import com.timevale.esign.paas.tech.service.AccountService;
import com.timevale.esign.paas.tech.sign.IPdfSigner;
import com.timevale.esign.paas.tech.sign.b;
import com.timevale.esign.paas.tech.util.DigestUtil;
import com.timevale.esign.paas.tech.util.FileRWUtil;
import com.timevale.esign.paas.tech.util.TimeFormatUtil;
import com.timevale.tech.sdk.utils.ImageUtil;
import com.timevale.tgpdfsign.b.g;
import com.timevale.tgpdfsign.enums.DescriptionType;
import com.timevale.tgpdfsign.enums.EdgePosXAdjustType;
import com.timevale.tgpdfsign.enums.PdfGStateType;
import com.timevale.tgpdfsign.sign.e;
import com.timevale.tgpdfsign.sign.h;
import esign.utils.StringUtil;
import esign.utils.asserts.AssertSupport;
import esign.utils.bean.ResultUtil;
import esign.utils.exception.ErrorsDiscriptor;
import esign.utils.exception.SuperException;
import esign.utils.httpclient.HttpConfig;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class a
implements IPdfSigner {
    private static final Logger LOGGER = LoggerFactory.getLogger(a.class);
    protected static final float Jm = 159.0f;
    protected static final String Jn = "png";
    private static final String Jo = "Unknown system error: unknown seal type";
    protected static final int Jp = 6000;
    private static final String Jq = "iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVQImWNgYGBgAAAABQABh6FO1AAAAABJRU5ErkJggg==";
    private AbstractServiceClient Je;
    protected SignPDFDocBean Jr;
    protected MultiSignatureInfo Js;
    protected com.timevale.esign.paas.tech.sign.b.a Jt;
    private CreateSignDetailResult Ju;
    private String Jv;

    a(AbstractServiceClient abstractServiceClient, SignPDFDocBean signPDFDocBean, List<PosBean> list, SignType signType, String string, com.timevale.esign.paas.tech.sign.b.a a2) {
        this.Je = abstractServiceClient;
        this.Jr = signPDFDocBean;
        this.Jt = a2;
        this.Js = new MultiSignatureInfo(list, signType, string);
    }

    public AbstractServiceClient uy() {
        return this.Je;
    }

    public String getSealData() {
        return StringUtils.isEmpty((String)this.Js.getSealData()) ? Jq : this.Js.getSealData();
    }

    public void setSealData(String sealData) {
        this.Js.setSealData(sealData);
    }

    public List<PosBean> getSignPos() {
        return this.Js.getSignPos();
    }

    void setSignPos(List<PosBean> signPos) {
        this.Js.setSignPos(signPos);
    }

    void setSignType(SignType signType) {
        this.Js.setSignType(signType);
    }

    String uF() {
        if (StringUtil.isNull(this.Jv)) {
            this.Jv = "".concat(this.Ju.getViewSignDetailUrl()).concat("?id=").concat(this.Ju.getSignServiceId());
            if (this.Jt instanceof com.timevale.esign.paas.tech.sign.b.b && this.Ju.isNeedWillId()) {
                this.Jv = this.Jv + "&willAuthId=" + ((com.timevale.esign.paas.tech.sign.b.b)this.Jt).uQ();
            }
        }
        return this.Jv;
    }

    CreateSignDetailResult uG() {
        return this.Ju;
    }

    protected float a(PosBean posBean) throws SuperException {
        return posBean.getWidth();
    }

    protected float b(PosBean posBean) throws SuperException {
        return posBean.getHeight();
    }

    protected abstract void cV(String var1) throws SuperException;

    protected abstract void a(SignPDFDocBean var1) throws SuperException, IOException;

    @Override
    public FileDigestSignResult signPdf(String accountId) {
        FileDigestSignResult fileDigestSignResult = new FileDigestSignResult();
        try {
            Precondition.checkSignParam(this.Jr);
            this.a(this.Jr);
            this.Ju = this.a(this.Je, accountId);
            this.Jt.setSignServiceId(this.Ju.getSignServiceId());
            this.Jt.setAuthId(this.Ju.getAuthId());
            byte[] byArray = this.cW(accountId);
            this.uI();
            this.a(this.Je, accountId, byArray, this.Ju.getSignServiceId(), this.Ju.isNeedWillId());
            this.a(byArray, fileDigestSignResult);
        }
        catch (SuperException superException) {
            FileDigestSignResult fileDigestSignResult2 = ResultUtil.failed(superException, FileDigestSignResult.class);
            if (GbConstant.ACCOUNT_IDENTIFY_COST_ERROR_CODE.contains(superException.getCode())) {
                fileDigestSignResult2.setContrastLegalRepInfo(true);
            } else {
                fileDigestSignResult2.setContrastLegalRepInfo(Objects.nonNull(this.Ju) && this.Ju.isContrastLegalRepInfo());
            }
            return fileDigestSignResult2;
        }
        catch (Exception exception) {
            LOGGER.error("sign pdf failed.", (Throwable)exception);
            FileDigestSignResult fileDigestSignResult3 = ResultUtil.failed(10000, exception.getMessage(), true, FileDigestSignResult.class);
            fileDigestSignResult3.setContrastLegalRepInfo(Objects.nonNull(this.Ju) && this.Ju.isContrastLegalRepInfo());
            return fileDigestSignResult3;
        }
        fileDigestSignResult.setSignServiceId(this.Ju.getSignServiceId());
        fileDigestSignResult.setAuthId(this.Ju.getAuthId());
        fileDigestSignResult.setContrastLegalRepInfo(this.Ju.isContrastLegalRepInfo());
        return fileDigestSignResult;
    }

    protected CreateSignDetailResult a(AbstractServiceClient abstractServiceClient, String string) throws SuperException {
        return b.a(abstractServiceClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] cW(String string) throws SuperException {
        LOGGER.debug("sign begin: {}", (Object)System.currentTimeMillis());
        Precondition.checkSignParam(this.Js.getSignType(), this.Js.getSignPos());
        this.cV(string);
        e e2 = this.b(this.Jr);
        e2.o(this.uH());
        try {
            if (e2.xt() != 0) {
                throw ErrorsDiscriptor.PdfSigningCreateStampFailed.e();
            }
            byte[] byArray = e2.xC();
            String string2 = DigestUtil.sha256Digest(byArray);
            LOGGER.debug("sign call: {}", (Object)System.currentTimeMillis());
            int n2 = this.Jt.sign(string, string2, this.Jt.getCode());
            AssertSupport.assertTrue(0 == n2, ErrorsDiscriptor.PdfSign.e(n2));
            e2.s(this.Jt.signature(), string2);
            byte[] byArray2 = e2.xy();
            return byArray2;
        }
        finally {
            e2.xp();
            LOGGER.debug("sign end: {}", (Object)System.currentTimeMillis());
        }
    }

    private List<h> uH() throws SuperException {
        ArrayList<h> arrayList = new ArrayList<h>();
        SignType signType = this.Js.getSignType();
        for (PosBean posBean : this.Js.getSignPos()) {
            h h2 = new h();
            h2.g(posBean.getPosX());
            h2.h(posBean.getPosY());
            h2.dk(posBean.getCoordinateValueType().type());
            h2.di(posBean.getCoordinateReferencePointStrategy().type());
            h2.dj(posBean.getSignatureReferencePointStrategy().type());
            h2.cU(posBean.getPosPage());
            h2.cX(signType.val());
            h2.setAddSignTime(posBean.isAddSignTime());
            h2.dM(this.uF());
            h2.setKeyword(posBean.getKeyWord());
            h2.a(PdfGStateType.BM_MULTIPLY);
            h2.dn(KeywordSignTypeEnum.getInnerType(posBean.getKeywordSignType()));
            com.timevale.tgpdfsign.b.a a2 = h2.yh().wS().wR();
            if (SignType.Edges.equals((Object)signType)) {
                if (posBean.isEdgePosXAdjust()) {
                    h2.dh(EdgePosXAdjustType.ADJUST.getType());
                }
                h2.o(0.0f);
            }
            a2.setHeight(this.b(posBean));
            a2.setWidth(this.a(posBean));
            a2.setData(this.Js.getSealData());
            if (posBean.getTimeX() != null || posBean.getTimeY() != null) {
                g g2 = new g();
                g2.setType(DescriptionType.TEXT.getType());
                g2.j(posBean.getTimeY() == null ? 0.0f : posBean.getTimeY().floatValue());
                g2.i(posBean.getTimeX() == null ? 0.0f : posBean.getTimeX().floatValue());
                g2.dq(posBean.getPosPage());
                g2.l(10.0f);
                g2.cY(1);
                g2.setDescription(TimeFormatUtil.dateTimeToString(new Date()));
                ArrayList<g> arrayList2 = new ArrayList<g>();
                arrayList2.add(g2);
                h2.r(arrayList2);
            }
            arrayList.add(h2);
        }
        return arrayList;
    }

    private void uI() throws SuperException {
    }

    protected void a(AbstractServiceClient abstractServiceClient, String string, byte[] byArray, String string2, boolean bl2) throws SuperException {
        String string3 = DigestUtil.sha256Digest(this.Jr.getStream());
        String string4 = DigestUtil.sha256Digest(byArray);
        LOGGER.debug("start save sign log, time={}", (Object)System.currentTimeMillis());
        String string5 = null;
        b.a(abstractServiceClient, string, this.Jt.getDigest(), this.Jt.signature(), this.Jr.getFileName(), string5, string2, this.Jt.getIntendSignLogRef(), string3, string4);
        LOGGER.debug("end save sign log, time={}", (Object)System.currentTimeMillis());
    }

    protected e b(SignPDFDocBean signPDFDocBean) throws SuperException {
        e e2 = new e(signPDFDocBean.getOwnerPassword().getBytes());
        if (signPDFDocBean.isStreamMode() ? e2.af(signPDFDocBean.getStream()) != 0 : e2.dt(signPDFDocBean.getSrcFile()) != 0) {
            throw ErrorsDiscriptor.PDF_OPEN_FAILED.e();
        }
        HttpConfig httpConfig = HiddenOperationDelegator.networkConfig(this.uy());
        e2.setProxy(httpConfig.getProxyIp(), httpConfig.getProxyPort());
        return e2;
    }

    private void a(byte[] byArray, FileDigestSignResult fileDigestSignResult) throws SuperException {
        AssertSupport.assertTrue(byArray != null && byArray.length > 0, ErrorsDiscriptor.direct(10000, Jo));
        long l2 = System.currentTimeMillis();
        String string = this.Jr.getDstFile();
        if (!StringUtil.isNull(string)) {
            File file = FileRWUtil.createFileIfNotExist(string);
            try {
                FileRWUtil.writeFile(file, byArray);
            }
            catch (IOException iOException) {
                throw ErrorException.convertException(2006);
            }
            fileDigestSignResult.setDstFilePath(file.getAbsolutePath());
        } else {
            fileDigestSignResult.setStream(byArray);
        }
        LOGGER.debug("saveFile cost:{}", (Object)(System.currentTimeMillis() - l2));
    }

    protected AccountInfoResult cS(String string) throws SuperException {
        AccountService accountService = this.uy().accountService();
        return accountService.getAccountInfoSuccessful(string, false);
    }

    protected BufferedImage uJ() throws SuperException {
        BufferedImage bufferedImage;
        try {
            bufferedImage = ImageUtil.base64ToBufferedImage(this.getSealData());
        }
        catch (Exception exception) {
            LOGGER.error("invalid base64 sealData.", (Throwable)exception);
            throw ErrorsDiscriptor.BadSealImageData.e();
        }
        AssertSupport.assertNotnull(bufferedImage, ErrorsDiscriptor.BadSealImageData.e());
        return bufferedImage;
    }
}

