/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.collect;

import com.timevale.guava.common.base.Equivalence;
import com.timevale.guava.common.base.Function;
import com.timevale.guava.common.base.Preconditions;
import com.timevale.guava.common.base.Throwables;
import com.timevale.guava.common.collect.ComputationException;
import com.timevale.guava.common.collect.CustomConcurrentHashMap;
import com.timevale.guava.common.collect.MapMaker;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReferenceArray;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

class ComputingConcurrentHashMap<K, V>
extends CustomConcurrentHashMap<K, V> {
    final Function<? super K, ? extends V> computingFunction;
    private static final long serialVersionUID = 4L;

    ComputingConcurrentHashMap(MapMaker builder, Function<? super K, ? extends V> computingFunction) {
        super(builder);
        this.computingFunction = Preconditions.checkNotNull(computingFunction);
    }

    @Override
    CustomConcurrentHashMap.Segment<K, V> createSegment(int initialCapacity, int maxSegmentSize) {
        return new ComputingSegment(this, initialCapacity, maxSegmentSize);
    }

    @Override
    ComputingSegment<K, V> segmentFor(int hash) {
        return (ComputingSegment)super.segmentFor(hash);
    }

    V getOrCompute(K key) throws ExecutionException {
        int n2 = this.hash(Preconditions.checkNotNull(key));
        return ((ComputingSegment)this.segmentFor(n2)).getOrCompute(key, n2, this.computingFunction);
    }

    @Override
    Object writeReplace() {
        return new ComputingSerializationProxy<K, V>(this.keyStrength, this.valueStrength, this.keyEquivalence, this.valueEquivalence, this.expireAfterWriteNanos, this.expireAfterAccessNanos, this.maximumSize, this.concurrencyLevel, this.removalListener, this, this.computingFunction);
    }

    static final class ComputingSerializationProxy<K, V>
    extends CustomConcurrentHashMap.AbstractSerializationProxy<K, V> {
        final Function<? super K, ? extends V> computingFunction;
        private static final long serialVersionUID = 4L;

        ComputingSerializationProxy(CustomConcurrentHashMap.Strength keyStrength, CustomConcurrentHashMap.Strength valueStrength, Equivalence<Object> keyEquivalence, Equivalence<Object> valueEquivalence, long expireAfterWriteNanos, long expireAfterAccessNanos, int maximumSize, int concurrencyLevel, MapMaker.RemovalListener<? super K, ? super V> removalListener, ConcurrentMap<K, V> delegate, Function<? super K, ? extends V> computingFunction) {
            super(keyStrength, valueStrength, keyEquivalence, valueEquivalence, expireAfterWriteNanos, expireAfterAccessNanos, maximumSize, concurrencyLevel, removalListener, delegate);
            this.computingFunction = computingFunction;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            this.writeMapTo(out);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            MapMaker mapMaker = this.readMapMaker(in);
            this.delegate = mapMaker.makeComputingMap(this.computingFunction);
            this.readEntries(in);
        }

        Object readResolve() {
            return this.delegate;
        }
    }

    static final class ComputingMapAdapter<K, V>
    extends ComputingConcurrentHashMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = 0L;

        ComputingMapAdapter(MapMaker mapMaker, Function<? super K, ? extends V> computingFunction) {
            super(mapMaker, computingFunction);
        }

        @Override
        public V get(Object key) {
            Object v2;
            try {
                v2 = this.getOrCompute(key);
            }
            catch (ExecutionException executionException) {
                Throwable throwable = executionException.getCause();
                Throwables.propagateIfInstanceOf(throwable, ComputationException.class);
                throw new ComputationException(throwable);
            }
            if (v2 == null) {
                throw new NullPointerException(this.computingFunction + " returned null for key " + key + ".");
            }
            return v2;
        }
    }

    private static final class ComputingValueReference<K, V>
    implements CustomConcurrentHashMap.ValueReference<K, V> {
        final Function<? super K, ? extends V> computingFunction;
        @GuardedBy(value="ComputingValueReference.this")
        volatile CustomConcurrentHashMap.ValueReference<K, V> computedReference = CustomConcurrentHashMap.unset();

        public ComputingValueReference(Function<? super K, ? extends V> computingFunction) {
            this.computingFunction = computingFunction;
        }

        @Override
        public V get() {
            return null;
        }

        @Override
        public CustomConcurrentHashMap.ReferenceEntry<K, V> getEntry() {
            return null;
        }

        @Override
        public CustomConcurrentHashMap.ValueReference<K, V> copyFor(ReferenceQueue<V> queue, CustomConcurrentHashMap.ReferenceEntry<K, V> entry) {
            return this;
        }

        @Override
        public boolean isComputingReference() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V waitForValue() throws ExecutionException {
            if (this.computedReference == CustomConcurrentHashMap.UNSET) {
                boolean bl2 = false;
                try {
                    ComputingValueReference computingValueReference = this;
                    synchronized (computingValueReference) {
                        while (this.computedReference == CustomConcurrentHashMap.UNSET) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                bl2 = true;
                            }
                        }
                    }
                }
                finally {
                    if (bl2) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            return this.computedReference.waitForValue();
        }

        @Override
        public void clear(CustomConcurrentHashMap.ValueReference<K, V> newValue) {
            this.setValueReference(newValue);
        }

        V compute(K key, int hash) throws ExecutionException {
            V v2;
            try {
                v2 = this.computingFunction.apply(key);
            }
            catch (Throwable throwable) {
                this.setValueReference(new ComputationExceptionReference(throwable));
                throw new ExecutionException(throwable);
            }
            this.setValueReference(new ComputedReference(v2));
            return v2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setValueReference(CustomConcurrentHashMap.ValueReference<K, V> valueReference) {
            ComputingValueReference computingValueReference = this;
            synchronized (computingValueReference) {
                if (this.computedReference == CustomConcurrentHashMap.UNSET) {
                    this.computedReference = valueReference;
                    this.notifyAll();
                }
            }
        }
    }

    private static final class ComputedReference<K, V>
    implements CustomConcurrentHashMap.ValueReference<K, V> {
        final V value;

        ComputedReference(@Nullable V value) {
            this.value = value;
        }

        @Override
        public V get() {
            return this.value;
        }

        @Override
        public CustomConcurrentHashMap.ReferenceEntry<K, V> getEntry() {
            return null;
        }

        @Override
        public CustomConcurrentHashMap.ValueReference<K, V> copyFor(ReferenceQueue<V> queue, CustomConcurrentHashMap.ReferenceEntry<K, V> entry) {
            return this;
        }

        @Override
        public boolean isComputingReference() {
            return false;
        }

        @Override
        public V waitForValue() {
            return this.get();
        }

        @Override
        public void clear(CustomConcurrentHashMap.ValueReference<K, V> newValue) {
        }
    }

    private static final class ComputationExceptionReference<K, V>
    implements CustomConcurrentHashMap.ValueReference<K, V> {
        final Throwable t;

        ComputationExceptionReference(Throwable t2) {
            this.t = t2;
        }

        @Override
        public V get() {
            return null;
        }

        @Override
        public CustomConcurrentHashMap.ReferenceEntry<K, V> getEntry() {
            return null;
        }

        @Override
        public CustomConcurrentHashMap.ValueReference<K, V> copyFor(ReferenceQueue<V> queue, CustomConcurrentHashMap.ReferenceEntry<K, V> entry) {
            return this;
        }

        @Override
        public boolean isComputingReference() {
            return false;
        }

        @Override
        public V waitForValue() throws ExecutionException {
            throw new ExecutionException(this.t);
        }

        @Override
        public void clear(CustomConcurrentHashMap.ValueReference<K, V> newValue) {
        }
    }

    static final class ComputingSegment<K, V>
    extends CustomConcurrentHashMap.Segment<K, V> {
        ComputingSegment(CustomConcurrentHashMap<K, V> map, int initialCapacity, int maxSegmentSize) {
            super(map, initialCapacity, maxSegmentSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        V getOrCompute(K key, int hash, Function<? super K, ? extends V> computingFunction) throws ExecutionException {
            try {
                ComputingValueReference<? super K, ? extends V> computingValueReference;
                CustomConcurrentHashMap.ReferenceEntry<Object, Object> referenceEntry;
                Object v2;
                do {
                    if ((referenceEntry = this.getEntry(key, hash)) != null && (v2 = this.getLiveValue(referenceEntry)) != null) {
                        this.recordRead(referenceEntry);
                        computingValueReference = (ComputingValueReference<? super K, ? extends V>)v2;
                        return (V)computingValueReference;
                    }
                    if (referenceEntry == null || !referenceEntry.getValueReference().isComputingReference()) {
                        boolean bl2;
                        block22: {
                            bl2 = true;
                            computingValueReference = null;
                            this.lock();
                            try {
                                CustomConcurrentHashMap.ReferenceEntry<Object, Object> referenceEntry2;
                                this.preWriteCleanup();
                                int n2 = this.count - 1;
                                AtomicReferenceArray atomicReferenceArray = this.table;
                                int n3 = hash & atomicReferenceArray.length() - 1;
                                for (referenceEntry = referenceEntry2 = (CustomConcurrentHashMap.ReferenceEntry<Object, Object>)atomicReferenceArray.get(n3); referenceEntry != null; referenceEntry = referenceEntry.getNext()) {
                                    Object k2 = referenceEntry.getKey();
                                    if (referenceEntry.getHash() != hash || k2 == null || !this.map.keyEquivalence.equivalent(key, k2)) continue;
                                    CustomConcurrentHashMap.ValueReference valueReference = referenceEntry.getValueReference();
                                    if (valueReference.isComputingReference()) {
                                        bl2 = false;
                                        break;
                                    }
                                    Object v3 = referenceEntry.getValueReference().get();
                                    if (v3 == null) {
                                        this.enqueueNotification(k2, hash, v3, MapMaker.RemovalCause.COLLECTED);
                                    } else if (this.map.expires() && this.map.isExpired(referenceEntry)) {
                                        this.enqueueNotification(k2, hash, v3, MapMaker.RemovalCause.EXPIRED);
                                    } else {
                                        this.recordLockedRead(referenceEntry);
                                        Object v4 = v3;
                                        return v4;
                                    }
                                    this.evictionQueue.remove(referenceEntry);
                                    this.expirationQueue.remove(referenceEntry);
                                    this.count = n2;
                                    break;
                                }
                                if (!bl2) break block22;
                                computingValueReference = new ComputingValueReference<K, V>(computingFunction);
                                if (referenceEntry == null) {
                                    referenceEntry = this.newEntry(key, hash, referenceEntry2);
                                    referenceEntry.setValueReference(computingValueReference);
                                    atomicReferenceArray.set(n3, referenceEntry);
                                } else {
                                    referenceEntry.setValueReference(computingValueReference);
                                }
                            }
                            finally {
                                this.unlock();
                                this.postWriteCleanup();
                            }
                        }
                        if (bl2) {
                            V v5 = this.compute(key, hash, referenceEntry, computingValueReference);
                            return v5;
                        }
                    }
                    Preconditions.checkState(!Thread.holdsLock(referenceEntry), "Recursive computation");
                } while ((v2 = referenceEntry.getValueReference().waitForValue()) == null);
                this.recordRead(referenceEntry);
                computingValueReference = (ComputingValueReference<? super K, ? extends V>)v2;
                return (V)computingValueReference;
            }
            finally {
                this.postReadCleanup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V compute(K key, int hash, CustomConcurrentHashMap.ReferenceEntry<K, V> e2, ComputingValueReference<K, V> computingValueReference) throws ExecutionException {
            Object v2 = null;
            long l2 = System.nanoTime();
            long l3 = 0L;
            try {
                CustomConcurrentHashMap.ReferenceEntry<K, V> referenceEntry = e2;
                synchronized (referenceEntry) {
                    v2 = computingValueReference.compute(key, hash);
                    l3 = System.nanoTime();
                }
                if (v2 != null && (referenceEntry = this.put(key, hash, v2, true)) != null) {
                    this.enqueueNotification(key, hash, v2, MapMaker.RemovalCause.REPLACED);
                }
                referenceEntry = v2;
                return (V)referenceEntry;
            }
            finally {
                if (l3 == 0L) {
                    l3 = System.nanoTime();
                }
                if (v2 == null) {
                    this.clearValue(key, hash, computingValueReference);
                }
            }
        }
    }
}

