/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.eac;

import com.timevale.tgtext.bouncycastle.asn1.DERApplicationSpecific;
import com.timevale.tgtext.bouncycastle.asn1.eac.CVCertificate;
import com.timevale.tgtext.bouncycastle.asn1.eac.CertificateBody;
import com.timevale.tgtext.bouncycastle.asn1.eac.CertificateHolderAuthorization;
import com.timevale.tgtext.bouncycastle.asn1.eac.CertificateHolderReference;
import com.timevale.tgtext.bouncycastle.asn1.eac.CertificationAuthorityReference;
import com.timevale.tgtext.bouncycastle.asn1.eac.PackedDate;
import com.timevale.tgtext.bouncycastle.asn1.eac.PublicKeyDataObject;
import com.timevale.tgtext.bouncycastle.eac.EACCertificateHolder;
import com.timevale.tgtext.bouncycastle.eac.EACException;
import com.timevale.tgtext.bouncycastle.eac.operator.EACSigner;
import java.io.OutputStream;

public class EACCertificateBuilder {
    private static final byte[] ZeroArray = new byte[]{0};
    private PublicKeyDataObject publicKey;
    private CertificateHolderAuthorization certificateHolderAuthorization;
    private PackedDate certificateEffectiveDate;
    private PackedDate certificateExpirationDate;
    private CertificateHolderReference certificateHolderReference;
    private CertificationAuthorityReference certificationAuthorityReference;

    public EACCertificateBuilder(CertificationAuthorityReference certificationAuthorityReference, PublicKeyDataObject publicKeyDataObject, CertificateHolderReference certificateHolderReference, CertificateHolderAuthorization certificateHolderAuthorization, PackedDate packedDate, PackedDate packedDate2) {
        this.certificationAuthorityReference = certificationAuthorityReference;
        this.publicKey = publicKeyDataObject;
        this.certificateHolderReference = certificateHolderReference;
        this.certificateHolderAuthorization = certificateHolderAuthorization;
        this.certificateEffectiveDate = packedDate;
        this.certificateExpirationDate = packedDate2;
    }

    private CertificateBody buildBody() {
        DERApplicationSpecific dERApplicationSpecific = new DERApplicationSpecific(41, ZeroArray);
        CertificateBody certificateBody = new CertificateBody(dERApplicationSpecific, this.certificationAuthorityReference, this.publicKey, this.certificateHolderReference, this.certificateHolderAuthorization, this.certificateEffectiveDate, this.certificateExpirationDate);
        return certificateBody;
    }

    public EACCertificateHolder build(EACSigner eACSigner) throws EACException {
        try {
            CertificateBody certificateBody = this.buildBody();
            OutputStream outputStream = eACSigner.getOutputStream();
            outputStream.write(certificateBody.getEncoded("DER"));
            outputStream.close();
            return new EACCertificateHolder(new CVCertificate(certificateBody, eACSigner.getSignature()));
        }
        catch (Exception exception) {
            throw new EACException("unable to process signature: " + exception.getMessage(), exception);
        }
    }
}

