/*
 * Decompiled with CFR 0.152.
 */
package esign.utils.http;

import esign.utils.configuration.Configuration;
import esign.utils.exception.Oauth2Exception;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Response {
    private static final boolean DEBUG = Configuration.getDebug();
    static Logger log = LoggerFactory.getLogger((String)Response.class.getName());
    private static ThreadLocal<DocumentBuilder> builders = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            try {
                return DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new ExceptionInInitializerError(parserConfigurationException);
            }
        }
    };
    private int statusCode;
    private Document responseAsDocument = null;
    private String responseAsString = null;
    private InputStream is;
    private HttpURLConnection con;
    private boolean streamConsumed = false;
    private static Pattern escaped = Pattern.compile("&#([0-9]{3,5});");

    public Response() {
    }

    public Response(HttpURLConnection con) throws IOException {
        this.con = con;
        this.statusCode = con.getResponseCode();
        this.is = con.getErrorStream();
        if (null == this.is) {
            this.is = con.getInputStream();
        }
        if (null != this.is && "gzip".equals(con.getContentEncoding())) {
            this.is = new GZIPInputStream(this.is);
        }
    }

    Response(String content) {
        this.responseAsString = content;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getResponseHeader(String name) {
        if (this.con != null) {
            return this.con.getHeaderField(name);
        }
        return null;
    }

    public InputStream asStream() {
        if (this.streamConsumed) {
            throw new IllegalStateException("Stream has already been consumed.");
        }
        return this.is;
    }

    public String asString() throws Oauth2Exception {
        if (null == this.responseAsString) {
            try {
                String string;
                InputStream inputStream = this.asStream();
                if (null == inputStream) {
                    return null;
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                StringBuffer stringBuffer = new StringBuffer();
                while (null != (string = bufferedReader.readLine())) {
                    stringBuffer.append(string).append("\n");
                }
                this.responseAsString = stringBuffer.toString();
                if (Configuration.isDalvik()) {
                    this.responseAsString = Response.unescape(this.responseAsString);
                }
                this.log(this.responseAsString);
                inputStream.close();
                this.con.disconnect();
                this.streamConsumed = true;
            }
            catch (NullPointerException nullPointerException) {
                throw new Oauth2Exception(nullPointerException.getMessage(), nullPointerException);
            }
            catch (IOException iOException) {
                throw new Oauth2Exception(iOException.getMessage(), iOException);
            }
        }
        return this.responseAsString;
    }

    public Document asDocument() throws Oauth2Exception {
        if (null == this.responseAsDocument) {
            try {
                this.responseAsDocument = builders.get().parse(new ByteArrayInputStream(this.asString().getBytes("UTF-8")));
            }
            catch (SAXException sAXException) {
                throw new Oauth2Exception("The response body was not well-formed:\n" + this.responseAsString, sAXException);
            }
            catch (IOException iOException) {
                throw new Oauth2Exception("There's something with the connection.", iOException);
            }
        }
        return this.responseAsDocument;
    }

    public JSONObject asJSONObject() throws Oauth2Exception {
        try {
            String string = this.asString();
            string = string.substring(string.indexOf("{"), string.lastIndexOf("}") + 1);
            return JSONObject.fromObject((Object)string);
        }
        catch (JSONException jSONException) {
            throw new Oauth2Exception(jSONException.getMessage() + ":" + this.responseAsString, (Exception)((Object)jSONException));
        }
    }

    public JSONArray asJSONArray() throws Oauth2Exception {
        try {
            return JSONArray.fromObject((Object)this.asString());
        }
        catch (Exception exception) {
            throw new Oauth2Exception(exception.getMessage() + ":" + this.responseAsString, exception);
        }
    }

    public InputStreamReader asReader() {
        try {
            return new InputStreamReader(this.is, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new InputStreamReader(this.is);
        }
    }

    public void disconnect() {
        this.con.disconnect();
    }

    public static String unescape(String original) {
        Matcher matcher = escaped.matcher(original);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, Character.toString((char)Integer.parseInt(matcher.group(1), 10)));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public String toString() {
        if (null != this.responseAsString) {
            return this.responseAsString;
        }
        return "Response{statusCode=" + this.statusCode + ", response=" + this.responseAsDocument + ", responseString='" + this.responseAsString + '\'' + ", is=" + this.is + ", con=" + this.con + '}';
    }

    private void log(String message) {
        if (DEBUG) {
            log.debug("[" + new Date() + "]" + message);
        }
    }

    public String getResponseAsString() {
        return this.responseAsString;
    }

    public void setResponseAsString(String responseAsString) {
        this.responseAsString = responseAsString;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }
}

