/*
 * Decompiled with CFR 0.152.
 */
package esign.utils.modeladapter.adapter;

import esign.utils.asserts.AssertSupport;
import esign.utils.exception.ErrorsDiscriptor;
import esign.utils.exception.SuperException;
import esign.utils.httpclient.HttpConfig;
import esign.utils.httpclient.ProjectAccesser;
import esign.utils.modeladapter.adapter.ModelsInitializerConfig;
import esign.utils.modeladapter.adapter.ModelsInitializing;
import esign.utils.modeladapter.adapter.model.ModelsSecurity;
import esign.utils.modeladapter.impl.rpc.bean.InterfaceUrlsOutput;

public class ModelsInitializerConfigBuilder {
    private ProjectAccesser projectAccesser;
    private String url;
    private HttpConfig httpConfig;
    private ModelsSecurity security = ModelsSecurity.HTTP;
    private long refreshInterval = 0x6DDD00L;
    private ModelsInitializing initializing = new ModelsInitializing(){

        @Override
        public void initializing(InterfaceUrlsOutput response) {
        }
    };
    private static final long MIN_REFRESH_INTERVAL = 600000L;
    private static final long DEFAULT_REFRESH_INTERVAL = 0x6DDD00L;
    private static final long MM_PER_MIN = 60000L;

    public ModelsInitializerConfigBuilder(ProjectAccesser projectAccesser, String url) {
        this(projectAccesser, url, null);
    }

    public ModelsInitializerConfigBuilder(ProjectAccesser projectAccesser, String url, HttpConfig httpConfig) {
        this.projectAccesser = projectAccesser;
        this.url = url;
        this.httpConfig = httpConfig;
    }

    public ModelsInitializerConfigBuilder setRefreshInterval(long refreshInterval) {
        this.refreshInterval = refreshInterval * 60000L;
        return this;
    }

    public ModelsInitializerConfigBuilder setSecurity(ModelsSecurity security) {
        this.security = security;
        return this;
    }

    public ModelsInitializerConfigBuilder setInitializing(ModelsInitializing initializing) {
        this.initializing = initializing;
        return this;
    }

    public ModelsInitializerConfig build() throws SuperException {
        this.check();
        return new ModelsInitializerConfig(){

            @Override
            public ProjectAccesser getProjectAccesser() {
                return ModelsInitializerConfigBuilder.this.projectAccesser;
            }

            @Override
            public long getRefreshInterval() {
                return ModelsInitializerConfigBuilder.this.refreshInterval;
            }

            @Override
            public String getUrl() {
                return ModelsInitializerConfigBuilder.this.url;
            }

            @Override
            public ModelsSecurity getSecurity() {
                return ModelsInitializerConfigBuilder.this.security;
            }

            @Override
            public ModelsInitializing getInitializing() {
                return ModelsInitializerConfigBuilder.this.initializing;
            }

            @Override
            public HttpConfig getUrlHttpConfig() {
                return null == ModelsInitializerConfigBuilder.this.httpConfig ? new HttpConfig() : ModelsInitializerConfigBuilder.this.httpConfig;
            }
        };
    }

    private void check() throws SuperException {
        AssertSupport.assertNotnull(this.projectAccesser, ErrorsDiscriptor.EmptyInputSpec.e("projectAccesser"));
        AssertSupport.assertNotnull(this.url, ErrorsDiscriptor.EmptyInputSpec.e("url"));
        AssertSupport.assertNotnull(this.security, ErrorsDiscriptor.EmptyInputSpec.e("security"));
        AssertSupport.assertNotnull(this.initializing, ErrorsDiscriptor.EmptyInputSpec.e("initializing"));
        AssertSupport.assertTrue(this.refreshInterval >= 600000L, ErrorsDiscriptor.InvalidParameterRange.e("refreshInterval"));
    }
}

