/*
 * Decompiled with CFR 0.152.
 */
package esign.utils.security.provider;

import esign.utils.security.model.DigestAlgorithmModel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public enum DigestProivder {
    MD5("MD5", DigestAlgorithmModel.MD5),
    SHA1("SHA-1", DigestAlgorithmModel.SHA1),
    SHA256("SHA-256", DigestAlgorithmModel.SHA256);

    private String disc;
    private DigestAlgorithmModel digestType;
    private static final Map<DigestAlgorithmModel, DigestProivder> models;

    private DigestProivder(String disc, DigestAlgorithmModel digestType) {
        this.disc = disc;
        this.digestType = digestType;
    }

    public static DigestProivder from(DigestAlgorithmModel model) {
        return models.get((Object)model);
    }

    public MessageDigest provider() {
        try {
            return MessageDigest.getInstance(this.disc);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            return null;
        }
    }

    static {
        models = new HashMap<DigestAlgorithmModel, DigestProivder>();
        for (DigestProivder digestProivder : DigestProivder.values()) {
            models.put(digestProivder.digestType, digestProivder);
        }
    }
}

