/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.collect;

import com.timevale.guava.common.annotations.GwtCompatible;
import com.timevale.guava.common.base.Preconditions;
import com.timevale.guava.common.base.Predicate;
import com.timevale.guava.common.base.Predicates;
import com.timevale.guava.common.base.Supplier;
import com.timevale.guava.common.collect.AbstractIterator;
import com.timevale.guava.common.collect.AbstractMapEntry;
import com.timevale.guava.common.collect.Collections2;
import com.timevale.guava.common.collect.ForwardingMapEntry;
import com.timevale.guava.common.collect.ImmutableEntry;
import com.timevale.guava.common.collect.Iterators;
import com.timevale.guava.common.collect.Lists;
import com.timevale.guava.common.collect.Maps;
import com.timevale.guava.common.collect.StandardTable;
import com.timevale.guava.common.collect.Table;
import com.timevale.guava.common.collect.Tables;
import com.timevale.guava.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

@GwtCompatible
class StandardTable<R, C, V>
implements Table<R, C, V>,
Serializable {
    final Map<R, Map<C, V>> backingMap;
    final Supplier<? extends Map<C, V>> factory;
    private transient CellSet cellSet;
    private transient RowKeySet rowKeySet;
    private transient Set<C> columnKeySet;
    private transient Values values;
    private transient RowMap rowMap;
    private transient ColumnMap columnMap;
    private static final long serialVersionUID = 0L;

    StandardTable(Map<R, Map<C, V>> backingMap, Supplier<? extends Map<C, V>> factory) {
        this.backingMap = backingMap;
        this.factory = factory;
    }

    @Override
    public boolean contains(@Nullable Object rowKey, @Nullable Object columnKey) {
        if (rowKey == null || columnKey == null) {
            return false;
        }
        Map<C, V> map = Maps.safeGet(this.backingMap, rowKey);
        return map != null && Maps.safeContainsKey(map, columnKey);
    }

    @Override
    public boolean containsColumn(@Nullable Object columnKey) {
        if (columnKey == null) {
            return false;
        }
        for (Map<C, V> map : this.backingMap.values()) {
            if (!Maps.safeContainsKey(map, columnKey)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsRow(@Nullable Object rowKey) {
        return rowKey != null && Maps.safeContainsKey(this.backingMap, rowKey);
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        if (value == null) {
            return false;
        }
        for (Map<C, V> map : this.backingMap.values()) {
            if (!map.containsValue(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(@Nullable Object rowKey, @Nullable Object columnKey) {
        if (rowKey == null || columnKey == null) {
            return null;
        }
        Map<C, V> map = Maps.safeGet(this.backingMap, rowKey);
        return map == null ? null : (V)Maps.safeGet(map, columnKey);
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public int size() {
        int n2 = 0;
        for (Map<C, V> map : this.backingMap.values()) {
            n2 += map.size();
        }
        return n2;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Table) {
            Table table = (Table)obj;
            return ((Object)this.cellSet()).equals(table.cellSet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Object)this.cellSet()).hashCode();
    }

    public String toString() {
        return this.rowMap().toString();
    }

    @Override
    public void clear() {
        this.backingMap.clear();
    }

    private Map<C, V> getOrCreate(R rowKey) {
        Map<C, V> map = this.backingMap.get(rowKey);
        if (map == null) {
            map = this.factory.get();
            this.backingMap.put(rowKey, map);
        }
        return map;
    }

    @Override
    public V put(R rowKey, C columnKey, V value) {
        Preconditions.checkNotNull(rowKey);
        Preconditions.checkNotNull(columnKey);
        Preconditions.checkNotNull(value);
        return this.getOrCreate(rowKey).put(columnKey, value);
    }

    @Override
    public void putAll(Table<? extends R, ? extends C, ? extends V> table) {
        for (Table.Cell<R, C, V> cell : table.cellSet()) {
            this.put(cell.getRowKey(), cell.getColumnKey(), cell.getValue());
        }
    }

    @Override
    public V remove(@Nullable Object rowKey, @Nullable Object columnKey) {
        if (rowKey == null || columnKey == null) {
            return null;
        }
        Map<C, V> map = Maps.safeGet(this.backingMap, rowKey);
        if (map == null) {
            return null;
        }
        V v2 = map.remove(columnKey);
        if (map.isEmpty()) {
            this.backingMap.remove(rowKey);
        }
        return v2;
    }

    private Map<R, V> removeColumn(Object column) {
        LinkedHashMap<R, V> linkedHashMap = new LinkedHashMap<R, V>();
        Iterator<Map.Entry<R, Map<C, V>>> iterator = this.backingMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<R, Map<C, V>> entry = iterator.next();
            V v2 = entry.getValue().remove(column);
            if (v2 == null) continue;
            linkedHashMap.put(entry.getKey(), v2);
            if (!entry.getValue().isEmpty()) continue;
            iterator.remove();
        }
        return linkedHashMap;
    }

    private boolean containsMapping(Object rowKey, Object columnKey, Object value) {
        return value != null && value.equals(this.get(rowKey, columnKey));
    }

    private boolean removeMapping(Object rowKey, Object columnKey, Object value) {
        if (this.containsMapping(rowKey, columnKey, value)) {
            this.remove(rowKey, columnKey);
            return true;
        }
        return false;
    }

    @Override
    public Set<Table.Cell<R, C, V>> cellSet() {
        CellSet cellSet = this.cellSet;
        return cellSet == null ? (this.cellSet = new CellSet()) : cellSet;
    }

    @Override
    public Map<C, V> row(R rowKey) {
        return new Row(rowKey);
    }

    @Override
    public Map<R, V> column(C columnKey) {
        return new Column(columnKey);
    }

    @Override
    public Set<R> rowKeySet() {
        RowKeySet rowKeySet = this.rowKeySet;
        return rowKeySet == null ? (this.rowKeySet = new RowKeySet()) : rowKeySet;
    }

    @Override
    public Set<C> columnKeySet() {
        ColumnKeySet columnKeySet = this.columnKeySet;
        return columnKeySet == null ? (this.columnKeySet = new ColumnKeySet()) : columnKeySet;
    }

    Iterator<C> createColumnKeyIterator() {
        return new ColumnKeyIterator();
    }

    @Override
    public Collection<V> values() {
        Values values = this.values;
        return values == null ? (this.values = new Values()) : values;
    }

    @Override
    public Map<R, Map<C, V>> rowMap() {
        RowMap rowMap = this.rowMap;
        return rowMap == null ? (this.rowMap = new RowMap()) : rowMap;
    }

    @Override
    public Map<C, Map<R, V>> columnMap() {
        ColumnMap columnMap = this.columnMap;
        return columnMap == null ? (this.columnMap = new ColumnMap()) : columnMap;
    }

    static <K, V> Iterator<K> keyIteratorImpl(Map<K, V> map) {
        final Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        return new Iterator<K>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public K next() {
                return ((Map.Entry)iterator.next()).getKey();
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    static <K, V> Iterator<V> valueIteratorImpl(Map<K, V> map) {
        final Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        return new Iterator<V>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public V next() {
                return ((Map.Entry)iterator.next()).getValue();
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    private class ColumnMap
    extends Maps.ImprovedAbstractMap<C, Map<R, V>> {
        com.timevale.guava.common.collect.StandardTable$ColumnMap.ColumnMapValues columnMapValues;

        private ColumnMap() {
        }

        @Override
        public Map<R, V> get(Object key) {
            return StandardTable.this.containsColumn(key) ? StandardTable.this.column(key) : null;
        }

        @Override
        public boolean containsKey(Object key) {
            return StandardTable.this.containsColumn(key);
        }

        @Override
        public Map<R, V> remove(Object key) {
            return StandardTable.this.containsColumn(key) ? StandardTable.this.removeColumn(key) : null;
        }

        @Override
        public Set<Map.Entry<C, Map<R, V>>> createEntrySet() {
            return new ColumnMapEntrySet();
        }

        @Override
        public Set<C> keySet() {
            return StandardTable.this.columnKeySet();
        }

        @Override
        public Collection<Map<R, V>> values() {
            com.timevale.guava.common.collect.StandardTable$ColumnMap.ColumnMapValues columnMapValues = this.columnMapValues;
            return columnMapValues == null ? (this.columnMapValues = new ColumnMapValues()) : columnMapValues;
        }

        private class ColumnMapValues
        extends TableCollection {
            private ColumnMapValues() {
            }

            @Override
            public Iterator<Map<R, V>> iterator() {
                return StandardTable.valueIteratorImpl(ColumnMap.this);
            }

            @Override
            public boolean remove(Object obj) {
                for (Map.Entry entry : ColumnMap.this.entrySet()) {
                    if (!((Object)((Map)entry.getValue())).equals(obj)) continue;
                    StandardTable.this.removeColumn(entry.getKey());
                    return true;
                }
                return false;
            }

            @Override
            public boolean removeAll(Collection<?> c2) {
                Preconditions.checkNotNull(c2);
                boolean bl2 = false;
                for (Object c3 : Lists.newArrayList(StandardTable.this.columnKeySet().iterator())) {
                    if (!c2.contains(StandardTable.this.column(c3))) continue;
                    StandardTable.this.removeColumn(c3);
                    bl2 = true;
                }
                return bl2;
            }

            @Override
            public boolean retainAll(Collection<?> c2) {
                Preconditions.checkNotNull(c2);
                boolean bl2 = false;
                for (Object c3 : Lists.newArrayList(StandardTable.this.columnKeySet().iterator())) {
                    if (c2.contains(StandardTable.this.column(c3))) continue;
                    StandardTable.this.removeColumn(c3);
                    bl2 = true;
                }
                return bl2;
            }

            @Override
            public int size() {
                return StandardTable.this.columnKeySet().size();
            }
        }

        class ColumnMapEntrySet
        extends TableSet {
            ColumnMapEntrySet() {
            }

            @Override
            public Iterator<Map.Entry<C, Map<R, V>>> iterator() {
                final Iterator iterator = StandardTable.this.columnKeySet().iterator();
                return new UnmodifiableIterator<Map.Entry<C, Map<R, V>>>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Map.Entry<C, Map<R, V>> next() {
                        Object e2 = iterator.next();
                        return new ImmutableEntry(e2, StandardTable.this.column(e2));
                    }
                };
            }

            @Override
            public int size() {
                return StandardTable.this.columnKeySet().size();
            }

            @Override
            public boolean contains(Object obj) {
                Map.Entry entry;
                if (obj instanceof Map.Entry && StandardTable.this.containsColumn((entry = (Map.Entry)obj).getKey())) {
                    Object k2 = entry.getKey();
                    return ColumnMap.this.get(k2).equals(entry.getValue());
                }
                return false;
            }

            @Override
            public boolean remove(Object obj) {
                if (this.contains(obj)) {
                    Map.Entry entry = (Map.Entry)obj;
                    StandardTable.this.removeColumn(entry.getKey());
                    return true;
                }
                return false;
            }

            @Override
            public boolean removeAll(Collection<?> c2) {
                boolean bl2 = false;
                for (Object obj : c2) {
                    bl2 |= this.remove(obj);
                }
                return bl2;
            }

            @Override
            public boolean retainAll(Collection<?> c2) {
                boolean bl2 = false;
                for (Object c3 : Lists.newArrayList(StandardTable.this.columnKeySet().iterator())) {
                    if (c2.contains(new ImmutableEntry(c3, StandardTable.this.column(c3)))) continue;
                    StandardTable.this.removeColumn(c3);
                    bl2 = true;
                }
                return bl2;
            }
        }
    }

    class RowMap
    extends Maps.ImprovedAbstractMap<R, Map<C, V>> {
        RowMap() {
        }

        @Override
        public boolean containsKey(Object key) {
            return StandardTable.this.containsRow(key);
        }

        @Override
        public Map<C, V> get(Object key) {
            return StandardTable.this.containsRow(key) ? StandardTable.this.row(key) : null;
        }

        @Override
        public Set<R> keySet() {
            return StandardTable.this.rowKeySet();
        }

        @Override
        public Map<C, V> remove(Object key) {
            return key == null ? null : StandardTable.this.backingMap.remove(key);
        }

        @Override
        protected Set<Map.Entry<R, Map<C, V>>> createEntrySet() {
            return new EntrySet();
        }

        class EntryIterator
        implements Iterator<Map.Entry<R, Map<C, V>>> {
            final Iterator<R> delegate;

            EntryIterator() {
                this.delegate = StandardTable.this.backingMap.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public Map.Entry<R, Map<C, V>> next() {
                Object r2 = this.delegate.next();
                return new ImmutableEntry(r2, StandardTable.this.row(r2));
            }

            @Override
            public void remove() {
                this.delegate.remove();
            }
        }

        class EntrySet
        extends TableSet {
            EntrySet() {
            }

            @Override
            public Iterator<Map.Entry<R, Map<C, V>>> iterator() {
                return new EntryIterator();
            }

            @Override
            public int size() {
                return StandardTable.this.backingMap.size();
            }

            @Override
            public boolean contains(Object obj) {
                if (obj instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)obj;
                    return entry.getKey() != null && entry.getValue() instanceof Map && Collections2.safeContains(StandardTable.this.backingMap.entrySet(), entry);
                }
                return false;
            }

            @Override
            public boolean remove(Object obj) {
                if (obj instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)obj;
                    return entry.getKey() != null && entry.getValue() instanceof Map && StandardTable.this.backingMap.entrySet().remove(entry);
                }
                return false;
            }
        }
    }

    private class Values
    extends TableCollection {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            final Iterator iterator = StandardTable.this.cellSet().iterator();
            return new Iterator<V>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public V next() {
                    return ((Table.Cell)iterator.next()).getValue();
                }

                @Override
                public void remove() {
                    iterator.remove();
                }
            };
        }

        @Override
        public int size() {
            return StandardTable.this.size();
        }
    }

    private class ColumnKeyIterator
    extends AbstractIterator<C> {
        final Map<C, V> seen;
        final Iterator<Map<C, V>> mapIterator;
        Iterator<Map.Entry<C, V>> entryIterator;

        private ColumnKeyIterator() {
            this.seen = StandardTable.this.factory.get();
            this.mapIterator = StandardTable.this.backingMap.values().iterator();
            this.entryIterator = Iterators.emptyIterator();
        }

        @Override
        protected C computeNext() {
            while (true) {
                if (this.entryIterator.hasNext()) {
                    Map.Entry entry = this.entryIterator.next();
                    if (this.seen.containsKey(entry.getKey())) continue;
                    this.seen.put(entry.getKey(), entry.getValue());
                    return entry.getKey();
                }
                if (!this.mapIterator.hasNext()) break;
                this.entryIterator = this.mapIterator.next().entrySet().iterator();
            }
            return this.endOfData();
        }
    }

    private class ColumnKeySet
    extends TableSet {
        private ColumnKeySet() {
        }

        @Override
        public Iterator<C> iterator() {
            return StandardTable.this.createColumnKeyIterator();
        }

        @Override
        public int size() {
            return Iterators.size(this.iterator());
        }

        @Override
        public boolean remove(Object obj) {
            if (obj == null) {
                return false;
            }
            boolean bl2 = false;
            Iterator iterator = StandardTable.this.backingMap.values().iterator();
            while (iterator.hasNext()) {
                Map map = iterator.next();
                if (!map.keySet().remove(obj)) continue;
                bl2 = true;
                if (!map.isEmpty()) continue;
                iterator.remove();
            }
            return bl2;
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            Preconditions.checkNotNull(c2);
            boolean bl2 = false;
            Iterator iterator = StandardTable.this.backingMap.values().iterator();
            while (iterator.hasNext()) {
                Map map = iterator.next();
                if (!Iterators.removeAll(map.keySet().iterator(), c2)) continue;
                bl2 = true;
                if (!map.isEmpty()) continue;
                iterator.remove();
            }
            return bl2;
        }

        @Override
        public boolean retainAll(Collection<?> c2) {
            Preconditions.checkNotNull(c2);
            boolean bl2 = false;
            Iterator iterator = StandardTable.this.backingMap.values().iterator();
            while (iterator.hasNext()) {
                Map map = iterator.next();
                if (!map.keySet().retainAll(c2)) continue;
                bl2 = true;
                if (!map.isEmpty()) continue;
                iterator.remove();
            }
            return bl2;
        }

        @Override
        public boolean contains(Object obj) {
            if (obj == null) {
                return false;
            }
            for (Map map : StandardTable.this.backingMap.values()) {
                if (!map.containsKey(obj)) continue;
                return true;
            }
            return false;
        }
    }

    class RowKeySet
    extends TableSet {
        RowKeySet() {
        }

        @Override
        public Iterator<R> iterator() {
            return StandardTable.keyIteratorImpl(StandardTable.this.rowMap());
        }

        @Override
        public int size() {
            return StandardTable.this.backingMap.size();
        }

        @Override
        public boolean contains(Object obj) {
            return StandardTable.this.containsRow(obj);
        }

        @Override
        public boolean remove(Object obj) {
            return obj != null && StandardTable.this.backingMap.remove(obj) != null;
        }
    }

    private class Column
    extends Maps.ImprovedAbstractMap<R, V> {
        final C columnKey;
        com.timevale.guava.common.collect.StandardTable$Column.Values columnValues;
        com.timevale.guava.common.collect.StandardTable$Column.KeySet keySet;

        Column(C columnKey) {
            this.columnKey = Preconditions.checkNotNull(columnKey);
        }

        @Override
        public V put(R key, V value) {
            return StandardTable.this.put(key, this.columnKey, value);
        }

        @Override
        public V get(Object key) {
            return StandardTable.this.get(key, this.columnKey);
        }

        @Override
        public boolean containsKey(Object key) {
            return StandardTable.this.contains(key, this.columnKey);
        }

        @Override
        public V remove(Object key) {
            return StandardTable.this.remove(key, this.columnKey);
        }

        @Override
        public Set<Map.Entry<R, V>> createEntrySet() {
            return new EntrySet();
        }

        @Override
        public Collection<V> values() {
            com.timevale.guava.common.collect.StandardTable$Column.Values values = this.columnValues;
            return values == null ? (this.columnValues = new Values()) : values;
        }

        boolean removePredicate(Predicate<? super Map.Entry<R, V>> predicate) {
            boolean bl2 = false;
            Iterator iterator = StandardTable.this.backingMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Map map = entry.getValue();
                Object v2 = map.get(this.columnKey);
                if (v2 == null || !predicate.apply(new ImmutableEntry(entry.getKey(), v2))) continue;
                map.remove(this.columnKey);
                bl2 = true;
                if (!map.isEmpty()) continue;
                iterator.remove();
            }
            return bl2;
        }

        @Override
        public Set<R> keySet() {
            com.timevale.guava.common.collect.StandardTable$Column.KeySet keySet = this.keySet;
            return keySet == null ? (this.keySet = new KeySet()) : keySet;
        }

        class Values
        extends AbstractCollection<V> {
            Values() {
            }

            @Override
            public Iterator<V> iterator() {
                return StandardTable.valueIteratorImpl(Column.this);
            }

            @Override
            public int size() {
                return Column.this.entrySet().size();
            }

            @Override
            public boolean isEmpty() {
                return !StandardTable.this.containsColumn(Column.this.columnKey);
            }

            @Override
            public void clear() {
                Column.this.entrySet().clear();
            }

            @Override
            public boolean remove(Object obj) {
                if (obj == null) {
                    return false;
                }
                Iterator iterator = StandardTable.this.backingMap.values().iterator();
                while (iterator.hasNext()) {
                    Map map = iterator.next();
                    if (!map.entrySet().remove(new ImmutableEntry(Column.this.columnKey, obj))) continue;
                    if (map.isEmpty()) {
                        iterator.remove();
                    }
                    return true;
                }
                return false;
            }

            @Override
            public boolean removeAll(final Collection<?> c2) {
                Preconditions.checkNotNull(c2);
                Predicate predicate = new Predicate<Map.Entry<R, V>>(){

                    @Override
                    public boolean apply(Map.Entry<R, V> entry) {
                        return c2.contains(entry.getValue());
                    }
                };
                return Column.this.removePredicate(predicate);
            }

            @Override
            public boolean retainAll(final Collection<?> c2) {
                Preconditions.checkNotNull(c2);
                Predicate predicate = new Predicate<Map.Entry<R, V>>(){

                    @Override
                    public boolean apply(Map.Entry<R, V> entry) {
                        return !c2.contains(entry.getValue());
                    }
                };
                return Column.this.removePredicate(predicate);
            }
        }

        class KeySet
        extends AbstractSet<R> {
            KeySet() {
            }

            @Override
            public Iterator<R> iterator() {
                return StandardTable.keyIteratorImpl(Column.this);
            }

            @Override
            public int size() {
                return Column.this.entrySet().size();
            }

            @Override
            public boolean isEmpty() {
                return !StandardTable.this.containsColumn(Column.this.columnKey);
            }

            @Override
            public boolean contains(Object obj) {
                return StandardTable.this.contains(obj, Column.this.columnKey);
            }

            @Override
            public boolean remove(Object obj) {
                return StandardTable.this.remove(obj, Column.this.columnKey) != null;
            }

            @Override
            public void clear() {
                Column.this.entrySet().clear();
            }

            @Override
            public boolean removeAll(Collection<?> c2) {
                boolean bl2 = false;
                for (Object obj : c2) {
                    bl2 |= this.remove(obj);
                }
                return bl2;
            }

            @Override
            public boolean retainAll(final Collection<?> c2) {
                Preconditions.checkNotNull(c2);
                Predicate predicate = new Predicate<Map.Entry<R, V>>(){

                    @Override
                    public boolean apply(Map.Entry<R, V> entry) {
                        return !c2.contains(entry.getKey());
                    }
                };
                return Column.this.removePredicate(predicate);
            }
        }

        class EntrySetIterator
        extends AbstractIterator<Map.Entry<R, V>> {
            final Iterator<Map.Entry<R, Map<C, V>>> iterator;

            EntrySetIterator() {
                this.iterator = StandardTable.this.backingMap.entrySet().iterator();
            }

            @Override
            protected Map.Entry<R, V> computeNext() {
                while (this.iterator.hasNext()) {
                    final Map.Entry entry = this.iterator.next();
                    if (!entry.getValue().containsKey(Column.this.columnKey)) continue;
                    return new AbstractMapEntry<R, V>(){

                        @Override
                        public R getKey() {
                            return entry.getKey();
                        }

                        @Override
                        public V getValue() {
                            return ((Map)entry.getValue()).get(Column.this.columnKey);
                        }

                        @Override
                        public V setValue(V value) {
                            return ((Map)entry.getValue()).put(Column.this.columnKey, Preconditions.checkNotNull(value));
                        }
                    };
                }
                return (Map.Entry)this.endOfData();
            }
        }

        class EntrySet
        extends AbstractSet<Map.Entry<R, V>> {
            EntrySet() {
            }

            @Override
            public Iterator<Map.Entry<R, V>> iterator() {
                return new EntrySetIterator();
            }

            @Override
            public int size() {
                int n2 = 0;
                for (Map map : StandardTable.this.backingMap.values()) {
                    if (!map.containsKey(Column.this.columnKey)) continue;
                    ++n2;
                }
                return n2;
            }

            @Override
            public boolean isEmpty() {
                return !StandardTable.this.containsColumn(Column.this.columnKey);
            }

            @Override
            public void clear() {
                Predicate predicate = Predicates.alwaysTrue();
                Column.this.removePredicate(predicate);
            }

            @Override
            public boolean contains(Object o2) {
                if (o2 instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)o2;
                    return StandardTable.this.containsMapping(entry.getKey(), Column.this.columnKey, entry.getValue());
                }
                return false;
            }

            @Override
            public boolean remove(Object obj) {
                if (obj instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)obj;
                    return StandardTable.this.removeMapping(entry.getKey(), Column.this.columnKey, entry.getValue());
                }
                return false;
            }

            @Override
            public boolean removeAll(Collection<?> c2) {
                boolean bl2 = false;
                for (Object obj : c2) {
                    bl2 |= this.remove(obj);
                }
                return bl2;
            }

            @Override
            public boolean retainAll(Collection<?> c2) {
                return Column.this.removePredicate(Predicates.not(Predicates.in(c2)));
            }
        }
    }

    class Row
    extends AbstractMap<C, V> {
        final R rowKey;
        Map<C, V> backingRowMap;
        Set<C> keySet;
        Set<Map.Entry<C, V>> entrySet;

        Row(R rowKey) {
            this.rowKey = Preconditions.checkNotNull(rowKey);
        }

        Map<C, V> backingRowMap() {
            Map map;
            if (this.backingRowMap == null || this.backingRowMap.isEmpty() && StandardTable.this.backingMap.containsKey(this.rowKey)) {
                this.backingRowMap = this.computeBackingRowMap();
                map = this.backingRowMap;
            } else {
                map = this.backingRowMap;
            }
            return map;
        }

        Map<C, V> computeBackingRowMap() {
            return StandardTable.this.backingMap.get(this.rowKey);
        }

        void maintainEmptyInvariant() {
            if (this.backingRowMap() != null && this.backingRowMap.isEmpty()) {
                StandardTable.this.backingMap.remove(this.rowKey);
                this.backingRowMap = null;
            }
        }

        @Override
        public boolean containsKey(Object key) {
            Map map = this.backingRowMap();
            return key != null && map != null && Maps.safeContainsKey(map, key);
        }

        @Override
        public V get(Object key) {
            Map map = this.backingRowMap();
            return key != null && map != null ? (Object)Maps.safeGet(map, key) : null;
        }

        @Override
        public V put(C key, V value) {
            Preconditions.checkNotNull(key);
            Preconditions.checkNotNull(value);
            if (this.backingRowMap != null && !this.backingRowMap.isEmpty()) {
                return this.backingRowMap.put(key, value);
            }
            return StandardTable.this.put(this.rowKey, key, value);
        }

        @Override
        public V remove(Object key) {
            try {
                Map map = this.backingRowMap();
                if (map == null) {
                    return null;
                }
                Object v2 = map.remove(key);
                this.maintainEmptyInvariant();
                return v2;
            }
            catch (ClassCastException classCastException) {
                return null;
            }
        }

        @Override
        public void clear() {
            Map map = this.backingRowMap();
            if (map != null) {
                map.clear();
            }
            this.maintainEmptyInvariant();
        }

        @Override
        public Set<C> keySet() {
            Set set = this.keySet;
            if (set == null) {
                this.keySet = new Maps.KeySet<C, V>(){

                    @Override
                    Map<C, V> map() {
                        return Row.this;
                    }
                };
                return this.keySet;
            }
            return set;
        }

        @Override
        public Set<Map.Entry<C, V>> entrySet() {
            Set set = this.entrySet;
            if (set == null) {
                this.entrySet = new RowEntrySet();
                return this.entrySet;
            }
            return set;
        }

        private class RowEntrySet
        extends Maps.EntrySet<C, V> {
            private RowEntrySet() {
            }

            @Override
            Map<C, V> map() {
                return Row.this;
            }

            @Override
            public int size() {
                Map map = Row.this.backingRowMap();
                return map == null ? 0 : map.size();
            }

            @Override
            public Iterator<Map.Entry<C, V>> iterator() {
                Map map = Row.this.backingRowMap();
                if (map == null) {
                    return Iterators.emptyModifiableIterator();
                }
                final Iterator iterator = map.entrySet().iterator();
                return new Iterator<Map.Entry<C, V>>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Map.Entry<C, V> next() {
                        final Map.Entry entry = (Map.Entry)iterator.next();
                        return new ForwardingMapEntry<C, V>(){

                            @Override
                            protected Map.Entry<C, V> delegate() {
                                return entry;
                            }

                            @Override
                            public V setValue(V value) {
                                return super.setValue(Preconditions.checkNotNull(value));
                            }

                            @Override
                            public boolean equals(Object object) {
                                return this.standardEquals(object);
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                        Row.this.maintainEmptyInvariant();
                    }
                };
            }
        }
    }

    private class CellIterator
    implements Iterator<Table.Cell<R, C, V>> {
        final Iterator<Map.Entry<R, Map<C, V>>> rowIterator;
        Map.Entry<R, Map<C, V>> rowEntry;
        Iterator<Map.Entry<C, V>> columnIterator;

        private CellIterator() {
            this.rowIterator = StandardTable.this.backingMap.entrySet().iterator();
            this.columnIterator = Iterators.emptyModifiableIterator();
        }

        @Override
        public boolean hasNext() {
            return this.rowIterator.hasNext() || this.columnIterator.hasNext();
        }

        @Override
        public Table.Cell<R, C, V> next() {
            if (!this.columnIterator.hasNext()) {
                this.rowEntry = this.rowIterator.next();
                this.columnIterator = this.rowEntry.getValue().entrySet().iterator();
            }
            Map.Entry entry = this.columnIterator.next();
            return Tables.immutableCell(this.rowEntry.getKey(), entry.getKey(), entry.getValue());
        }

        @Override
        public void remove() {
            this.columnIterator.remove();
            if (this.rowEntry.getValue().isEmpty()) {
                this.rowIterator.remove();
            }
        }
    }

    private class CellSet
    extends TableSet {
        private CellSet() {
        }

        @Override
        public Iterator<Table.Cell<R, C, V>> iterator() {
            return new CellIterator();
        }

        @Override
        public int size() {
            return StandardTable.this.size();
        }

        @Override
        public boolean contains(Object obj) {
            if (obj instanceof Table.Cell) {
                Table.Cell cell = (Table.Cell)obj;
                return StandardTable.this.containsMapping(cell.getRowKey(), cell.getColumnKey(), cell.getValue());
            }
            return false;
        }

        @Override
        public boolean remove(Object obj) {
            if (obj instanceof Table.Cell) {
                Table.Cell cell = (Table.Cell)obj;
                return StandardTable.this.removeMapping(cell.getRowKey(), cell.getColumnKey(), cell.getValue());
            }
            return false;
        }
    }

    private abstract class TableSet<T>
    extends AbstractSet<T> {
        private TableSet() {
        }

        @Override
        public boolean isEmpty() {
            return StandardTable.this.backingMap.isEmpty();
        }

        @Override
        public void clear() {
            StandardTable.this.backingMap.clear();
        }
    }

    private abstract class TableCollection<T>
    extends AbstractCollection<T> {
        private TableCollection() {
        }

        @Override
        public boolean isEmpty() {
            return StandardTable.this.backingMap.isEmpty();
        }

        @Override
        public void clear() {
            StandardTable.this.backingMap.clear();
        }
    }
}

