/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.tls;

import com.timevale.tgtext.bouncycastle.crypto.tls.AbstractTlsClient;
import com.timevale.tgtext.bouncycastle.crypto.tls.DefaultTlsCipherFactory;
import com.timevale.tgtext.bouncycastle.crypto.tls.DefaultTlsSRPGroupVerifier;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsAuthentication;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsCipherFactory;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsExtensionsUtils;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsFatalAlert;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsKeyExchange;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsSRPGroupVerifier;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsSRPKeyExchange;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsSRPUtils;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsUtils;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import java.io.IOException;
import java.util.Hashtable;

public class SRPTlsClient
extends AbstractTlsClient {
    protected TlsSRPGroupVerifier groupVerifier;
    protected byte[] identity;
    protected byte[] password;

    public SRPTlsClient(byte[] byArray, byte[] byArray2) {
        this(new DefaultTlsCipherFactory(), new DefaultTlsSRPGroupVerifier(), byArray, byArray2);
    }

    public SRPTlsClient(TlsCipherFactory tlsCipherFactory, byte[] byArray, byte[] byArray2) {
        this(tlsCipherFactory, new DefaultTlsSRPGroupVerifier(), byArray, byArray2);
    }

    public SRPTlsClient(TlsCipherFactory tlsCipherFactory, TlsSRPGroupVerifier tlsSRPGroupVerifier, byte[] byArray, byte[] byArray2) {
        super(tlsCipherFactory);
        this.groupVerifier = tlsSRPGroupVerifier;
        this.identity = Arrays.clone(byArray);
        this.password = Arrays.clone(byArray2);
    }

    protected boolean requireSRPServerExtension() {
        return false;
    }

    @Override
    public int[] getCipherSuites() {
        return new int[]{49182};
    }

    @Override
    public Hashtable getClientExtensions() throws IOException {
        Hashtable hashtable = TlsExtensionsUtils.ensureExtensionsInitialised(super.getClientExtensions());
        TlsSRPUtils.addSRPExtension(hashtable, this.identity);
        return hashtable;
    }

    @Override
    public void processServerExtensions(Hashtable hashtable) throws IOException {
        if (!TlsUtils.hasExpectedEmptyExtensionData(hashtable, TlsSRPUtils.EXT_SRP, (short)47) && this.requireSRPServerExtension()) {
            throw new TlsFatalAlert(47);
        }
        super.processServerExtensions(hashtable);
    }

    @Override
    public TlsKeyExchange getKeyExchange() throws IOException {
        int n2 = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (n2) {
            case 21: 
            case 22: 
            case 23: {
                return this.createSRPKeyExchange(n2);
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsAuthentication getAuthentication() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createSRPKeyExchange(int n2) {
        return new TlsSRPKeyExchange(n2, this.supportedSignatureAlgorithms, this.groupVerifier, this.identity, this.password);
    }
}

