/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.seal.sdk.request.generator.impl;

import com.timevale.seal.sdk.drawer.request.InnerRequest;
import com.timevale.seal.sdk.drawer.request.ellipse.CenterTextInfo;
import com.timevale.seal.sdk.drawer.request.ellipse.EllipseInnerRequest;
import com.timevale.seal.sdk.drawer.request.ellipse.HkEllipseInnerRequest;
import com.timevale.seal.sdk.drawer.request.ellipse.SerialTextInfo;
import com.timevale.seal.sdk.drawer.request.ellipse.SurroundTextInfo;
import com.timevale.seal.sdk.enums.CenterTypeEnum;
import com.timevale.seal.sdk.enums.DrawRuleTypeEnum;
import com.timevale.seal.sdk.enums.UnitEnum;
import com.timevale.seal.sdk.exception.SealSdkException;
import com.timevale.seal.sdk.request.EllipseSealRequest;
import com.timevale.seal.sdk.request.HkSealRequest;
import com.timevale.seal.sdk.request.SealBaseRequest;
import com.timevale.seal.sdk.request.generator.impl.DoubleEllipseImageRequestGenerator;
import com.timevale.seal.sdk.util.PixelUtil;
import com.timevale.seal.sdk.util.StringUtils;

public class HkEllipseRequestGenerator
extends DoubleEllipseImageRequestGenerator {
    private static final int[] DEFAULT_CENTER_COLS = new int[]{2, 6, 4};

    @Override
    protected InnerRequest getImageRequest() {
        return new HkEllipseInnerRequest();
    }

    @Override
    protected <T extends SealBaseRequest> void validateRequest(T t2) {
        super.validateRequest(t2);
        HkSealRequest hkSealRequest = (HkSealRequest)t2;
        if (hkSealRequest.getDoubleInnerHeight() <= 0) {
            throw new SealSdkException("\u53cc\u8fb9\u5185\u8fb9\u6846\u7684\u9ad8\u5ea6\u5c0f\u4e8e\u7b49\u4e8e0");
        }
        if (hkSealRequest.getDoubleInnerWidth() <= 0) {
            throw new SealSdkException("\u53cc\u8fb9\u5185\u8fb9\u6846\u7684\u5bbd\u5ea6\u5c0f\u4e8e\u7b49\u4e8e0");
        }
        if (hkSealRequest.getDoubleInnerBorderWidth() <= 0.0f) {
            throw new SealSdkException("\u53cc\u8fb9\u5185\u8fb9\u6846\u7684\u8fb9\u6846\u5bbd\u5ea6\u5c0f\u4e8e\u7b49\u4e8e0");
        }
        if (hkSealRequest.getInnerWidth() != hkSealRequest.getInnerHeight()) {
            throw new SealSdkException("\u5185\u9662\u7684\u5bbd\u5ea6\u5fc5\u987b\u7b49\u4e8e\u9ad8\u5ea6");
        }
        this.validateCenterInfo(hkSealRequest.getCenterContent(), hkSealRequest.getCenterTextCols());
    }

    private void validateCenterInfo(String centerContent, Integer[] centerTextCols) {
        if (StringUtils.isBlank(centerContent) || centerTextCols == null) {
            return;
        }
        int n2 = centerContent.length();
        int n3 = 0;
        for (Integer n4 : centerTextCols) {
            n3 += n4.intValue();
        }
        if (n3 > n2) {
            throw new SealSdkException("centerTextCols \u7684\u957f\u5ea6\u548c \u5927\u4e8e\u4e86 \u6587\u5b57\u957f\u5ea6");
        }
    }

    @Override
    protected <T extends SealBaseRequest, R extends InnerRequest> void convertDetail(T t2, R r2) {
        super.convertDetail(t2, r2);
        HkSealRequest hkSealRequest = (HkSealRequest)t2;
        HkEllipseInnerRequest hkEllipseInnerRequest = (HkEllipseInnerRequest)r2;
        if (UnitEnum.MM.equals((Object)hkSealRequest.getUnit())) {
            hkEllipseInnerRequest.setDoubleInnerWidth(PixelUtil.transferMmToPixel(hkSealRequest.getDoubleInnerWidth().intValue(), hkSealRequest.getSealTypeEnum().getDpi()));
            hkEllipseInnerRequest.setDoubleInnerHeight(PixelUtil.transferMmToPixel(hkSealRequest.getDoubleInnerHeight().intValue(), hkSealRequest.getSealTypeEnum().getDpi()));
            hkEllipseInnerRequest.setDoubleInnerBorderWidth(PixelUtil.transferMmToPixel(hkSealRequest.getDoubleInnerBorderWidth(), hkSealRequest.getSealTypeEnum().getDpi()));
        } else {
            hkEllipseInnerRequest.setDoubleInnerWidth(hkSealRequest.getDoubleInnerWidth());
            hkEllipseInnerRequest.setDoubleInnerHeight(hkSealRequest.getDoubleInnerHeight());
            hkEllipseInnerRequest.setDoubleInnerBorderWidth((int)hkSealRequest.getDoubleInnerBorderWidth());
        }
    }

    @Override
    protected void buildHengTextInfo(EllipseSealRequest outRequest, EllipseInnerRequest innerRequest) {
    }

    @Override
    protected void customSerialTextInfo(SerialTextInfo serialTextInfo, EllipseInnerRequest innerRequest) {
    }

    @Override
    protected void buildCenterInfo(EllipseSealRequest outRequest, EllipseInnerRequest innerRequest) {
        HkSealRequest hkSealRequest = (HkSealRequest)outRequest;
        String string = outRequest.getCenterContent();
        if (StringUtils.isBlank(string)) {
            return;
        }
        CenterTextInfo centerTextInfo = new CenterTextInfo();
        centerTextInfo.setCenterTypeEnum(CenterTypeEnum.TEXT);
        centerTextInfo.setText(string);
        centerTextInfo.setFont(outRequest.getCenterContentFont());
        Integer[] integerArray = this.getCenterTextCols(string.length(), hkSealRequest.getCenterTextCols());
        centerTextInfo.setCenterTextCols(integerArray);
        innerRequest.setCenterTextInfo(centerTextInfo);
    }

    private Integer[] getCenterTextCols(int length, Integer[] centerTextCols) {
        if (centerTextCols != null) {
            return centerTextCols;
        }
        centerTextCols = new Integer[3];
        if (length <= DEFAULT_CENTER_COLS[0]) {
            centerTextCols[0] = length;
            centerTextCols[1] = 0;
            centerTextCols[2] = 0;
        } else if (length <= DEFAULT_CENTER_COLS[0] + DEFAULT_CENTER_COLS[1]) {
            centerTextCols[0] = DEFAULT_CENTER_COLS[0];
            centerTextCols[1] = length - DEFAULT_CENTER_COLS[0];
            centerTextCols[2] = 0;
        } else if (length <= DEFAULT_CENTER_COLS[0] + DEFAULT_CENTER_COLS[1] + DEFAULT_CENTER_COLS[2]) {
            centerTextCols[0] = DEFAULT_CENTER_COLS[0];
            centerTextCols[1] = DEFAULT_CENTER_COLS[1];
            centerTextCols[2] = length - DEFAULT_CENTER_COLS[0] - DEFAULT_CENTER_COLS[1];
        } else {
            centerTextCols[0] = DEFAULT_CENTER_COLS[0];
            centerTextCols[1] = DEFAULT_CENTER_COLS[1];
            centerTextCols[2] = DEFAULT_CENTER_COLS[2];
            int n2 = 0;
            for (int i2 = length - DEFAULT_CENTER_COLS[0] - DEFAULT_CENTER_COLS[1] - DEFAULT_CENTER_COLS[2]; i2 > 0; --i2) {
                Integer[] integerArray = centerTextCols;
                int n3 = n2++;
                Integer.valueOf(integerArray[n3] + 1);
                if (n2 <= 2) continue;
                n2 = 0;
            }
        }
        return centerTextCols;
    }

    @Override
    protected void buildTopSurroundInfo(EllipseSealRequest outRequest, EllipseInnerRequest innerRequest) {
        super.buildTopSurroundInfo(outRequest, innerRequest);
        SurroundTextInfo surroundTextInfo = innerRequest.getTopSurroundTextInfo();
        if (null != surroundTextInfo) {
            surroundTextInfo.setArcAng(320);
            surroundTextInfo.setMinRat(0.3f);
        }
    }

    @Override
    protected int getTopSurroundFontSize(int width, int height, int length, DrawRuleTypeEnum drawRuleTypeEnum) {
        return 48;
    }
}

