/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.paddings;

import com.timevale.tgtext.bouncycastle.crypto.InvalidCipherTextException;
import com.timevale.tgtext.bouncycastle.crypto.paddings.BlockCipherPadding;
import java.security.SecureRandom;

public class ISO10126d2Padding
implements BlockCipherPadding {
    SecureRandom random;

    @Override
    public void init(SecureRandom secureRandom) throws IllegalArgumentException {
        this.random = secureRandom != null ? secureRandom : new SecureRandom();
    }

    @Override
    public String getPaddingName() {
        return "ISO10126-2";
    }

    @Override
    public int addPadding(byte[] byArray, int n2) {
        byte by2 = (byte)(byArray.length - n2);
        while (n2 < byArray.length - 1) {
            byArray[n2] = (byte)this.random.nextInt();
            ++n2;
        }
        byArray[n2] = by2;
        return by2;
    }

    @Override
    public int padCount(byte[] byArray) throws InvalidCipherTextException {
        int n2 = byArray[byArray.length - 1] & 0xFF;
        if (n2 > byArray.length) {
            throw new InvalidCipherTextException("pad block corrupted");
        }
        return n2;
    }
}

