/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.crypto.gmss;

import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.Digest;
import com.timevale.tgtext.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithRandom;
import com.timevale.tgtext.bouncycastle.pqc.crypto.StateAwareMessageSigner;
import com.timevale.tgtext.bouncycastle.pqc.crypto.gmss.GMSSDigestProvider;
import com.timevale.tgtext.bouncycastle.pqc.crypto.gmss.GMSSPrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.gmss.GMSSSigner;
import com.timevale.tgtext.bouncycastle.util.Memoable;

public class GMSSStateAwareSigner
implements StateAwareMessageSigner {
    private final GMSSSigner gmssSigner;
    private GMSSPrivateKeyParameters key;

    public GMSSStateAwareSigner(Digest digest) {
        if (!(digest instanceof Memoable)) {
            throw new IllegalArgumentException("digest must implement Memoable");
        }
        final Memoable memoable = ((Memoable)((Object)digest)).copy();
        this.gmssSigner = new GMSSSigner(new GMSSDigestProvider(){

            @Override
            public Digest get() {
                return (Digest)((Object)memoable.copy());
            }
        });
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        if (bl2) {
            if (cipherParameters instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                this.key = (GMSSPrivateKeyParameters)parametersWithRandom.getParameters();
            } else {
                this.key = (GMSSPrivateKeyParameters)cipherParameters;
            }
        }
        this.gmssSigner.init(bl2, cipherParameters);
    }

    @Override
    public byte[] generateSignature(byte[] byArray) {
        if (this.key == null) {
            throw new IllegalStateException("signing key no longer usable");
        }
        byte[] byArray2 = this.gmssSigner.generateSignature(byArray);
        this.key = this.key.nextKey();
        return byArray2;
    }

    @Override
    public boolean verifySignature(byte[] byArray, byte[] byArray2) {
        return this.gmssSigner.verifySignature(byArray, byArray2);
    }

    @Override
    public AsymmetricKeyParameter getUpdatedPrivateKey() {
        GMSSPrivateKeyParameters gMSSPrivateKeyParameters = this.key;
        this.key = null;
        return gMSSPrivateKeyParameters;
    }
}

