/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.text;

import com.timevale.tgtext.text.e;
import com.timevale.tgtext.text.l;
import com.timevale.tgtext.text.m;
import com.timevale.tgtext.text.pdf.p;

public class Font
implements Comparable<Font> {
    public static final int VU = 0;
    public static final int VV = 1;
    public static final int VW = 2;
    public static final int VX = 4;
    public static final int VY = 8;
    public static final int VZ = 3;
    public static final int Wa = -1;
    public static final int Wb = 12;
    private FontFamily Wc = FontFamily.UNDEFINED;
    private float Wd = -1.0f;
    private int We = -1;
    private e Nd = null;
    private p PO = null;

    public Font(Font other) {
        this.Wc = other.Wc;
        this.Wd = other.Wd;
        this.We = other.We;
        this.Nd = other.Nd;
        this.PO = other.PO;
    }

    public Font(FontFamily family, float size, int style, e color) {
        this.Wc = family;
        this.Wd = size;
        this.We = style;
        this.Nd = color;
    }

    public Font(p bf2, float size, int style, e color) {
        this.PO = bf2;
        this.Wd = size;
        this.We = style;
        this.Nd = color;
    }

    public Font(p bf2, float size, int style) {
        this(bf2, size, style, null);
    }

    public Font(p bf2, float size) {
        this(bf2, size, -1, null);
    }

    public Font(p bf2) {
        this(bf2, -1.0f, -1, null);
    }

    public Font(FontFamily family, float size, int style) {
        this(family, size, style, null);
    }

    public Font(FontFamily family, float size) {
        this(family, size, -1, null);
    }

    public Font(FontFamily family) {
        this(family, -1.0f, -1, null);
    }

    public Font() {
        this(FontFamily.UNDEFINED, -1.0f, -1, null);
    }

    public int c(Font font) {
        if (font == null) {
            return -1;
        }
        try {
            if (this.PO != null && !this.PO.equals(font.Be())) {
                return -2;
            }
            if (this.Wc != font.AU()) {
                return 1;
            }
            if (this.Wd != font.AW()) {
                return 2;
            }
            if (this.We != font.AY()) {
                return 3;
            }
            if (this.Nd == null) {
                if (font.Nd == null) {
                    return 0;
                }
                return 4;
            }
            if (font.Nd == null) {
                return 4;
            }
            if (this.Nd.equals(font.wR())) {
                return 0;
            }
            return 4;
        }
        catch (ClassCastException classCastException) {
            return -3;
        }
    }

    public FontFamily AU() {
        return this.Wc;
    }

    public String AV() {
        String string = "unknown";
        switch (this.AU()) {
            case COURIER: {
                return "Courier";
            }
            case HELVETICA: {
                return "Helvetica";
            }
            case TIMES_ROMAN: {
                return "Times-Roman";
            }
            case SYMBOL: {
                return "Symbol";
            }
            case ZAPFDINGBATS: {
                return "ZapfDingbats";
            }
        }
        if (this.PO != null) {
            String[][] stringArray;
            for (String[] stringArray2 : stringArray = this.PO.FM()) {
                if ("0".equals(stringArray2[2])) {
                    return stringArray2[3];
                }
                if ("1033".equals(stringArray2[2])) {
                    string = stringArray2[3];
                }
                if (!"".equals(stringArray2[2])) continue;
                string = stringArray2[3];
            }
        }
        return string;
    }

    public void eC(String string) {
        this.Wc = Font.eD(string);
    }

    public static FontFamily eD(String string) {
        if (string.equalsIgnoreCase("Courier")) {
            return FontFamily.COURIER;
        }
        if (string.equalsIgnoreCase("Helvetica")) {
            return FontFamily.HELVETICA;
        }
        if (string.equalsIgnoreCase("Times-Roman")) {
            return FontFamily.TIMES_ROMAN;
        }
        if (string.equalsIgnoreCase("Symbol")) {
            return FontFamily.SYMBOL;
        }
        if (string.equalsIgnoreCase("ZapfDingbats")) {
            return FontFamily.ZAPFDINGBATS;
        }
        return FontFamily.UNDEFINED;
    }

    public float AW() {
        return this.Wd;
    }

    public float AX() {
        float f2 = this.Wd;
        if (f2 == -1.0f) {
            f2 = 12.0f;
        }
        return f2;
    }

    public float F(float f2) {
        return f2 * this.AX();
    }

    public void G(float f2) {
        this.Wd = f2;
    }

    public int AY() {
        return this.We;
    }

    public int AZ() {
        int n2 = this.We;
        if (n2 == -1) {
            n2 = 0;
        }
        if (this.PO != null) {
            return n2;
        }
        if (this.Wc == FontFamily.SYMBOL || this.Wc == FontFamily.ZAPFDINGBATS) {
            return n2;
        }
        return n2 & 0xFFFFFFFC;
    }

    public boolean Ba() {
        if (this.We == -1) {
            return false;
        }
        return (this.We & 1) == 1;
    }

    public boolean Bb() {
        if (this.We == -1) {
            return false;
        }
        return (this.We & 2) == 2;
    }

    public boolean Bc() {
        if (this.We == -1) {
            return false;
        }
        return (this.We & 4) == 4;
    }

    public boolean Bd() {
        if (this.We == -1) {
            return false;
        }
        return (this.We & 8) == 8;
    }

    public void dz(int n2) {
        this.We = n2;
    }

    public void eE(String string) {
        if (this.We == -1) {
            this.We = 0;
        }
        this.We |= Font.eF(string);
    }

    public static int eF(String string) {
        int n2 = 0;
        if (string.indexOf(FontStyle.NORMAL.getValue()) != -1) {
            n2 |= 0;
        }
        if (string.indexOf(FontStyle.BOLD.getValue()) != -1) {
            n2 |= 1;
        }
        if (string.indexOf(FontStyle.ITALIC.getValue()) != -1) {
            n2 |= 2;
        }
        if (string.indexOf(FontStyle.OBLIQUE.getValue()) != -1) {
            n2 |= 2;
        }
        if (string.indexOf(FontStyle.UNDERLINE.getValue()) != -1) {
            n2 |= 4;
        }
        if (string.indexOf(FontStyle.LINETHROUGH.getValue()) != -1) {
            n2 |= 8;
        }
        return n2;
    }

    public e wR() {
        return this.Nd;
    }

    public void a(e e2) {
        this.Nd = e2;
    }

    public void z(int n2, int n3, int n4) {
        this.Nd = new e(n2, n3, n4);
    }

    public p Be() {
        return this.PO;
    }

    public p ad(boolean bl2) {
        if (this.PO != null) {
            return this.PO;
        }
        int n2 = this.We;
        if (n2 == -1) {
            n2 = 0;
        }
        String string = "Helvetica";
        String string2 = "Cp1252";
        p p2 = null;
        block1 : switch (this.Wc) {
            case COURIER: {
                switch (n2 & 3) {
                    case 1: {
                        string = "Courier-Bold";
                        break block1;
                    }
                    case 2: {
                        string = "Courier-Oblique";
                        break block1;
                    }
                    case 3: {
                        string = "Courier-BoldOblique";
                        break block1;
                    }
                }
                string = "Courier";
                break;
            }
            case TIMES_ROMAN: {
                switch (n2 & 3) {
                    case 1: {
                        string = "Times-Bold";
                        break block1;
                    }
                    case 2: {
                        string = "Times-Italic";
                        break block1;
                    }
                    case 3: {
                        string = "Times-BoldItalic";
                        break block1;
                    }
                }
                string = "Times-Roman";
                break;
            }
            case SYMBOL: {
                string = "Symbol";
                if (!bl2) break;
                string2 = "Symbol";
                break;
            }
            case ZAPFDINGBATS: {
                string = "ZapfDingbats";
                if (!bl2) break;
                string2 = "ZapfDingbats";
                break;
            }
            default: {
                switch (n2 & 3) {
                    case 1: {
                        string = "Helvetica-Bold";
                        break block1;
                    }
                    case 2: {
                        string = "Helvetica-Oblique";
                        break block1;
                    }
                    case 3: {
                        string = "Helvetica-BoldOblique";
                        break block1;
                    }
                }
                string = "Helvetica";
            }
        }
        try {
            p2 = p.c(string, string2, false);
        }
        catch (Exception exception) {
            throw new l(exception);
        }
        return p2;
    }

    public boolean Bf() {
        return this.Wc == FontFamily.UNDEFINED && this.Wd == -1.0f && this.We == -1 && this.Nd == null && this.PO == null;
    }

    public Font d(Font font) {
        e e2;
        if (font == null) {
            return this;
        }
        float f2 = font.Wd;
        if (f2 == -1.0f) {
            f2 = this.Wd;
        }
        int n2 = -1;
        int n3 = this.We;
        int n4 = font.AY();
        if (n3 != -1 || n4 != -1) {
            if (n3 == -1) {
                n3 = 0;
            }
            if (n4 == -1) {
                n4 = 0;
            }
            n2 = n3 | n4;
        }
        if ((e2 = font.Nd) == null) {
            e2 = this.Nd;
        }
        if (font.PO != null) {
            return new Font(font.PO, f2, n2, e2);
        }
        if (font.AU() != FontFamily.UNDEFINED) {
            return new Font(font.Wc, f2, n2, e2);
        }
        if (this.PO != null) {
            if (n2 == n3) {
                return new Font(this.PO, f2, n2, e2);
            }
            return m.a(this.AV(), f2, n2, e2);
        }
        return new Font(this.Wc, f2, n2, e2);
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.c((Font)object);
    }

    public static enum FontStyle {
        NORMAL("normal"),
        BOLD("bold"),
        ITALIC("italic"),
        OBLIQUE("oblique"),
        UNDERLINE("underline"),
        LINETHROUGH("line-through");

        private String code;

        private FontStyle(String code) {
            this.code = code;
        }

        public String getValue() {
            return this.code;
        }
    }

    public static enum FontFamily {
        COURIER,
        HELVETICA,
        TIMES_ROMAN,
        SYMBOL,
        ZAPFDINGBATS,
        UNDEFINED;

    }
}

