/*
 * Decompiled with CFR 0.152.
 */
package esign.utils.reflect;

import esign.utils.exception.ErrorsDiscriptor;
import esign.utils.exception.SuperException;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FieldUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldUtil.class);

    public static void helperFieldSet(Field f2, Object target, Object fv) throws SuperException {
        if (null == fv) {
            return;
        }
        boolean bl2 = f2.isAccessible();
        if (!bl2) {
            f2.setAccessible(true);
        }
        try {
            f2.set(target, fv);
        }
        catch (Exception exception) {
            LOGGER.error("can not inject the field. name:{}", (Object)f2.getName());
            LOGGER.error("exception:", (Throwable)exception);
            throw ErrorsDiscriptor.InternalService.e(exception);
        }
        f2.setAccessible(bl2);
    }

    public static Object helperFieldGet(Field f2, Object target) throws SuperException {
        Object object;
        boolean bl2 = f2.isAccessible();
        if (!bl2) {
            f2.setAccessible(true);
        }
        try {
            object = f2.get(target);
        }
        catch (Exception exception) {
            LOGGER.error("can not inject the field. name:{}", (Object)f2.getName());
            LOGGER.error("exception:", (Throwable)exception);
            throw ErrorsDiscriptor.InternalService.e(exception);
        }
        f2.setAccessible(bl2);
        return object;
    }
}

