/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.bean.request;

import com.timevale.esign.paas.tech.constant.ErrorException;
import com.timevale.esign.paas.tech.util.FileUtil;
import com.timevale.seal.sdk.util.StringUtils;
import esign.utils.exception.SuperException;

public class UploadAuthFileParam {
    private String authId;
    private String srcPdfFile;
    private byte[] streamFile;
    private String fileName;

    public String getAuthId() {
        return this.authId;
    }

    public void setAuthId(String authId) {
        this.authId = authId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getSrcPdfFile() {
        return this.srcPdfFile;
    }

    public void setSrcPdfFile(String srcPdfFile) {
        this.srcPdfFile = srcPdfFile;
    }

    public void check() throws SuperException {
        if (StringUtils.isBlank(this.authId)) {
            throw ErrorException.AUTH_ID_NULL_ERROR.e();
        }
        if (StringUtils.isBlank(this.srcPdfFile) && (this.streamFile == null || this.streamFile.length == 0)) {
            throw ErrorException.FILE_STREAM_ERROR.e();
        }
    }

    public byte[] getBytes() throws SuperException {
        if (this.streamFile == null || this.streamFile.length == 0) {
            try {
                this.streamFile = FileUtil.fileToByte(this.srcPdfFile);
            }
            catch (Exception exception) {
                throw ErrorException.FILE_READ_ERROR.e(this.srcPdfFile);
            }
        }
        return this.streamFile;
    }

    public byte[] getStreamFile() {
        return this.streamFile;
    }

    public void setStreamFile(byte[] streamFile) {
        this.streamFile = streamFile;
    }
}

