/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.common;

import com.timevale.esign.paas.tech.bean.bean.PosBean;
import com.timevale.esign.paas.tech.bean.bean.SignPDFDocBean;
import com.timevale.esign.paas.tech.common.checker.ParametersValidator;
import com.timevale.esign.paas.tech.enums.SignType;
import com.timevale.esign.paas.tech.util.CollectionUtil;
import esign.a.a.c;
import esign.utils.asserts.AssertSupport;
import esign.utils.exception.ErrorsDiscriptor;
import esign.utils.exception.SuperException;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Precondition {
    private static final Logger log = LoggerFactory.getLogger(Precondition.class);
    private static final Pattern REGEX_NUMBER = Pattern.compile("-?[0-9]+(\\.[0-9]+)?");

    public static void checkSignParam(SignPDFDocBean file) throws SuperException {
        AssertSupport.assertNotnull(file, ErrorsDiscriptor.MissingArgumentsSpec.e("file"));
        int n2 = ParametersValidator.validator(file);
        if (0 != n2) {
            throw ErrorsDiscriptor.direct(n2, c.ka(n2));
        }
    }

    public static void checkSignParam(SignType signType, List<PosBean> signPos) throws SuperException {
        AssertSupport.assertNotnull(signType, ErrorsDiscriptor.MissingArgumentsSpec.e("signType"));
        if (CollectionUtil.isEmpty(signPos)) {
            throw ErrorsDiscriptor.MissingArgumentsSpec.e("signPos");
        }
        for (PosBean posBean : signPos) {
            Precondition.checkPositionOfSignType(posBean, signType);
        }
    }

    public static void checkPositionOfSignType(PosBean signPos, SignType type) throws SuperException {
        boolean bl2;
        boolean bl3;
        int n2 = ParametersValidator.validator(signPos);
        if (0 != n2) {
            throw ErrorsDiscriptor.direct(n2, c.ka(n2));
        }
        boolean bl4 = false;
        boolean bl5 = bl3 = SignType.Multi.equals((Object)type) || SignType.Edges.equals((Object)type);
        if (bl4 && bl3) {
            throw ErrorsDiscriptor.QrCodeSignNotSupportSignType.e();
        }
        if (type.equals((Object)SignType.Single) && !(bl2 = REGEX_NUMBER.matcher(signPos.getPosPage()).matches())) {
            throw ErrorsDiscriptor.InvalidParameter.e();
        }
    }

    public static void checkIfTheSameSignKind(List<PosBean> signPos) throws SuperException {
        if (CollectionUtil.isEmpty(signPos)) {
            throw ErrorsDiscriptor.MissingArgumentsSpec.e("signPos");
        }
    }
}

