/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.enums;

import com.timevale.esign.paas.tech.bean.result.FileCreateFromTemplateResult;
import com.timevale.esign.paas.tech.client.AbstractServiceClient;
import com.timevale.esign.paas.tech.client.HiddenOperationDelegator;
import com.timevale.pdf.template.c;
import esign.utils.StringUtil;
import esign.utils.exception.ErrorsDiscriptor;
import esign.utils.exception.SuperException;
import esign.utils.httpclient.HttpConfig;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum PdfTemplateCreater {
    INSTANCE;

    private static final Logger LOGGER;

    public FileCreateFromTemplateResult createFromTemplate(AbstractServiceClient client, c creator, String dstFile, boolean isFlat) throws SuperException {
        try {
            creator.a(this.createProxy(client));
            creator.setDstDictionary(dstFile);
            File file = creator.create(isFlat);
            FileCreateFromTemplateResult fileCreateFromTemplateResult = new FileCreateFromTemplateResult();
            fileCreateFromTemplateResult.setDstPdfFile(file.getAbsolutePath());
            return fileCreateFromTemplateResult;
        }
        catch (IOException iOException) {
            LOGGER.error("create pdf from template exception.", (Throwable)iOException);
            throw ErrorsDiscriptor.Sign_AutoFillTextFieldFailed.e(iOException.getMessage());
        }
    }

    public FileCreateFromTemplateResult byteCreateFromTemplate(AbstractServiceClient client, c creator, boolean isFlat) throws SuperException {
        try {
            creator.a(this.createProxy(client));
            byte[] byArray = creator.byteCreate(isFlat);
            FileCreateFromTemplateResult fileCreateFromTemplateResult = new FileCreateFromTemplateResult();
            fileCreateFromTemplateResult.setStream(byArray);
            return fileCreateFromTemplateResult;
        }
        catch (IOException iOException) {
            LOGGER.error("create pdf from template exception.", (Throwable)iOException);
            throw ErrorsDiscriptor.Sign_AutoFillTextFieldFailed.e(iOException.getMessage());
        }
    }

    protected Proxy createProxy(AbstractServiceClient client) {
        HttpConfig httpConfig;
        String string;
        Proxy proxy = null;
        if (client != null && !StringUtil.isNull(string = (httpConfig = HiddenOperationDelegator.networkConfig(client)).getProxyIp())) {
            proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string, httpConfig.getProxyPort()));
        }
        return proxy;
    }

    static {
        LOGGER = LoggerFactory.getLogger(PdfTemplateCreater.class);
    }
}

