/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.primitives;

import com.timevale.guava.common.annotations.GwtCompatible;
import com.timevale.guava.common.base.Preconditions;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;

@GwtCompatible
public final class Booleans {
    private Booleans() {
    }

    public static int hashCode(boolean value) {
        return value ? 1231 : 1237;
    }

    public static int compare(boolean a2, boolean b2) {
        return a2 == b2 ? 0 : (a2 ? 1 : -1);
    }

    public static boolean contains(boolean[] array, boolean target) {
        for (boolean bl2 : array) {
            if (bl2 != target) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(boolean[] array, boolean target) {
        return Booleans.indexOf(array, target, 0, array.length);
    }

    private static int indexOf(boolean[] array, boolean target, int start, int end) {
        for (int i2 = start; i2 < end; ++i2) {
            if (array[i2] != target) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOf(boolean[] array, boolean[] target) {
        Preconditions.checkNotNull(array, "array");
        Preconditions.checkNotNull(target, "target");
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i2 = 0; i2 < array.length - target.length + 1; ++i2) {
            for (int i3 = 0; i3 < target.length; ++i3) {
                if (array[i2 + i3] != target[i3]) continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(boolean[] array, boolean target) {
        return Booleans.lastIndexOf(array, target, 0, array.length);
    }

    private static int lastIndexOf(boolean[] array, boolean target, int start, int end) {
        for (int i2 = end - 1; i2 >= start; --i2) {
            if (array[i2] != target) continue;
            return i2;
        }
        return -1;
    }

    public static boolean[] concat(boolean[] ... arrays) {
        int n2 = 0;
        for (boolean[] blArray : arrays) {
            n2 += blArray.length;
        }
        boolean[] blArray = new boolean[n2];
        int n3 = 0;
        for (boolean[] blArray2 : arrays) {
            System.arraycopy(blArray2, 0, blArray, n3, blArray2.length);
            n3 += blArray2.length;
        }
        return blArray;
    }

    public static boolean[] ensureCapacity(boolean[] array, int minLength, int padding) {
        Preconditions.checkArgument(minLength >= 0, "Invalid minLength: %s", minLength);
        Preconditions.checkArgument(padding >= 0, "Invalid padding: %s", padding);
        return array.length < minLength ? Booleans.copyOf(array, minLength + padding) : array;
    }

    private static boolean[] copyOf(boolean[] original, int length) {
        boolean[] blArray = new boolean[length];
        System.arraycopy(original, 0, blArray, 0, Math.min(original.length, length));
        return blArray;
    }

    public static String join(String separator, boolean ... array) {
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(array.length * 7);
        stringBuilder.append(array[0]);
        for (int i2 = 1; i2 < array.length; ++i2) {
            stringBuilder.append(separator).append(array[i2]);
        }
        return stringBuilder.toString();
    }

    public static Comparator<boolean[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static boolean[] toArray(Collection<Boolean> collection) {
        if (collection instanceof BooleanArrayAsList) {
            return ((BooleanArrayAsList)collection).toBooleanArray();
        }
        Object[] objectArray = collection.toArray();
        int n2 = objectArray.length;
        boolean[] blArray = new boolean[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            blArray[i2] = (Boolean)Preconditions.checkNotNull(objectArray[i2]);
        }
        return blArray;
    }

    public static List<Boolean> asList(boolean ... backingArray) {
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new BooleanArrayAsList(backingArray);
    }

    @GwtCompatible
    private static class BooleanArrayAsList
    extends AbstractList<Boolean>
    implements Serializable,
    RandomAccess {
        final boolean[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        BooleanArrayAsList(boolean[] array) {
            this(array, 0, array.length);
        }

        BooleanArrayAsList(boolean[] array, int start, int end) {
            this.array = array;
            this.start = start;
            this.end = end;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Boolean get(int index) {
            Preconditions.checkElementIndex(index, this.size());
            return this.array[this.start + index];
        }

        @Override
        public boolean contains(Object target) {
            return target instanceof Boolean && Booleans.indexOf(this.array, (Boolean)target, this.start, this.end) != -1;
        }

        @Override
        public int indexOf(Object target) {
            int n2;
            if (target instanceof Boolean && (n2 = Booleans.indexOf(this.array, (Boolean)target, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object target) {
            int n2;
            if (target instanceof Boolean && (n2 = Booleans.lastIndexOf(this.array, (Boolean)target, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public Boolean set(int index, Boolean element) {
            Preconditions.checkElementIndex(index, this.size());
            boolean bl2 = this.array[this.start + index];
            this.array[this.start + index] = Preconditions.checkNotNull(element);
            return bl2;
        }

        @Override
        public List<Boolean> subList(int fromIndex, int toIndex) {
            int n2 = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, n2);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new BooleanArrayAsList(this.array, this.start + fromIndex, this.start + toIndex);
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof BooleanArrayAsList) {
                BooleanArrayAsList booleanArrayAsList = (BooleanArrayAsList)object;
                int n2 = this.size();
                if (booleanArrayAsList.size() != n2) {
                    return false;
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this.array[this.start + i2] == booleanArrayAsList.array[booleanArrayAsList.start + i2]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int n2 = 1;
            for (int i2 = this.start; i2 < this.end; ++i2) {
                n2 = 31 * n2 + Booleans.hashCode(this.array[i2]);
            }
            return n2;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.size() * 7);
            stringBuilder.append(this.array[this.start] ? "[true" : "[false");
            for (int i2 = this.start + 1; i2 < this.end; ++i2) {
                stringBuilder.append(this.array[i2] ? ", true" : ", false");
            }
            return stringBuilder.append(']').toString();
        }

        boolean[] toBooleanArray() {
            int n2 = this.size();
            boolean[] blArray = new boolean[n2];
            System.arraycopy(this.array, this.start, blArray, 0, n2);
            return blArray;
        }
    }

    private static enum LexicographicalComparator implements Comparator<boolean[]>
    {
        INSTANCE;


        @Override
        public int compare(boolean[] left, boolean[] right) {
            int n2 = Math.min(left.length, right.length);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = Booleans.compare(left[i2], right[i2]);
                if (n3 == 0) continue;
                return n3;
            }
            return left.length - right.length;
        }
    }
}

