/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.seal.sdk.drawer.impl;

import com.timevale.seal.sdk.drawer.AbstractImageDrawer;
import com.timevale.seal.sdk.drawer.request.InnerRequest;
import com.timevale.seal.sdk.drawer.request.rect.RectImageInnerRequest;
import com.timevale.seal.sdk.enums.FontLayoutTypeEnum;
import com.timevale.seal.sdk.enums.FontPullTypeEnum;
import com.timevale.seal.sdk.exception.SealSdkException;
import com.timevale.seal.sdk.util.StringUtils;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RectImageDrawer
extends AbstractImageDrawer {
    private static final Logger log = LoggerFactory.getLogger(RectImageDrawer.class);

    @Override
    protected void customDrawBoundary(int boundaryStartPointX, int boundaryStartPointY, int boundaryWidth, int boundaryHeight, Graphics2D g2d) {
        g2d.drawRect(boundaryStartPointX, boundaryStartPointY, boundaryWidth, boundaryHeight);
    }

    @Override
    public <T extends InnerRequest> void customDraw(T obj, Graphics2D g2) {
        RectImageInnerRequest rectImageInnerRequest = (RectImageInnerRequest)obj;
        g2.setFont(rectImageInnerRequest.getFont());
        FontMetrics fontMetrics = g2.getFontMetrics();
        String string = rectImageInnerRequest.getText();
        char[] cArray = string.toCharArray();
        int n2 = this.getMaxWordWidth(cArray, fontMetrics);
        int n3 = this.getInnerLen(rectImageInnerRequest.getWidth(), rectImageInnerRequest.getBorderWidth());
        int n4 = this.getInnerLen(rectImageInnerRequest.getHeight(), rectImageInnerRequest.getBorderWidth());
        int n5 = 0;
        String string2 = rectImageInnerRequest.getBottomCode();
        if (StringUtils.isNotBlank(string2)) {
            n5 = (int)rectImageInnerRequest.getCodeHeight();
        }
        log.debug("innerWidth = {}, innerHeight = {}\uff0c borderWidth = {}", new Object[]{n3, n4 -= n5, rectImageInnerRequest.getBorderWidth()});
        if (rectImageInnerRequest.getLastFixWordCount() != 0) {
            this.drawContainFixCount(cArray, n2, n3, n4, rectImageInnerRequest, g2);
        } else {
            this.drawNormalRule(cArray, n2, n3, n4, rectImageInnerRequest, g2);
        }
        this.drawBottomCode(n3, rectImageInnerRequest, g2);
    }

    private void drawNormalRule(char[] chars, int maxWidthWord, int innerWidth, int innerHeight, RectImageInnerRequest request, Graphics2D g2) {
        int[] nArray = request.getGroupRowCol();
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = nArray[2];
        int n5 = nArray[3];
        log.debug("normalRow = {}, normalCol = {}, pullRow = {}, pullCol = {}", new Object[]{n2, n3, n4, n5});
        FontMetrics fontMetrics = g2.getFontMetrics();
        double d2 = n4 == 0 && n5 == 0 ? (double)innerWidth * (double)n3 / (double)(n5 + n3) / (double)(n3 * maxWidthWord) : (n5 == 1 ? (double)(innerWidth * n3 - maxWidthWord) / (double)(n5 + n3) / (double)(n3 * maxWidthWord) : (double)(innerWidth * n3) / (double)(n5 + n3) / (double)(n3 * maxWidthWord));
        double d3 = (double)innerHeight / (double)(n2 * fontMetrics.getHeight());
        log.debug("\u4e0d\u62c9\u4f38\u5b57\u4f53 scaleX = {}, scaleY = {}", (Object)d2, (Object)d3);
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d2, d3);
        Font font = g2.getFont().deriveFont(affineTransform);
        FontMetrics fontMetrics2 = g2.getFontMetrics(font);
        int n6 = this.getMaxWordWidth(chars, fontMetrics2);
        int n7 = this.getRowInterval(request.getText(), font, g2);
        int n8 = innerHeight / nArray[0];
        log.debug("\u4e0d\u62c9\u4f38\u5b57\u4f53\u57fa\u672c\u4fe1\u606f\uff1anormalFontMaxWidth = {}, normalRowInterval = {}, normalPartingLine = {}", new Object[]{n6, n7, n8});
        Font font2 = null;
        int n9 = 0;
        if (n4 != 0 && n5 != 0) {
            d2 = n5 == 1 ? (double)(innerWidth * n5 + maxWidthWord) / (double)(n5 + n3) / (double)(n5 * maxWidthWord) : (double)(innerWidth * n5 - maxWidthWord) / (double)(n5 + n3) / (double)(n5 * maxWidthWord);
            d3 = (double)innerHeight / (double)(n4 * (fontMetrics.getAscent() + fontMetrics.getDescent()));
            log.debug("\u4e0d\u62c9\u4f38\u5b57\u4f53 scaleX = {}, scaleY = {}", (Object)d2, (Object)d3);
            affineTransform = AffineTransform.getScaleInstance(d2, d3);
            font2 = g2.getFont().deriveFont(affineTransform);
            n9 = innerHeight / n4;
        }
        FontMetrics fontMetrics3 = null;
        int n10 = 0;
        if (font2 != null) {
            fontMetrics3 = g2.getFontMetrics(font2);
            n10 = this.getRowInterval(request.getText(), font2, g2);
        }
        int n11 = this.getMaxWordWidth(chars, fontMetrics3);
        log.debug("\u62c9\u4f38\u5b57\u4f53\u7684\u57fa\u672c\u4fe1\u606f\uff1apullFontMaxWidth = {}, pullRowInterval = {}, pullPartingLine = {}", new Object[]{n11, n10, n9});
        int n12 = (innerWidth - n6 * nArray[1] - n11 * nArray[3]) / (nArray[1] + nArray[3] + 1);
        if (n12 < 0) {
            n12 = 0;
        }
        log.debug("\u5217\u95f4\u9694 colInterval = {}", (Object)n12);
        if (FontLayoutTypeEnum.LEFT_RIGHT_UP_DOWN.equals((Object)request.getFontLayoutType())) {
            this.drawFromLeftToRightAndUpToDown(font, n6, n8, n7, font2, n11, n9, n10, n12, chars, nArray, request, g2);
        } else {
            this.drawFromRightToLeftAndUpToDown(font, n6, n8, n7, font2, n11, n9, n10, n12, chars, nArray, request, g2);
        }
    }

    private void drawContainFixCount(char[] chars, int maxWidthWord, int innerWidth, int innerHeight, RectImageInnerRequest request, Graphics2D g2) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Font font = null;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        Font font2 = null;
        int[] nArray = request.getGroupRowCol();
        int n10 = nArray[0];
        int n11 = nArray[1];
        int n12 = nArray[2];
        int n13 = nArray[3];
        int n14 = nArray[4];
        int n15 = nArray[5];
        log.debug("oneRow = {}, oneCol = {}, twoRow = {}, twoCol = {}, fixRow = {}, fixCol = {}", new Object[]{n10, n11, n12, n13, n14, n15});
        FontMetrics fontMetrics = g2.getFontMetrics();
        if (FontLayoutTypeEnum.LEFT_RIGHT_UP_DOWN.equals((Object)request.getFontLayoutType())) {
            FontMetrics fontMetrics2;
            int n16 = n10 + n12 + n14;
            double d2 = (double)innerHeight / (double)(n16 * fontMetrics.getHeight());
            double d3 = (double)innerWidth / (double)(n11 * maxWidthWord);
            AffineTransform affineTransform = AffineTransform.getScaleInstance(d3, d2);
            Font font3 = g2.getFont().deriveFont(affineTransform);
            if (n13 != 0) {
                d3 = (double)innerWidth / (double)(n13 * maxWidthWord);
                affineTransform = AffineTransform.getScaleInstance(d3, d2);
                font = g2.getFont().deriveFont(affineTransform);
            }
            if (n15 != 0) {
                d3 = (double)innerWidth / (double)(n15 * maxWidthWord);
                affineTransform = AffineTransform.getScaleInstance(d3, d2);
                font2 = g2.getFont().deriveFont(affineTransform);
            }
            int n17 = innerHeight / n16;
            int n18 = this.getRowInterval(request.getText(), font3, g2);
            FontMetrics fontMetrics3 = g2.getFontMetrics(font3);
            int n19 = this.getMaxWordWidth(chars, fontMetrics3);
            int n20 = (innerWidth - n19 * n11) / (n11 + 1);
            if (font != null) {
                fontMetrics2 = g2.getFontMetrics(font);
                n2 = this.getMaxWordWidth(chars, fontMetrics2);
                if (n13 > 1) {
                    n5 = (innerWidth - (n20 << 1) - n2 * n13) / (n13 - 1);
                }
            }
            if (font2 != null) {
                fontMetrics2 = g2.getFontMetrics(font2);
                n6 = this.getMaxWordWidth(chars, fontMetrics2);
                if (n15 > 1) {
                    n9 = (innerWidth - (n20 << 1) - n6 * n15) / (n15 - 1);
                }
            }
            this.drawFromLeftToRightOfFixCount(chars, font3, n19, n20, font, n2, n5, font2, n6, n9, n18, n17, request, g2);
        } else {
            int n21 = n11 + n13 + n15;
            double d4 = (double)innerWidth / (double)(n21 * maxWidthWord);
            double d5 = (double)innerHeight / (double)(n10 * fontMetrics.getHeight());
            AffineTransform affineTransform = AffineTransform.getScaleInstance(d4, d5);
            Font font4 = g2.getFont().deriveFont(affineTransform);
            int n22 = innerHeight / n10;
            int n23 = this.getRowInterval(request.getText(), font4, g2);
            int n24 = this.getMaxWordWidth(chars, g2.getFontMetrics(font4));
            if (n12 != 0) {
                d5 = (double)innerHeight / (double)(n12 * fontMetrics.getHeight());
                affineTransform = AffineTransform.getScaleInstance(d4, d5);
                font = g2.getFont().deriveFont(affineTransform);
                n3 = innerHeight / n12;
                n4 = this.getRowInterval(request.getText(), font, g2);
            }
            if (n14 != 0) {
                d5 = (double)innerHeight / (double)(n14 * fontMetrics.getHeight());
                affineTransform = AffineTransform.getScaleInstance(d4, d5);
                font2 = g2.getFont().deriveFont(affineTransform);
                n7 = innerHeight / n14;
                n8 = this.getRowInterval(request.getText(), font2, g2);
            }
            int n25 = (innerWidth - n21 * n24) / (n21 + 1);
            this.drawFromRightToLeftOfFixCount(chars, font4, n22, n23, n10, n11, font, n3, n4, n12, n13, font2, n7, n8, n15, n25, n24, request, g2);
        }
    }

    private void drawFromRightToLeftOfFixCount(char[] chars, Font oneFont, int onePartingLine, int oneRowInterval, int oneRow, int oneCol, Font twoFont, int twoPartingLine, int twoRowInterval, int twoRow, int twoCol, Font fixFont, int fixPartingLine, int fixRowInterval, int fixCol, int colInterval, int maxWordWidth, RectImageInnerRequest request, Graphics2D g2) {
        int n2 = oneCol + twoCol + fixCol;
        int n3 = request.getBorderWidth() + fixCol * maxWordWidth + twoCol * maxWordWidth + (oneCol - 1) * maxWordWidth + n2 * colInterval;
        int n4 = request.getBorderWidth() + onePartingLine - oneRowInterval;
        int n5 = request.getBorderWidth() + fixPartingLine - fixRowInterval;
        int n6 = twoFont == null ? n5 : request.getBorderWidth() + twoPartingLine - twoRowInterval;
        int n7 = 1;
        int n8 = n2;
        int n9 = n4;
        for (char c2 : chars) {
            if (n8 > twoCol + fixCol) {
                g2.setFont(oneFont);
                log.debug("rowCount = {}, colCount = {}, x = {}, y = {}", new Object[]{n7, n8, n3, n9});
                g2.drawString(String.valueOf(c2), n3, n9);
                n9 = request.getBorderWidth() + onePartingLine * ++n7 - oneRowInterval;
                if (n7 <= oneRow) continue;
                n7 = 1;
                n9 = --n8 <= twoCol + fixCol ? n6 : n4;
                n3 = n3 - colInterval - maxWordWidth;
                continue;
            }
            if (n8 > fixCol) {
                g2.setFont(twoFont);
                log.debug("rowCount = {}, colCount = {}, x = {}, y = {}", new Object[]{n7, n8, n3, n9});
                g2.drawString(String.valueOf(c2), n3, n9);
                n9 = request.getBorderWidth() + twoPartingLine * ++n7 - twoRowInterval;
                if (n7 <= twoRow) continue;
                n7 = 1;
                n9 = --n8 <= fixCol ? n5 : n6;
                n3 = n3 - colInterval - maxWordWidth;
                continue;
            }
            g2.setFont(fixFont);
            log.debug("rowCount = {}, colCount = {}, x = {}, y = {}", new Object[]{n7, n8, n3, n9});
            g2.drawString(String.valueOf(c2), n3, n9);
            n9 = request.getBorderWidth() + fixPartingLine * ++n7 - fixRowInterval;
        }
    }

    private void drawFromLeftToRightOfFixCount(char[] chars, Font oneFont, int oneMaxWordWidth, int oneColInterval, Font twoFont, int twoMaxWordWidth, int twoColInterval, Font fixFont, int fixMaxWordWidth, int fixColInterval, int rowInterval, int rowPartingLine, RectImageInnerRequest request, Graphics2D g2) {
        int n2 = request.getBorderWidth() + oneColInterval;
        int n3 = request.getBorderWidth() + rowPartingLine - rowInterval;
        int[] nArray = request.getGroupRowCol();
        int n4 = 1;
        int n5 = 1;
        int n6 = n2;
        for (char c2 : chars) {
            if (n5 <= nArray[0]) {
                g2.setFont(oneFont);
                log.debug("rowCount = {}, colCount = {}, x = {}, y = {}", new Object[]{n5, n4, n6, n3});
                g2.drawString(String.valueOf(c2), n6, n3);
                n6 += oneMaxWordWidth + oneColInterval;
                if (++n4 <= nArray[1]) continue;
                n3 = request.getBorderWidth() + rowPartingLine * ++n5 - rowInterval;
                n6 = n2;
                n4 = 1;
                continue;
            }
            if (n5 <= nArray[0] + nArray[2]) {
                g2.setFont(twoFont);
                log.debug("rowCount = {}, colCount = {}, x = {}, y = {}", new Object[]{n5, n4, n6, n3});
                g2.drawString(String.valueOf(c2), n6, n3);
                n6 += twoMaxWordWidth + twoColInterval;
                if (++n4 <= nArray[3]) continue;
                n4 = 1;
                n3 = request.getBorderWidth() + rowPartingLine * ++n5 - rowInterval;
                n6 = n2;
                continue;
            }
            g2.setFont(fixFont);
            log.debug("rowCount = {}, colCount = {}, x = {}, y = {}", new Object[]{n5, n4, n6, n3});
            g2.drawString(String.valueOf(c2), n6, n3);
            n6 += fixMaxWordWidth + fixColInterval;
            ++n4;
        }
    }

    private void drawBottomCode(int innerWidth, RectImageInnerRequest request, Graphics2D g2) {
        String string = request.getBottomCode();
        if (StringUtils.isBlank(string)) {
            return;
        }
        FontMetrics fontMetrics = g2.getFontMetrics(request.getFont());
        char[] cArray = string.toCharArray();
        int n2 = this.getMaxWordWidth(cArray, g2.getFontMetrics(request.getFont()));
        double d2 = request.getCodeWidth() / (float)n2;
        double d3 = request.getCodeHeight() / (float)fontMetrics.getAscent();
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d2, d3);
        Font font = g2.getFont().deriveFont(affineTransform);
        g2.setFont(font);
        fontMetrics = g2.getFontMetrics();
        n2 = this.getMaxWordWidth(cArray, fontMetrics);
        int n3 = cArray.length;
        int n4 = innerWidth - (n2 * n3 + (int)request.getCodeColInterval() * (n3 - 1));
        int n5 = 0;
        if (n4 > 0) {
            n5 = n4 >>> 1;
        }
        int n6 = request.getBorderWidth() + n5;
        int n7 = request.getHeight() - request.getBorderWidth() - Math.abs(fontMetrics.getDescent());
        for (char c2 : cArray) {
            g2.drawString(String.valueOf(c2), n6, n7);
            n6 = (int)((float)n6 + (request.getCodeWidth() + request.getCodeColInterval()));
        }
    }

    private void drawFromRightToLeftAndUpToDown(Font normalFont, int normalFontMaxWidth, int normalPartingLine, int normalRowInterval, Font pullFont, int pullFontMaxWidth, int pullPartingLine, int pullRowInterval, int colInterval, char[] chars, int[] groupRowCol, RectImageInnerRequest request, Graphics2D g2) {
        int n2 = 1;
        int n3 = request.getBorderWidth() + normalPartingLine - normalRowInterval;
        if (pullFont == null) {
            g2.setFont(normalFont);
            int n4 = request.getBorderWidth() + (groupRowCol[1] - 1) * normalFontMaxWidth + groupRowCol[1] * colInterval;
            int n5 = n3;
            for (char c2 : chars) {
                log.debug("x = {}, y = {}", (Object)n4, (Object)n5);
                g2.drawString(String.valueOf(c2), n4, n5);
                if (n2 == groupRowCol[0]) {
                    n2 = 1;
                    n5 = n3;
                    n4 = n4 - colInterval - normalFontMaxWidth;
                    continue;
                }
                n5 = request.getBorderWidth() + ++n2 * normalPartingLine - normalRowInterval;
            }
        } else {
            int n6;
            int n7;
            int n8;
            int n9;
            int n10 = groupRowCol[1] + groupRowCol[3];
            int n11 = 1;
            int n12 = request.getBorderWidth() + pullPartingLine - pullRowInterval;
            int n13 = 1;
            if (FontPullTypeEnum.MOST_LEFT.equals((Object)request.getFontPullType())) {
                n9 = groupRowCol[1] + 1;
                n8 = n10;
                n7 = request.getBorderWidth() + (groupRowCol[3] - 1) * pullFontMaxWidth + groupRowCol[3] * colInterval;
                n6 = n7 + pullFontMaxWidth + (groupRowCol[1] - 1) * normalFontMaxWidth + groupRowCol[1] * colInterval;
            } else {
                n6 = request.getBorderWidth() + (groupRowCol[1] - 1) * normalFontMaxWidth + groupRowCol[1] * colInterval;
                n7 = n6 + normalFontMaxWidth + (groupRowCol[3] - 1) * normalFontMaxWidth + groupRowCol[3] * colInterval;
                n9 = 1;
                n8 = groupRowCol[3];
            }
            log.debug("\u62c9\u4f38\u5b57\u4f53 pullColStart = {}, pullColEnd = {}", (Object)n9, (Object)n8);
            int n14 = n12;
            int n15 = n3;
            for (char c3 : chars) {
                if (n13 >= n9 && n13 <= n8) {
                    g2.setFont(pullFont);
                    log.debug("\u62c9\u4f38 x = {}, y = {}", (Object)n7, (Object)n14);
                    g2.drawString(String.valueOf(c3), n7, n14);
                    if (n11 == groupRowCol[2]) {
                        n11 = 1;
                        n14 = n12;
                        n7 = n7 - colInterval - pullFontMaxWidth;
                        ++n13;
                        continue;
                    }
                    n14 = request.getBorderWidth() + pullPartingLine * ++n11 - pullRowInterval;
                    continue;
                }
                g2.setFont(normalFont);
                log.debug("\u4e0d\u62c9\u4f38 x = {}, y = {}", (Object)n6, (Object)n15);
                g2.drawString(String.valueOf(c3), n6, n15);
                if (n2 == groupRowCol[0]) {
                    n2 = 1;
                    n15 = n3;
                    n6 = n6 - colInterval - normalFontMaxWidth;
                    ++n13;
                    continue;
                }
                n15 = request.getBorderWidth() + normalPartingLine * ++n2 - normalRowInterval;
            }
        }
    }

    private void drawFromLeftToRightAndUpToDown(Font normalFont, int normalFontMaxWidth, int normalPartingLine, int normalRowInterval, Font pullFont, int pullFontMaxWidth, int pullPartingLine, int pullRowInterval, int colInterval, char[] chars, int[] groupRowCol, RectImageInnerRequest request, Graphics2D g2) {
        int n2 = request.getBorderWidth() + colInterval;
        int n3 = 1;
        int n4 = request.getBorderWidth() + normalPartingLine - normalRowInterval;
        int n5 = groupRowCol[1] + groupRowCol[3];
        int n6 = 1;
        if (pullFont == null) {
            g2.setFont(normalFont);
            int n7 = n2;
            for (char c2 : chars) {
                log.debug("\u4e0d\u62c9\u4f38 x = {}, y = {}", (Object)n7, (Object)n4);
                g2.drawString(String.valueOf(c2), n7, n4);
                if (n6 == n5) {
                    n7 = n2;
                    n6 = 1;
                    n4 = request.getBorderWidth() + ++n3 * normalPartingLine - normalRowInterval;
                    continue;
                }
                n7 += normalFontMaxWidth + colInterval;
                ++n6;
            }
        } else {
            int n8;
            int n9;
            int n10;
            int n11 = 1;
            int n12 = request.getBorderWidth() + pullPartingLine - pullRowInterval;
            if (FontPullTypeEnum.MOST_LEFT.equals((Object)request.getFontPullType())) {
                n10 = 1;
                n9 = groupRowCol[3];
                n8 = n2;
                n2 += pullFontMaxWidth * groupRowCol[3] + colInterval * groupRowCol[3];
            } else {
                n10 = groupRowCol[1] + 1;
                n9 = n5;
                n8 = n2 + groupRowCol[1] * normalFontMaxWidth + groupRowCol[1] * colInterval;
            }
            log.debug("pullColStart = {}, pullColEnd = {}", (Object)n10, (Object)n9);
            int n13 = n8;
            int n14 = n2;
            for (char c3 : chars) {
                if (n6 >= n10 && n6 <= n9 && n11 <= groupRowCol[2]) {
                    g2.setFont(pullFont);
                    log.debug("\u62c9\u4f38 x = {}, y = {}", (Object)n13, (Object)n12);
                    g2.drawString(String.valueOf(c3), n13, n12);
                    n13 += pullFontMaxWidth + colInterval;
                } else {
                    g2.setFont(normalFont);
                    log.debug("\u4e0d\u62c9\u4f38 x = {}, y = {}", (Object)n14, (Object)n4);
                    g2.drawString(String.valueOf(c3), n14, n4);
                    n14 += normalFontMaxWidth + colInterval;
                }
                if (n6 == n5) {
                    n13 = n8;
                    n12 = request.getBorderWidth() + pullPartingLine * ++n11 - pullRowInterval;
                    n14 = n2;
                    n4 = request.getBorderWidth() + normalPartingLine * ++n3 - normalRowInterval;
                    n6 = 1;
                    continue;
                }
                ++n6;
            }
        }
    }

    @Override
    protected <T extends InnerRequest> void validateRequest(T request) {
        RectImageInnerRequest rectImageInnerRequest = (RectImageInnerRequest)request;
        if (StringUtils.isBlank(rectImageInnerRequest.getText())) {
            throw new SealSdkException("\u5370\u7ae0\u6b63\u6587\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (rectImageInnerRequest.getFont() == null) {
            throw new SealSdkException("\u5370\u7ae0\u6b63\u6587\u5b57\u4f53\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (rectImageInnerRequest.getGroupRowCol() == null) {
            throw new SealSdkException("groupRowCol \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (rectImageInnerRequest.getFontPullType() == null) {
            throw new SealSdkException("\u8bf7\u6307\u5b9a FontPullTypeEnum");
        }
        if (rectImageInnerRequest.getFontLayoutType() == null) {
            throw new SealSdkException("\u8bf7\u6307\u5b9a FontLayoutTypeEnum");
        }
    }

    protected int getRowInterval(String text, Font font, Graphics2D g2) {
        Rectangle2D rectangle2D = font.getStringBounds(text, g2.getFontRenderContext());
        int n2 = (int)Math.abs(rectangle2D.getMinY());
        int n3 = (int)rectangle2D.getMaxY();
        return (n2 - n3) / 3;
    }
}

