/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.esign.utils;

import com.timevale.esign.paas.esign.utils.MD5Util;
import com.timevale.esign.paas.esign.utils.coding.Coder;
import com.timevale.esign.paas.esign.utils.exception.ErrorsDiscriptor;
import com.timevale.esign.paas.esign.utils.exception.SuperException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HardwareUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(HardwareUtil.class);

    public static String getEquipId() {
        String string = "";
        Enumeration<NetworkInterface> enumeration = null;
        try {
            enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                if (!enumeration2.hasMoreElements()) continue;
                String string2 = HardwareUtil.getLocalMAC(enumeration2.nextElement());
                string = MD5Util.md5(string2);
            }
            return string;
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
            return string;
        }
    }

    public static String getDynamicEquipId() {
        String string = "";
        Enumeration<NetworkInterface> enumeration = null;
        try {
            Object object;
            enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = ((NetworkInterface)object).getInetAddresses();
                if (!enumeration2.hasMoreElements()) continue;
                string = HardwareUtil.getLocalMAC(enumeration2.nextElement());
            }
            object = new StringBuilder();
            ((StringBuilder)object).append(string).append(new Date().toString()).append(UUID.randomUUID().toString());
            return MD5Util.md5(((StringBuilder)object).toString());
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
            return "";
        }
    }

    public static String getLocalMAC() {
        String string = "";
        Enumeration<NetworkInterface> enumeration = null;
        try {
            enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                String string2;
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                if (!enumeration2.hasMoreElements()) continue;
                string = string2 = HardwareUtil.getLocalMAC(enumeration2.nextElement());
            }
            return string;
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
            return string;
        }
    }

    private static String getLocalMAC(InetAddress ia) throws SocketException {
        byte[] byArray = NetworkInterface.getByInetAddress(ia).getHardwareAddress();
        StringBuffer stringBuffer = new StringBuffer();
        if (null != byArray) {
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                String string;
                if (i2 != 0) {
                    stringBuffer.append(":");
                }
                stringBuffer.append((string = Integer.toHexString(byArray[i2] & 0xFF)).length() == 1 ? 0 + string : string);
            }
        }
        return stringBuffer.toString().toUpperCase();
    }

    public static String[] listMac() throws SuperException {
        String[] stringArray;
        Enumeration<NetworkInterface> enumeration;
        try {
            enumeration = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException socketException) {
            LOGGER.error("get network interface failed.", (Throwable)socketException);
            throw ErrorsDiscriptor.InternalService.e(socketException);
        }
        HashSet<String> hashSet = new HashSet<String>();
        try {
            while (enumeration.hasMoreElements()) {
                stringArray = enumeration.nextElement();
                if (null == stringArray || stringArray.isLoopback() || stringArray.isVirtual() || !stringArray.isUp()) continue;
                String string = Coder.BINARY.encode(stringArray.getHardwareAddress());
                hashSet.add(string);
            }
        }
        catch (SocketException socketException) {
            LOGGER.error("filter network interface failed.", (Throwable)socketException);
            throw ErrorsDiscriptor.InternalService.e(socketException);
        }
        stringArray = new String[hashSet.size()];
        return hashSet.toArray(stringArray);
    }
}

