/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.esign.utils.ca;

import com.timevale.esign.paas.esign.utils.Base64;
import com.timevale.esign.paas.esign.utils.ca.fisherman.FMSYS;
import com.timevale.esign.paas.esign.utils.security.provider.Provider;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.x509.X509Name;
import com.timevale.esign.paas.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.esign.paas.tgtext.bouncycastle.cert.jcajce.JcaCertStore;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.CMSProcessableByteArray;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.CMSSignedData;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.CMSSignedDataGenerator;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.SignerInformation;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.SignerInformationStore;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import com.timevale.esign.paas.tgtext.bouncycastle.jce.PKCS10CertificationRequest;
import com.timevale.esign.paas.tgtext.bouncycastle.util.Store;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.crypto.SecretKey;

public class SoftKeyTool {
    private static String iv = "1111111111111111";
    private PrivateKey privateKey = null;
    private PublicKey publicKey = null;

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public KeyPairGenerator generateKey() {
        KeyPairGenerator keyPairGenerator = null;
        try {
            keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(2048, new SecureRandom());
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            this.publicKey = keyPair.getPublic();
            this.privateKey = keyPair.getPrivate();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return keyPairGenerator;
    }

    public byte[] generatePKCS10(String cn2, String ou, String o2, String l2, String st, String c2) throws Exception {
        byte[] byArray = null;
        KeyPairGenerator keyPairGenerator = this.generateKey();
        if (null != keyPairGenerator) {
            String string = "CN=" + cn2;
            PKCS10CertificationRequest pKCS10CertificationRequest = new PKCS10CertificationRequest("MD5WithRSA", new X509Name(string), this.publicKey, null, this.privateKey);
            byArray = pKCS10CertificationRequest.getEncoded();
        }
        return byArray;
    }

    public static Certificate getCertFromFile(String fp2) {
        Certificate certificate = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(fp2);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            while (fileInputStream.available() > 0) {
                certificate = certificateFactory.generateCertificate(fileInputStream);
            }
            return certificate;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return certificate;
        }
    }

    public static String getInfoFromDn(String dn2, String key) {
        String string = "";
        String[] stringArray = dn2.split(",");
        if (stringArray.length > 0) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                stringArray[i2] = stringArray[i2].trim();
                if (!stringArray[i2].contains(key.toUpperCase() + "=")) continue;
                string = stringArray[i2].substring(stringArray[i2].indexOf(key.toUpperCase()) + key.length() + 1, stringArray[i2].length());
            }
        }
        return string;
    }

    public byte[] SymEncrypt(String keyalg, byte[] keybytes, byte[] indata) {
        byte[] byArray = null;
        try {
            FMSYS fMSYS = new FMSYS("BC");
            SecretKey secretKey = fMSYS.generatekey(keybytes, keyalg);
            if (secretKey != null) {
                byArray = fMSYS.sysenc(secretKey, keyalg.split("/").length >= 2 ? keyalg.split("/")[1] : "CBC", true, indata, iv.getBytes());
            }
            return byArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public byte[] SymDecrypt(String keyalg, byte[] keybytes, byte[] indata) {
        byte[] byArray = null;
        try {
            FMSYS fMSYS = new FMSYS("BC");
            SecretKey secretKey = fMSYS.generatekey(keybytes, keyalg);
            if (secretKey != null) {
                byArray = fMSYS.sysdec(secretKey, keyalg.split("/").length >= 2 ? keyalg.split("/")[1] : "CBC", true, indata, iv.getBytes());
            }
            return byArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean VerifySignedDataByP7(byte[] signedData) {
        boolean bl2 = false;
        try {
            CMSSignedData cMSSignedData = new CMSSignedData(signedData);
            Store<X509CertificateHolder> store = cMSSignedData.getCertificates();
            SignerInformationStore signerInformationStore = cMSSignedData.getSignerInfos();
            Collection<SignerInformation> collection = signerInformationStore.getSigners();
            for (SignerInformation signerInformation : collection) {
                Collection<X509CertificateHolder> collection2 = store.getMatches(signerInformation.getSID());
                Iterator<X509CertificateHolder> iterator = collection2.iterator();
                X509CertificateHolder x509CertificateHolder = iterator.next();
                if (signerInformation.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(x509CertificateHolder))) {
                    bl2 = true;
                    continue;
                }
                bl2 = false;
            }
        }
        catch (Exception exception) {
            bl2 = false;
            exception.printStackTrace();
        }
        return bl2;
    }

    public byte[] SignDataByP7(byte[] plaintxt, byte[] keybytes, byte[] certbytes, String signalg) {
        try {
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(keybytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            Signature signature = Signature.getInstance("RSA");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(certbytes);
            Certificate certificate = null;
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            while (((InputStream)byteArrayInputStream).available() > 0) {
                certificate = certificateFactory.generateCertificate(byteArrayInputStream);
            }
            ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
            arrayList.add(certificate);
            JcaCertStore jcaCertStore = new JcaCertStore(arrayList);
            CMSSignedDataGenerator cMSSignedDataGenerator = new CMSSignedDataGenerator();
            JcaSimpleSignerInfoGeneratorBuilder jcaSimpleSignerInfoGeneratorBuilder = new JcaSimpleSignerInfoGeneratorBuilder().setProvider("BC").setDirectSignature(true);
            cMSSignedDataGenerator.addSignerInfoGenerator(jcaSimpleSignerInfoGeneratorBuilder.build(signalg, privateKey, (X509Certificate)certificate));
            cMSSignedDataGenerator.addCertificates(jcaCertStore);
            CMSProcessableByteArray cMSProcessableByteArray = new CMSProcessableByteArray(plaintxt);
            CMSSignedData cMSSignedData = cMSSignedDataGenerator.generate(cMSProcessableByteArray, true);
            return cMSSignedData.getEncoded();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static byte[] pkcs1sign(byte[] keybytes, byte[] plainText, String signalg) {
        try {
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(keybytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            Signature signature = Signature.getInstance(signalg);
            signature.initSign(privateKey);
            signature.update(plainText);
            return signature.sign();
        }
        catch (Exception exception) {
            System.out.println("\u7b7e\u540d\u5931\u8d25");
            exception.printStackTrace();
            return null;
        }
    }

    public static boolean pkcs1verify(byte[] certbytes, byte[] plainText, byte[] signText, String signalg) {
        try {
            Signature signature = Signature.getInstance(signalg);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(certbytes);
            Certificate certificate = null;
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            while (((InputStream)byteArrayInputStream).available() > 0) {
                certificate = certificateFactory.generateCertificate(byteArrayInputStream);
            }
            if (certificate != null) {
                signature.initVerify(certificate.getPublicKey());
                signature.update(plainText);
                return signature.verify(signText);
            }
            return false;
        }
        catch (Throwable throwable) {
            System.out.println("\u6821\u9a8c\u7b7e\u540d\u5931\u8d25");
            throwable.printStackTrace();
            return false;
        }
    }

    public static boolean pkcs1verify(String cert, String plaintext, String signText, String signalg) {
        try {
            Signature signature = Signature.getInstance(signalg);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Base64.decode(cert));
            Certificate certificate = null;
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            while (((InputStream)byteArrayInputStream).available() > 0) {
                certificate = certificateFactory.generateCertificate(byteArrayInputStream);
            }
            if (cert != null) {
                signature.initVerify(certificate.getPublicKey());
                signature.update(Base64.decode(plaintext));
                return signature.verify(Base64.decode(signText));
            }
            return false;
        }
        catch (Throwable throwable) {
            System.out.println("\u6821\u9a8c\u7b7e\u540d\u5931\u8d25");
            throwable.printStackTrace();
            return false;
        }
    }

    public static void main(String[] args) {
        SoftKeyTool softKeyTool = new SoftKeyTool();
        boolean bl2 = softKeyTool.VerifySignedDataByP7(Base64.decode("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"));
        System.out.println(bl2);
    }

    static {
        Provider.BC.install();
    }
}

