/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.esign.utils.constant.type;

public enum Color {
    RED("red", 1, new int[]{255, 0, 0}),
    BLUE("blue", 2, new int[]{0, 0, 255}),
    BLACK("black", 3, new int[]{0, 0, 0}),
    GREED("green", 4, new int[]{0, 255, 0});

    private String color;
    private int intColor;
    private int[] rgb = new int[3];

    private Color(String color, int intColor, int[] rgb) {
        this.color = color;
        this.intColor = intColor;
        this.rgb[0] = rgb[0];
        this.rgb[1] = rgb[1];
        this.rgb[2] = rgb[2];
    }

    public String getColor() {
        return this.color;
    }

    public int getIntColor() {
        return this.intColor;
    }

    public java.awt.Color getAwtColor() {
        return new java.awt.Color(this.rgb[0], this.rgb[1], this.rgb[2]);
    }

    public static int getIntColorByString(String color) {
        return Color.from(color).getIntColor();
    }

    public static Color from(String name) {
        for (Color color : Color.values()) {
            if (!color.getColor().equalsIgnoreCase(name)) continue;
            return color;
        }
        return RED;
    }

    public static Color from(int value) {
        for (Color color : Color.values()) {
            if (color.getIntColor() != value) continue;
            return color;
        }
        return RED;
    }
}

