/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.esign.utils.httpclient;

import com.timevale.esign.paas.esign.utils.httpclient.HttpHeaderMgmt;
import com.timevale.esign.paas.esign.utils.httpclient.IRequestReady;
import com.timevale.esign.paas.esign.utils.httpclient.IResponseReady;
import com.timevale.esign.paas.esign.utils.httppool.HttpPool;
import com.timevale.esign.paas.esign.utils.timeunit.ITimeUnit;
import com.timevale.esign.paas.esign.utils.timeunit.TimeUnit;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;

public class HttpConfig {
    private int retry = 3;
    private String proxyIp;
    private int proxyPort;
    private String httpType;
    private ITimeUnit timeoutConnect = TimeUnit.MILLISECOND.unit(500);
    private ITimeUnit timeoutRequest = TimeUnit.SECOND.unit(3);
    private ITimeUnit timeoutPool = TimeUnit.MILLISECOND.unit(500);
    private String encoding = "UTF-8";
    private Credentials credentials = null;
    private AuthScope authScope = AuthScope.ANY;
    private HttpHeaderMgmt headerMgmt = null;
    private IRequestReady requestReady;
    private IResponseReady responseReady;
    private HttpPool httpPool;

    public HttpConfig clone() {
        return new HttpConfig().cloneFrom(this);
    }

    public HttpConfig cloneFrom(HttpConfig config) {
        this.setAuthScope(config.getAuthScope());
        this.setCredentials(config.getCredentials());
        this.setEncoding(config.getEncoding());
        this.setHttpType(config.getHttpType());
        this.setProxyIp(config.getProxyIp());
        this.setProxyPort(config.getProxyPort());
        this.setRequestReady(config.getRequestReady());
        this.setResponseReady(config.getResponseReady());
        this.setRetry(config.getRetry());
        this.setTimeoutConnect(config.getTimeoutConnect());
        this.setTimeoutPool(config.getTimeoutPool());
        this.setTimeoutRequest(config.getTimeoutRequest());
        this.setHttpPool(config.getHttpPool());
        if (null != config.getHeaderMgmt() && null != config.getHeaderMgmt().getHeaders()) {
            HttpHeaderMgmt httpHeaderMgmt = new HttpHeaderMgmt();
            httpHeaderMgmt.getHeaders().putAll(config.getHeaderMgmt().getHeaders());
            this.setHeaderMgmt(httpHeaderMgmt);
        }
        return this;
    }

    public int getRetry() {
        return this.retry;
    }

    public HttpConfig setRetry(int retry) {
        this.retry = retry;
        return this;
    }

    public String getProxyIp() {
        return this.proxyIp;
    }

    public HttpConfig setProxyIp(String proxyIp) {
        this.proxyIp = proxyIp;
        return this;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public HttpConfig setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        return this;
    }

    public String getHttpType() {
        return this.httpType;
    }

    public HttpConfig setHttpType(String httpType) {
        this.httpType = httpType;
        return this;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public HttpConfig setEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public AuthScope getAuthScope() {
        return this.authScope;
    }

    public void setAuthScope(AuthScope authScope) {
        this.authScope = authScope;
    }

    public HttpHeaderMgmt getHeaderMgmt() {
        return this.headerMgmt;
    }

    public void setHeaderMgmt(HttpHeaderMgmt headerMgmt) {
        this.headerMgmt = headerMgmt;
    }

    public IRequestReady getRequestReady() {
        return this.requestReady;
    }

    public IResponseReady getResponseReady() {
        return this.responseReady;
    }

    public void setRequestReady(IRequestReady requestReady) {
        this.requestReady = requestReady;
    }

    public void setResponseReady(IResponseReady responseReady) {
        this.responseReady = responseReady;
    }

    public ITimeUnit getTimeoutConnect() {
        return this.timeoutConnect;
    }

    public HttpConfig setTimeoutConnect(ITimeUnit timeoutConnect) {
        this.timeoutConnect = timeoutConnect;
        return this;
    }

    public ITimeUnit getTimeoutRequest() {
        return this.timeoutRequest;
    }

    public HttpConfig setTimeoutRequest(ITimeUnit timeoutRequest) {
        this.timeoutRequest = timeoutRequest;
        return this;
    }

    public ITimeUnit getTimeoutPool() {
        return this.timeoutPool;
    }

    public HttpConfig setTimeoutPool(ITimeUnit timeoutPool) {
        this.timeoutPool = timeoutPool;
        return this;
    }

    public HttpPool getHttpPool() {
        return this.httpPool;
    }

    public HttpConfig setHttpPool(HttpPool httpPool) {
        this.httpPool = httpPool;
        return this;
    }
}

