/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.esign.utils.httppool;

import com.timevale.esign.paas.esign.utils.asserts.AssertSupport;
import com.timevale.esign.paas.esign.utils.exception.ErrorsDiscriptor;
import com.timevale.esign.paas.esign.utils.exception.SuperException;
import com.timevale.esign.paas.esign.utils.httpclient.HttpConfig;
import com.timevale.esign.paas.esign.utils.network.NtmPoolConfigManager;
import com.timevale.esign.paas.esign.utils.network.NtmRouteConfig;
import com.timevale.esign.paas.esign.utils.timeunit.TimeUnit;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpPool {
    private PoolingHttpClientConnectionManager connectionManager;
    private NtmPoolConfigManager poolConfig;
    private static final int DEFAULT_TIMEOUT_CONNECT = (int)TimeUnit.MILLISECOND.unit(500).milliTick();
    private static final int DEFAULT_TIMEOUT_REQUEST = (int)TimeUnit.SECOND.unit(3).milliTick();
    private static final int DEFAULT_TIMEOUT_POOL = (int)TimeUnit.MILLISECOND.unit(500).milliTick();
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpPool.class);

    public HttpPool(int totalMax, int routeMax) {
        NtmPoolConfigManager ntmPoolConfigManager;
        this.poolConfig = ntmPoolConfigManager = new NtmPoolConfigManager().setDefaultMaxPerRouteConnection(routeMax).setMaxTotalConnection(totalMax);
    }

    public HttpPool() {
        this(20, 1);
    }

    public HttpPool(NtmPoolConfigManager poolConfig) {
        this.poolConfig = poolConfig;
    }

    public boolean hasInitialized() {
        return null != this.connectionManager;
    }

    public void destroy() {
        if (!this.hasInitialized()) {
            return;
        }
        this.connectionManager.shutdown();
        this.connectionManager.close();
        this.connectionManager = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableHttpClient client(HttpConfig conf) throws SuperException {
        if (this.hasInitialized()) {
            return this.build(this.connectionManager, conf);
        }
        HttpPool httpPool = this;
        synchronized (httpPool) {
            if (!this.hasInitialized()) {
                this.initManager(this.poolConfig);
            }
            return this.build(this.connectionManager, conf);
        }
    }

    private CloseableHttpClient build(PoolingHttpClientConnectionManager connectionManager, HttpConfig conf) {
        RequestConfig requestConfig = this.createRequestConfig(conf);
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig).setRetryHandler((HttpRequestRetryHandler)new RetryHandler(conf.getRetry()));
        if (null != conf.getCredentials()) {
            BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
            basicCredentialsProvider.setCredentials(conf.getAuthScope(), conf.getCredentials());
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
        }
        if (!StringUtils.isEmpty((String)conf.getProxyIp()) && 0 != conf.getProxyPort()) {
            httpClientBuilder.setProxy(new HttpHost(conf.getProxyIp(), conf.getProxyPort()));
            httpClientBuilder.setUserAgent("Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)");
        }
        return httpClientBuilder.build();
    }

    public CloseableHttpClient client() throws SuperException {
        return this.client(new HttpConfig());
    }

    public String printConfiguration() throws SuperException {
        AssertSupport.assertNotnull(this.poolConfig, ErrorsDiscriptor.MissingArgumentsSpec.e("http pool config"));
        return this.poolConfig.print();
    }

    private void initManager(NtmPoolConfigManager config) throws SuperException {
        Registry<ConnectionSocketFactory> registry = this.createSocketFactories();
        this.connectionManager = this.createConnectionManager(registry);
        this.connectionManager = this.configure(this.connectionManager, config);
    }

    private RequestConfig createRequestConfig(int connectTimeout, int requestTimeout, int socketTimeout) {
        return RequestConfig.custom().setConnectTimeout(connectTimeout).setConnectionRequestTimeout(requestTimeout).setSocketTimeout(socketTimeout).build();
    }

    private RequestConfig createRequestConfig(HttpConfig conf) {
        int n2 = (int)(null == conf.getTimeoutConnect() ? (long)DEFAULT_TIMEOUT_CONNECT : conf.getTimeoutConnect().milliTick());
        int n3 = (int)(null == conf.getTimeoutRequest() ? (long)DEFAULT_TIMEOUT_REQUEST : conf.getTimeoutRequest().milliTick());
        int n4 = (int)(null == conf.getTimeoutPool() ? (long)DEFAULT_TIMEOUT_POOL : conf.getTimeoutPool().milliTick());
        return this.createRequestConfig(n2, n4, n3);
    }

    private PoolingHttpClientConnectionManager createConnectionManager(Registry<ConnectionSocketFactory> socketFactoryRegistry) {
        PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        return poolingHttpClientConnectionManager;
    }

    private PoolingHttpClientConnectionManager configure(PoolingHttpClientConnectionManager mgr, NtmPoolConfigManager configMgr) {
        LOGGER.info("configure pool. {}", (Object)configMgr.print());
        mgr.setValidateAfterInactivity(1000);
        mgr.setMaxTotal(configMgr.getMaxTotalConnection().intValue());
        mgr.setDefaultMaxPerRoute(configMgr.getDefaultMaxPerRouteConnection().intValue());
        Collection<NtmRouteConfig> collection = configMgr.getAllRoutes();
        for (NtmRouteConfig ntmRouteConfig : collection) {
            mgr.setMaxPerRoute(ntmRouteConfig.toHttpRoute(), ntmRouteConfig.getMaxConnection());
        }
        return mgr;
    }

    private Registry<ConnectionSocketFactory> createSocketFactories() throws SuperException {
        SSLContext sSLContext;
        try {
            sSLContext = new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)SeldefTrustStrategy.INSTANCE).build();
        }
        catch (Exception exception) {
            LOGGER.error("create ssl context failed.", (Throwable)exception);
            throw ErrorsDiscriptor.InternalService.e(exception);
        }
        SSLConnectionSocketFactory sSLConnectionSocketFactory = new SSLConnectionSocketFactory(sSLContext, (HostnameVerifier)SeldefHostnameVerifier.INSTANCE);
        return RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sSLConnectionSocketFactory).build();
    }

    private class RetryHandler
    implements HttpRequestRetryHandler {
        private int retry;

        public RetryHandler(int retry) {
            this.retry = retry;
        }

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            try {
                Thread.sleep(executionCount * 300);
            }
            catch (InterruptedException interruptedException) {
                LOGGER.warn("retry in delay failed.", (Throwable)interruptedException);
            }
            return executionCount < this.retry;
        }
    }

    private static enum SeldefHostnameVerifier implements HostnameVerifier
    {
        INSTANCE;


        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    private static enum SeldefTrustStrategy implements TrustStrategy
    {
        INSTANCE;


        public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            return true;
        }
    }
}

