/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.esign.utils.modeladapter.adapter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.timevale.esign.paas.esign.a.a.c;
import com.timevale.esign.paas.esign.utils.ConfigProperties;
import com.timevale.esign.paas.esign.utils.EsignSubmit;
import com.timevale.esign.paas.esign.utils.HardwareUtil;
import com.timevale.esign.paas.esign.utils.ITimerEvents;
import com.timevale.esign.paas.esign.utils.MD5Util;
import com.timevale.esign.paas.esign.utils.StringUtil;
import com.timevale.esign.paas.esign.utils.bean.Result;
import com.timevale.esign.paas.esign.utils.exception.ErrorsDiscriptor;
import com.timevale.esign.paas.esign.utils.exception.Oauth2Exception;
import com.timevale.esign.paas.esign.utils.exception.SuperException;
import com.timevale.esign.paas.esign.utils.http.PostParameter;
import com.timevale.esign.paas.esign.utils.httpclient.HttpConfig;
import com.timevale.esign.paas.esign.utils.httpclient.HttpUtil;
import com.timevale.esign.paas.esign.utils.modeladapter.impl.GetOpenAPIUrl;
import com.timevale.esign.paas.esign.utils.modeladapter.impl.GetOpenAPIUrlTask;
import com.timevale.esign.paas.esign.utils.modeladapter.impl.Oauth2;
import com.timevale.esign.paas.esign.utils.modeladapter.impl.Oauth2Config;
import com.timevale.esign.paas.esign.utils.modeladapter.impl.UrlBuilder;
import com.timevale.esign.paas.esign.utils.modeladapter.model.AbstractModelType;
import com.timevale.esign.paas.esign.utils.modeladapter.model.SuperModel;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class Adapter
extends Oauth2 {
    private static final Logger LOGGER = LoggerFactory.getLogger(Adapter.class);
    private static final String EQUIP_ID = HardwareUtil.getEquipId();
    private static Map<String, String> TOKEN_CACHE = new HashMap<String, String>();
    private static volatile Timer updateTimer = null;
    private String clientEquipId = null;
    private HttpConfig config;
    private long AUTO_LOGIN_PERIOD = 86400000L;

    private Adapter() {
    }

    public static Adapter instance() {
        return NetworkAdapaterFactory.INSTANCE;
    }

    public void init(AbstractModelType[] models, String projId, String projSecret, String apisUrl, String redirectUri, String notifyUrl) throws SuperException {
        this.init(models, projId, projSecret, apisUrl, redirectUri, notifyUrl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(AbstractModelType[] models, String projId, String projSecret, String apisUrl, String redirectUri, String notifyUrl, ITimerEvents timerEvents) throws SuperException {
        Object object;
        Oauth2Config.setApisUrl(apisUrl);
        Oauth2Config.setProjectId(projId);
        Oauth2Config.setProjectSecret(projSecret);
        Oauth2Config.setRedirectUrl(redirectUri);
        ConfigProperties configProperties = new ConfigProperties("systemconfig.properties");
        if (!StringUtil.isNull(notifyUrl) && ((Result)(object = Adapter.notifyUrlCheck(notifyUrl, configProperties.getString("asynchNotifyUrl")))).getErrCode() != 0) {
            throw ErrorsDiscriptor.ExternalServiceTaken.e(((Result)object).getErrCode(), ((Result)object).getMsg());
        }
        object = new GetOpenAPIUrl(models);
        ((GetOpenAPIUrl)object).getUrlInfo(projId, projSecret, apisUrl);
        if (null == updateTimer) {
            Adapter adapter = this;
            synchronized (adapter) {
                if (null != updateTimer) {
                    return;
                }
                updateTimer = new Timer(true);
                updateTimer.schedule((TimerTask)new GetOpenAPIUrlTask(models, projId, projSecret, apisUrl, timerEvents), this.AUTO_LOGIN_PERIOD, this.AUTO_LOGIN_PERIOD);
            }
        }
    }

    public void login(String account, String token) {
        this.setToken(account, token);
    }

    public void login(String account, String token, String equipId) {
        this.setClientEquipId(equipId);
        this.login(account, token);
    }

    public String logout(String account) {
        return this.removeToken(account);
    }

    public void logout() {
        this.clearToken();
    }

    public boolean check(String account) {
        String string = this.getToken(account);
        return null != string && !string.isEmpty();
    }

    public String token(String accountId) {
        return this.getToken(accountId);
    }

    public JsonObject run(String account, SuperModel model) throws SuperException {
        return HttpUtil.postBody(model.getMethod(), model.getUrl(), this.initContent(account, model.getJson()), this.getConfigOrDefault());
    }

    public JsonObject getUrl(String account, SuperModel model) throws SuperException {
        this.initModel(account, model);
        String string = new UrlBuilder(model.getUrl(), model).build();
        return HttpUtil.getBody(model.getMethod(), string, this.getConfigOrDefault());
    }

    public JsonObject runUrl(String account, SuperModel model) throws SuperException {
        this.initModel(account, model);
        String string = new UrlBuilder(model.getUrl(), model).build();
        return HttpUtil.postBody(model.getMethod(), string, model.getJson(), this.getConfigOrDefault());
    }

    public JsonObject submit(String account, SuperModel model) throws SuperException {
        return HttpUtil.postSubmit(model.getMethod(), model.getUrl(), this.initContent(account, model.getJson()), this.getConfigOrDefault());
    }

    public JsonObject submitMultipart(String account, SuperModel model) throws SuperException {
        return HttpUtil.postSubmit(model.getMethod(), model.getUrl(), this.initContent(account, model.getJson()), model.getExtends(), this.getConfigOrDefault());
    }

    public String createSubmit(String account, SuperModel model) {
        JsonObject jsonObject = this.initContent(account, model.getJson());
        return EsignSubmit.buildForm(this.convertToMap(jsonObject), model.getUrl(), "post", "submit");
    }

    public HttpConfig getConfig() {
        return this.config;
    }

    public void setConfig(HttpConfig config) {
        this.config = config;
    }

    public void setClientEquipId(String clientEquipId) {
        if (null == clientEquipId) {
            LOGGER.warn("input client equip id is null.");
        }
        this.clientEquipId = clientEquipId;
    }

    private JsonObject initContent(String account, JsonObject content) {
        if (null != account) {
            String string = this.getToken(account);
            String string2 = MD5Util.md5(EQUIP_ID + string);
            content.addProperty("token", string);
            content.addProperty("md5", string2);
        }
        if (!content.has("equipId")) {
            content.addProperty("equipId", this.getClientEquipId());
        }
        return content;
    }

    private void initModel(String account, SuperModel model) {
        if (null != account) {
            String string = this.getToken(account);
            String string2 = MD5Util.md5(EQUIP_ID + string);
            model.addParamOptional("token", string);
            model.addParamOptional("md5", string2);
        }
        if (!model.has("equipId")) {
            model.addParamOptional("equipId", this.getClientEquipId());
        }
    }

    private Map<String, String> convertToMap(JsonObject input) {
        Set set = input.entrySet();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry entry : set) {
            hashMap.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
        }
        return hashMap;
    }

    private HttpConfig getConfigOrDefault() {
        return null == this.config ? new HttpConfig() : this.config;
    }

    private String getClientEquipId() {
        if (StringUtil.isNull(this.clientEquipId)) {
            return EQUIP_ID;
        }
        return this.clientEquipId;
    }

    public static Result notifyUrlCheck(String notifyUrl, String asynchNotifyUrl) {
        Result result = new Result();
        if (!StringUtil.isNull(asynchNotifyUrl)) {
            try {
                PostParameter[] postParameterArray = new PostParameter[]{new PostParameter("projectId", Oauth2Config.getProjectId()), new PostParameter("url", notifyUrl)};
                JSONObject jSONObject = HTTP_CLIENT.post(asynchNotifyUrl, postParameterArray, false).asJSONObject();
                if (jSONObject.getInt("errCode") != 0) {
                    result.setErrCode(jSONObject.getInt("errCode"));
                    result.setMsg(jSONObject.getString("msg"));
                    return result;
                }
                Oauth2Config.setNotifyUrl(notifyUrl);
            }
            catch (Oauth2Exception oauth2Exception) {
                LOGGER.error("notifyUrl check failed.", (Throwable)oauth2Exception);
                result.setErrCode(3025);
                result.setMsg(c.cK(3025));
                return result;
            }
        } else {
            result.setErrCode(3029);
            result.setMsg(c.cK(3029));
        }
        return result;
    }

    public void setToken(String accountId, String token) {
        TOKEN_CACHE.put(accountId, token);
    }

    public String getToken(String accountId) {
        return TOKEN_CACHE.get(accountId);
    }

    private void clearToken() {
        TOKEN_CACHE.clear();
    }

    private String removeToken(String accountId) {
        return TOKEN_CACHE.remove(accountId);
    }

    public String getEquipId() {
        return EQUIP_ID;
    }

    private static class NetworkAdapaterFactory {
        private static final Adapter INSTANCE = new Adapter();

        private NetworkAdapaterFactory() {
        }
    }
}

